/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.PowerManager;
import android.os.Process;
import android.os.StatFs;
import android.os.UserManager;
import android.provider.Settings;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.TextView;
import java.lang.reflect.Method;
import org.chromium.base.BuildInfo;
import org.chromium.base.ThreadUtils;

@TargetApi(value=21)
public class ApiCompatibilityUtils {
    private ApiCompatibilityUtils() {
    }

    public static boolean isLayoutRtl(View view) {
        if (Build.VERSION.SDK_INT >= 17) {
            return view.getLayoutDirection() == 1;
        }
        return false;
    }

    public static int getLayoutDirection(Configuration configuration) {
        if (Build.VERSION.SDK_INT >= 17) {
            return configuration.getLayoutDirection();
        }
        return 0;
    }

    public static boolean isPrintingSupported() {
        return Build.VERSION.SDK_INT >= 19;
    }

    public static boolean isElevationSupported() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static void setLayoutDirection(View view, int layoutDirection) {
        if (Build.VERSION.SDK_INT >= 17) {
            view.setLayoutDirection(layoutDirection);
        }
    }

    public static void setTextAlignment(View view, int textAlignment) {
        if (Build.VERSION.SDK_INT >= 17) {
            view.setTextAlignment(textAlignment);
        }
    }

    public static void setTextDirection(View view, int textDirection) {
        if (Build.VERSION.SDK_INT >= 17) {
            view.setTextDirection(textDirection);
        }
    }

    public static void setLabelFor(View labelView, int id2) {
        if (Build.VERSION.SDK_INT >= 17) {
            labelView.setLabelFor(id2);
        }
    }

    public static void setMarginEnd(ViewGroup.MarginLayoutParams layoutParams, int end) {
        if (Build.VERSION.SDK_INT >= 17) {
            layoutParams.setMarginEnd(end);
        } else {
            layoutParams.rightMargin = end;
        }
    }

    public static int getMarginEnd(ViewGroup.MarginLayoutParams layoutParams) {
        if (Build.VERSION.SDK_INT >= 17) {
            return layoutParams.getMarginEnd();
        }
        return layoutParams.rightMargin;
    }

    public static void setMarginStart(ViewGroup.MarginLayoutParams layoutParams, int start) {
        if (Build.VERSION.SDK_INT >= 17) {
            layoutParams.setMarginStart(start);
        } else {
            layoutParams.leftMargin = start;
        }
    }

    public static int getMarginStart(ViewGroup.MarginLayoutParams layoutParams) {
        if (Build.VERSION.SDK_INT >= 17) {
            return layoutParams.getMarginStart();
        }
        return layoutParams.leftMargin;
    }

    public static void setPaddingRelative(View view, int start, int top, int end, int bottom) {
        if (Build.VERSION.SDK_INT >= 17) {
            view.setPaddingRelative(start, top, end, bottom);
        } else {
            view.setPadding(start, top, end, bottom);
        }
    }

    public static int getPaddingStart(View view) {
        if (Build.VERSION.SDK_INT >= 17) {
            return view.getPaddingStart();
        }
        return view.getPaddingLeft();
    }

    public static int getPaddingEnd(View view) {
        if (Build.VERSION.SDK_INT >= 17) {
            return view.getPaddingEnd();
        }
        return view.getPaddingRight();
    }

    public static void setCompoundDrawablesRelative(TextView textView, Drawable start, Drawable top, Drawable end, Drawable bottom) {
        if (Build.VERSION.SDK_INT == 17) {
            boolean isRtl = ApiCompatibilityUtils.isLayoutRtl((View)textView);
            textView.setCompoundDrawables(isRtl ? end : start, top, isRtl ? start : end, bottom);
        } else if (Build.VERSION.SDK_INT > 17) {
            textView.setCompoundDrawablesRelative(start, top, end, bottom);
        } else {
            textView.setCompoundDrawables(start, top, end, bottom);
        }
    }

    public static void setCompoundDrawablesRelativeWithIntrinsicBounds(TextView textView, Drawable start, Drawable top, Drawable end, Drawable bottom) {
        if (Build.VERSION.SDK_INT == 17) {
            boolean isRtl = ApiCompatibilityUtils.isLayoutRtl((View)textView);
            textView.setCompoundDrawablesWithIntrinsicBounds(isRtl ? end : start, top, isRtl ? start : end, bottom);
        } else if (Build.VERSION.SDK_INT > 17) {
            textView.setCompoundDrawablesRelativeWithIntrinsicBounds(start, top, end, bottom);
        } else {
            textView.setCompoundDrawablesWithIntrinsicBounds(start, top, end, bottom);
        }
    }

    public static void setCompoundDrawablesRelativeWithIntrinsicBounds(TextView textView, int start, int top, int end, int bottom) {
        if (Build.VERSION.SDK_INT == 17) {
            boolean isRtl = ApiCompatibilityUtils.isLayoutRtl((View)textView);
            textView.setCompoundDrawablesWithIntrinsicBounds(isRtl ? end : start, top, isRtl ? start : end, bottom);
        } else if (Build.VERSION.SDK_INT > 17) {
            textView.setCompoundDrawablesRelativeWithIntrinsicBounds(start, top, end, bottom);
        } else {
            textView.setCompoundDrawablesWithIntrinsicBounds(start, top, end, bottom);
        }
    }

    public static String getCreatorPackage(PendingIntent intent) {
        if (Build.VERSION.SDK_INT >= 17) {
            return intent.getCreatorPackage();
        }
        return intent.getTargetPackage();
    }

    @TargetApi(value=17)
    public static boolean isDeviceProvisioned(Context context) {
        if (Build.VERSION.SDK_INT < 17) {
            return true;
        }
        if (context == null) {
            return true;
        }
        if (context.getContentResolver() == null) {
            return true;
        }
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"device_provisioned", (int)0) != 0;
    }

    public static void finishAndRemoveTask(Activity activity) {
        if (Build.VERSION.SDK_INT > 21) {
            activity.finishAndRemoveTask();
        } else if (Build.VERSION.SDK_INT == 21) {
            new FinishAndRemoveTaskWithRetry(activity).run();
        } else {
            activity.finish();
        }
    }

    @TargetApi(value=21)
    public static boolean setElevation(View view, float elevationValue) {
        if (!ApiCompatibilityUtils.isElevationSupported()) {
            return false;
        }
        view.setElevation(elevationValue);
        return true;
    }

    public static boolean isInteractive(Context context) {
        PowerManager manager = (PowerManager)context.getSystemService("power");
        if (Build.VERSION.SDK_INT >= 20) {
            return manager.isInteractive();
        }
        return manager.isScreenOn();
    }

    public static int getActivityNewDocumentFlag() {
        if (Build.VERSION.SDK_INT >= 21) {
            return 524288;
        }
        return 524288;
    }

    public static boolean shouldSkipFirstUseHints(ContentResolver contentResolver) {
        if (Build.VERSION.SDK_INT >= 21) {
            return Settings.Secure.getInt((ContentResolver)contentResolver, (String)"skip_first_use_hints", (int)0) != 0;
        }
        return false;
    }

    public static void setTaskDescription(Activity activity, String title, Bitmap icon, int color2) {
        assert (Color.alpha((int)color2) == 255);
        if (Build.VERSION.SDK_INT >= 21) {
            ActivityManager.TaskDescription description = new ActivityManager.TaskDescription(title, icon, color2);
            activity.setTaskDescription(description);
        }
    }

    public static void setStatusBarColor(Window window, int statusBarColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (statusBarColor == -16777216 && window.getNavigationBarColor() == -16777216) {
                window.clearFlags(Integer.MIN_VALUE);
            } else {
                window.addFlags(Integer.MIN_VALUE);
            }
            window.setStatusBarColor(statusBarColor);
        }
    }

    public static Drawable getDrawable(Resources res, int id2) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT >= 21) {
            return res.getDrawable(id2, null);
        }
        return res.getDrawable(id2);
    }

    public static Drawable getDrawableForDensity(Resources res, int id2, int density) {
        if (Build.VERSION.SDK_INT >= 21) {
            return res.getDrawableForDensity(id2, density, null);
        }
        return res.getDrawableForDensity(id2, density);
    }

    public static void finishAfterTransition(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            activity.finishAfterTransition();
        } else {
            activity.finish();
        }
    }

    public static Drawable getUserBadgedIcon(Context context, int id2) {
        Drawable drawable2 = ApiCompatibilityUtils.getDrawable(context.getResources(), id2);
        if (Build.VERSION.SDK_INT >= 21) {
            PackageManager packageManager = context.getPackageManager();
            drawable2 = packageManager.getUserBadgedIcon(drawable2, Process.myUserHandle());
        }
        return drawable2;
    }

    public static Drawable getUserBadgedDrawableForDensity(Context context, Drawable drawable2, Rect badgeLocation, int density) {
        if (Build.VERSION.SDK_INT >= 21) {
            PackageManager packageManager = context.getPackageManager();
            return packageManager.getUserBadgedDrawableForDensity(drawable2, Process.myUserHandle(), badgeLocation, density);
        }
        return drawable2;
    }

    public static int getColor(Resources res, int id2) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT >= 23) {
            return res.getColor(id2, null);
        }
        return res.getColor(id2);
    }

    public static ColorFilter getColorFilter(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 21) {
            return drawable2.getColorFilter();
        }
        return null;
    }

    public static ColorStateList getColorStateList(Resources res, int id2) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT >= 23) {
            return res.getColorStateList(id2, null);
        }
        return res.getColorStateList(id2);
    }

    public static void setTextAppearance(TextView view, int id2) {
        if (Build.VERSION.SDK_INT >= 23) {
            view.setTextAppearance(id2);
        } else {
            view.setTextAppearance(view.getContext(), id2);
        }
    }

    public static long getBlockCount(StatFs statFs) {
        if (Build.VERSION.SDK_INT >= 19) {
            return statFs.getBlockCountLong();
        }
        return statFs.getBlockCount();
    }

    public static long getBlockSize(StatFs statFs) {
        if (Build.VERSION.SDK_INT >= 19) {
            return statFs.getBlockSizeLong();
        }
        return statFs.getBlockSize();
    }

    public static boolean isDemoUser(Context context) {
        if (!BuildInfo.isGreaterThanN()) {
            return false;
        }
        try {
            UserManager userManager = (UserManager)context.getSystemService("user");
            Method isDemoUserMethod = UserManager.class.getMethod("isDemoUser", new Class[0]);
            boolean isDemoUser = (Boolean)isDemoUserMethod.invoke((Object)userManager, new Object[0]);
            return isDemoUser;
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static int checkPermission(Context context, String permission, int pid, int uid) {
        try {
            return context.checkPermission(permission, pid, uid);
        }
        catch (RuntimeException e) {
            return -1;
        }
    }

    private static class FinishAndRemoveTaskWithRetry
    implements Runnable {
        private static final long RETRY_DELAY_MS = 500L;
        private static final long MAX_TRY_COUNT = 3L;
        private final Activity mActivity;
        private int mTryCount;

        FinishAndRemoveTaskWithRetry(Activity activity) {
            this.mActivity = activity;
        }

        @Override
        public void run() {
            this.mActivity.finishAndRemoveTask();
            ++this.mTryCount;
            if (!this.mActivity.isFinishing()) {
                if ((long)this.mTryCount < 3L) {
                    ThreadUtils.postOnUiThreadDelayed(this, 500L);
                } else {
                    this.mActivity.finish();
                }
            }
        }
    }
}

