/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.util.Log;
import java.io.IOException;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="base::android")
public class ApkAssets {
    private static final String LOGTAG = "ApkAssets";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public static long[] open(Context context, String fileName) {
        AssetFileDescriptor afd = null;
        try {
            AssetManager manager = context.getAssets();
            afd = manager.openNonAssetFd(fileName);
            long[] lArray = new long[]{afd.getParcelFileDescriptor().detachFd(), afd.getStartOffset(), afd.getLength()};
            return lArray;
        }
        catch (IOException e) {
            if (!e.getMessage().equals("") && !e.getMessage().equals(fileName)) {
                Log.e((String)LOGTAG, (String)("Error while loading asset " + fileName + ": " + e));
            }
            long[] lArray = new long[]{-1L, -1L, -1L};
            return lArray;
        }
        finally {
            try {
                if (afd != null) {
                    afd.close();
                }
            }
            catch (IOException e2) {
                Log.e((String)LOGTAG, (String)"Unable to close AssetFileDescriptor", (Throwable)e2);
            }
        }
    }
}

