/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import java.io.File;
import org.chromium.base.CommandLine;
import org.chromium.base.Log;
import org.chromium.base.annotations.SuppressFBWarnings;

public final class CommandLineInitUtil {
    private static final String TAG = "CommandLineInitUtil";
    private static final String COMMAND_LINE_FILE_PATH = "/data/local";
    private static final String COMMAND_LINE_FILE_PATH_DEBUG_APP = "/data/local/tmp";

    private CommandLineInitUtil() {
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    public static void initCommandLine(Context context, String fileName) {
        if (!CommandLine.isInitialized()) {
            File commandLineFile = CommandLineInitUtil.getAlternativeCommandLinePath(context, fileName);
            if (commandLineFile == null) {
                commandLineFile = new File(COMMAND_LINE_FILE_PATH, fileName);
            }
            CommandLine.initFromFile(commandLineFile.getPath());
        }
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private static File getAlternativeCommandLinePath(Context context, String fileName) {
        File alternativeCommandLineFile = new File(COMMAND_LINE_FILE_PATH_DEBUG_APP, fileName);
        if (!alternativeCommandLineFile.exists()) {
            return null;
        }
        try {
            String debugApp;
            String string2 = debugApp = Build.VERSION.SDK_INT < 17 ? CommandLineInitUtil.getDebugAppPreJBMR1(context) : CommandLineInitUtil.getDebugAppJBMR1(context);
            if (debugApp != null && debugApp.equals(context.getApplicationContext().getPackageName())) {
                Log.i(TAG, "Using alternative command line file in " + alternativeCommandLineFile.getPath(), new Object[0]);
                return alternativeCommandLineFile;
            }
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Unable to detect alternative command line file", new Object[0]);
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    private static String getDebugAppJBMR1(Context context) {
        boolean adbEnabled;
        boolean bl = adbEnabled = Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"adb_enabled", (int)0) == 1;
        if (adbEnabled) {
            return Settings.Global.getString((ContentResolver)context.getContentResolver(), (String)"debug_app");
        }
        return null;
    }

    private static String getDebugAppPreJBMR1(Context context) {
        boolean adbEnabled;
        boolean bl = adbEnabled = Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"adb_enabled", (int)0) == 1;
        if (adbEnabled) {
            return Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"debug_app");
        }
        return null;
    }
}

