/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import org.chromium.base.Log;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="base::android")
public class ContextUtils {
    private static final String TAG = "ContextUtils";
    private static Context sApplicationContext;

    public static Context getApplicationContext() {
        return sApplicationContext;
    }

    public static void initApplicationContext(Context appContext) {
        if (sApplicationContext != null && sApplicationContext != appContext) {
            Log.d(TAG, "Multiple contexts detected, ignoring new application context.");
            return;
        }
        ContextUtils.initJavaSideApplicationContext(appContext);
    }

    public static void initApplicationContextForNative() {
        if (sApplicationContext == null) {
            throw new RuntimeException("Cannot have native global application context be null.");
        }
        ContextUtils.nativeInitNativeSideApplicationContext(sApplicationContext);
    }

    private static SharedPreferences fetchAppSharedPreferences() {
        return PreferenceManager.getDefaultSharedPreferences((Context)sApplicationContext);
    }

    public static SharedPreferences getAppSharedPreferences() {
        return Holder.sSharedPreferences;
    }

    @VisibleForTesting
    public static void initApplicationContextForTests(Context appContext) {
        ContextUtils.initJavaSideApplicationContext(appContext);
        Holder.sSharedPreferences = ContextUtils.fetchAppSharedPreferences();
    }

    private static void initJavaSideApplicationContext(Context appContext) {
        if (appContext == null) {
            throw new RuntimeException("Global application context cannot be set to null.");
        }
        sApplicationContext = appContext;
    }

    private static native void nativeInitNativeSideApplicationContext(Context var0);

    static /* synthetic */ SharedPreferences access$000() {
        return ContextUtils.fetchAppSharedPreferences();
    }

    private static class Holder {
        private static SharedPreferences sSharedPreferences = ContextUtils.access$000();

        private Holder() {
        }
    }
}

