/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.AsyncTask;
import android.os.Environment;
import android.os.StrictMode;
import android.os.SystemClock;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.MainDex;
import org.chromium.base.metrics.RecordHistogram;

@MainDex
public abstract class PathUtils {
    private static final String THUMBNAIL_DIRECTORY_NAME = "textures";
    private static final int DATA_DIRECTORY = 0;
    private static final int THUMBNAIL_DIRECTORY = 1;
    private static final int DATABASE_DIRECTORY = 2;
    private static final int CACHE_DIRECTORY = 3;
    private static final int NUM_DIRECTORIES = 4;
    private static final AtomicBoolean sInitializationStarted = new AtomicBoolean();
    private static AsyncTask<Void, Void, String[]> sDirPathFetchTask;
    private static Context sDataDirectoryAppContext;
    private static String sDataDirectorySuffix;

    private PathUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] getOrComputeDirectoryPaths() {
        try {
            if (!sDirPathFetchTask.cancel(false)) return (String[])sDirPathFetchTask.get();
            StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
            StrictMode.allowThreadDiskWrites();
            try {
                String[] stringArray = PathUtils.setPrivateDataDirectorySuffixInternal();
                return stringArray;
            }
            finally {
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
            }
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return null;
    }

    private static String[] setPrivateDataDirectorySuffixInternal() {
        String[] paths = new String[4];
        paths[0] = sDataDirectoryAppContext.getDir(sDataDirectorySuffix, 0).getPath();
        paths[1] = sDataDirectoryAppContext.getDir(THUMBNAIL_DIRECTORY_NAME, 0).getPath();
        paths[2] = sDataDirectoryAppContext.getDatabasePath("foo").getParent();
        if (sDataDirectoryAppContext.getCacheDir() != null) {
            paths[3] = sDataDirectoryAppContext.getCacheDir().getPath();
        }
        return paths;
    }

    public static void setPrivateDataDirectorySuffix(String suffix, Context context) {
        if (!sInitializationStarted.getAndSet(true)) {
            sDataDirectorySuffix = suffix;
            sDataDirectoryAppContext = context.getApplicationContext();
            sDirPathFetchTask = new AsyncTask<Void, Void, String[]>(){

                protected String[] doInBackground(Void ... unused) {
                    return PathUtils.setPrivateDataDirectorySuffixInternal();
                }
            }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
        }
    }

    private static String getDirectoryPath(int index) {
        return Holder.DIRECTORY_PATHS[index];
    }

    @CalledByNative
    public static String getDataDirectory(Context appContext) {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(0);
    }

    @CalledByNative
    public static String getDatabaseDirectory(Context appContext) {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(2);
    }

    @CalledByNative
    public static String getCacheDirectory(Context appContext) {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(3);
    }

    @CalledByNative
    public static String getThumbnailCacheDirectory(Context appContext) {
        assert (sDirPathFetchTask != null) : "setDataDirectorySuffix must be called first.";
        return PathUtils.getDirectoryPath(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private static String getDownloadsDirectory(Context appContext) {
        String downloadsPath;
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        try {
            long time = SystemClock.elapsedRealtime();
            downloadsPath = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getPath();
            RecordHistogram.recordTimesHistogram("Android.StrictMode.DownloadsDir", SystemClock.elapsedRealtime() - time, TimeUnit.MILLISECONDS);
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        }
        return downloadsPath;
    }

    @CalledByNative
    private static String getNativeLibraryDirectory(Context appContext) {
        ApplicationInfo ai = appContext.getApplicationInfo();
        if ((ai.flags & 0x80) != 0 || (ai.flags & 1) == 0) {
            return ai.nativeLibraryDir;
        }
        return "/system/lib/";
    }

    @CalledByNative
    public static String getExternalStorageDirectory() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    static /* synthetic */ String[] access$000() {
        return PathUtils.getOrComputeDirectoryPaths();
    }

    private static class Holder {
        private static final String[] DIRECTORY_PATHS = PathUtils.access$000();

        private Holder() {
        }
    }
}

