/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import org.chromium.base.ApplicationStatus;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="base::android")
public class PowerMonitor
implements ApplicationStatus.ApplicationStateListener {
    private static final long SUSPEND_DELAY_MS = 60000L;
    private static PowerMonitor sInstance;
    private boolean mIsBatteryPower;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private static final Runnable sSuspendTask;

    public static void createForTests(Context context) {
        sInstance = LazyHolder.INSTANCE;
    }

    public static void create(Context context) {
        context = context.getApplicationContext();
        if (sInstance == null) {
            sInstance = LazyHolder.INSTANCE;
            ApplicationStatus.registerApplicationStateListener(sInstance);
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatusIntent = context.registerReceiver(null, ifilter);
            if (batteryStatusIntent != null) {
                PowerMonitor.onBatteryChargingChanged(batteryStatusIntent);
            }
        }
    }

    private PowerMonitor() {
    }

    public static void onBatteryChargingChanged(Intent intent) {
        if (sInstance == null) {
            return;
        }
        int chargePlug = intent.getIntExtra("plugged", -1);
        PowerMonitor.sInstance.mIsBatteryPower = chargePlug != 2 && chargePlug != 1;
        PowerMonitor.nativeOnBatteryChargingChanged();
    }

    @Override
    public void onApplicationStateChange(int newState) {
        if (newState == 1) {
            this.mHandler.removeCallbacks(sSuspendTask);
            PowerMonitor.nativeOnMainActivityResumed();
        } else if (newState == 2) {
            this.mHandler.postDelayed(sSuspendTask, 60000L);
        }
    }

    @CalledByNative
    private static boolean isBatteryPower() {
        return PowerMonitor.sInstance.mIsBatteryPower;
    }

    private static native void nativeOnBatteryChargingChanged();

    private static native void nativeOnMainActivitySuspended();

    private static native void nativeOnMainActivityResumed();

    static {
        sSuspendTask = new Runnable(){

            @Override
            public void run() {
                PowerMonitor.nativeOnMainActivitySuspended();
            }
        };
    }

    private static class LazyHolder {
        private static final PowerMonitor INSTANCE = new PowerMonitor();

        private LazyHolder() {
        }
    }
}

