/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.Looper;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Log;
import android.util.Printer;
import org.chromium.base.CommandLine;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="base::android")
public class TraceEvent {
    private static volatile boolean sEnabled = false;
    private static volatile boolean sATraceEnabled = false;

    public static void registerNativeEnabledObserver() {
        TraceEvent.nativeRegisterEnabledObserver();
    }

    @CalledByNative
    public static void setEnabled(boolean enabled) {
        sEnabled = enabled;
        if (sATraceEnabled) {
            return;
        }
        ThreadUtils.getUiThreadLooper().setMessageLogging((Printer)(enabled ? LooperMonitorHolder.sInstance : null));
    }

    public static void setATraceEnabled(boolean enabled) {
        if (sATraceEnabled == enabled) {
            return;
        }
        sATraceEnabled = enabled;
        if (enabled) {
            TraceEvent.nativeStartATrace();
        } else {
            TraceEvent.nativeStopATrace();
        }
    }

    public static boolean enabled() {
        return sEnabled;
    }

    public static void instant(String name) {
        if (sEnabled) {
            TraceEvent.nativeInstant(name, null);
        }
    }

    public static void instant(String name, String arg) {
        if (sEnabled) {
            TraceEvent.nativeInstant(name, arg);
        }
    }

    public static void startAsync(String name, long id2) {
        if (sEnabled) {
            TraceEvent.nativeStartAsync(name, id2);
        }
    }

    public static void finishAsync(String name, long id2) {
        if (sEnabled) {
            TraceEvent.nativeFinishAsync(name, id2);
        }
    }

    public static void begin(String name) {
        if (sEnabled) {
            TraceEvent.nativeBegin(name, null);
        }
    }

    public static void begin(String name, String arg) {
        if (sEnabled) {
            TraceEvent.nativeBegin(name, arg);
        }
    }

    public static void end(String name) {
        if (sEnabled) {
            TraceEvent.nativeEnd(name, null);
        }
    }

    public static void end(String name, String arg) {
        if (sEnabled) {
            TraceEvent.nativeEnd(name, arg);
        }
    }

    private static native void nativeRegisterEnabledObserver();

    private static native void nativeStartATrace();

    private static native void nativeStopATrace();

    private static native void nativeInstant(String var0, String var1);

    private static native void nativeBegin(String var0, String var1);

    private static native void nativeEnd(String var0, String var1);

    private static native void nativeBeginToplevel();

    private static native void nativeEndToplevel();

    private static native void nativeStartAsync(String var0, long var1);

    private static native void nativeFinishAsync(String var0, long var1);

    private static final class LooperMonitorHolder {
        private static final BasicLooperMonitor sInstance = CommandLine.getInstance().hasSwitch("enable-idle-tracing") ? new IdleTracingLooperMonitor() : new BasicLooperMonitor();

        private LooperMonitorHolder() {
        }
    }

    private static final class IdleTracingLooperMonitor
    extends BasicLooperMonitor
    implements MessageQueue.IdleHandler {
        private static final String TAG = "TraceEvent.LooperMonitor";
        private static final String IDLE_EVENT_NAME = "Looper.queueIdle";
        private static final long FRAME_DURATION_MILLIS = 16L;
        private static final long MIN_INTERESTING_DURATION_MILLIS = 16L;
        private static final long MIN_INTERESTING_BURST_DURATION_MILLIS = 48L;
        private long mLastIdleStartedAt = 0L;
        private long mLastWorkStartedAt = 0L;
        private int mNumTasksSeen = 0;
        private int mNumIdlesSeen = 0;
        private int mNumTasksSinceLastIdle = 0;
        private boolean mIdleMonitorAttached = false;

        private IdleTracingLooperMonitor() {
        }

        private final void syncIdleMonitoring() {
            if (sEnabled && !this.mIdleMonitorAttached) {
                this.mLastIdleStartedAt = SystemClock.elapsedRealtime();
                Looper.myQueue().addIdleHandler((MessageQueue.IdleHandler)this);
                this.mIdleMonitorAttached = true;
                Log.v((String)TAG, (String)"attached idle handler");
            } else if (this.mIdleMonitorAttached && !sEnabled) {
                Looper.myQueue().removeIdleHandler((MessageQueue.IdleHandler)this);
                this.mIdleMonitorAttached = false;
                Log.v((String)TAG, (String)"detached idle handler");
            }
        }

        @Override
        final void beginHandling(String line) {
            if (this.mNumTasksSinceLastIdle == 0) {
                TraceEvent.end(IDLE_EVENT_NAME);
            }
            this.mLastWorkStartedAt = SystemClock.elapsedRealtime();
            this.syncIdleMonitoring();
            super.beginHandling(line);
        }

        @Override
        final void endHandling(String line) {
            long elapsed = SystemClock.elapsedRealtime() - this.mLastWorkStartedAt;
            if (elapsed > 16L) {
                IdleTracingLooperMonitor.traceAndLog(5, "observed a task that took " + elapsed + "ms: " + line);
            }
            super.endHandling(line);
            this.syncIdleMonitoring();
            ++this.mNumTasksSeen;
            ++this.mNumTasksSinceLastIdle;
        }

        private static void traceAndLog(int level, String message) {
            TraceEvent.instant("TraceEvent.LooperMonitor:IdleStats", message);
            Log.println((int)level, (String)TAG, (String)message);
        }

        public final boolean queueIdle() {
            long now = SystemClock.elapsedRealtime();
            if (this.mLastIdleStartedAt == 0L) {
                this.mLastIdleStartedAt = now;
            }
            long elapsed = now - this.mLastIdleStartedAt;
            ++this.mNumIdlesSeen;
            TraceEvent.begin(IDLE_EVENT_NAME, this.mNumTasksSinceLastIdle + " tasks since last idle.");
            if (elapsed > 48L) {
                String statsString = this.mNumTasksSeen + " tasks and " + this.mNumIdlesSeen + " idles processed so far, " + this.mNumTasksSinceLastIdle + " tasks bursted and " + elapsed + "ms elapsed since last idle";
                IdleTracingLooperMonitor.traceAndLog(3, statsString);
            }
            this.mLastIdleStartedAt = now;
            this.mNumTasksSinceLastIdle = 0;
            return true;
        }
    }

    private static class BasicLooperMonitor
    implements Printer {
        private BasicLooperMonitor() {
        }

        public void println(String line) {
            if (line.startsWith(">")) {
                this.beginHandling(line);
            } else {
                assert (line.startsWith("<"));
                this.endHandling(line);
            }
        }

        void beginHandling(String line) {
            if (sEnabled) {
                TraceEvent.nativeBeginToplevel();
            }
        }

        void endHandling(String line) {
            if (sEnabled) {
                TraceEvent.nativeEndToplevel();
            }
        }
    }
}

