/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.library_loader;

import android.os.Bundle;
import android.os.Parcel;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.chromium.base.Log;
import org.chromium.base.SysUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.MainDex;
import org.chromium.base.library_loader.Linker;
import org.chromium.base.library_loader.NativeLibraries;

@MainDex
class LegacyLinker
extends Linker {
    private static final String TAG = "LibraryLoader";
    private boolean mInitialized = false;
    private boolean mInBrowserProcess = true;
    private boolean mWaitForSharedRelros = false;
    private boolean mBrowserUsesSharedRelro = false;
    private Bundle mSharedRelros = null;
    private long mBaseLoadAddress = -1L;
    private long mCurrentLoadAddress = -1L;
    private boolean mPrepareLibraryLoadCalled = false;
    private HashMap<String, Linker.LibInfo> mLoadedLibraries = null;

    private LegacyLinker() {
    }

    static Linker create() {
        return new LegacyLinker();
    }

    private void ensureInitializedLocked() {
        assert (Thread.holdsLock(this.mLock));
        if (this.mInitialized || !NativeLibraries.sUseLinker) {
            return;
        }
        LegacyLinker.loadLinkerJniLibrary();
        if (this.mMemoryDeviceConfig == 0) {
            this.mMemoryDeviceConfig = SysUtils.isLowEndDevice() ? 1 : 2;
        }
        switch (1) {
            case 0: {
                this.mBrowserUsesSharedRelro = false;
                break;
            }
            case 1: {
                if (this.mMemoryDeviceConfig == 1) {
                    this.mBrowserUsesSharedRelro = true;
                    Log.w(TAG, "Low-memory device: shared RELROs used in all processes", new Object[0]);
                    break;
                }
                this.mBrowserUsesSharedRelro = false;
                break;
            }
            case 2: {
                Log.w(TAG, "Beware: shared RELROs used in all processes!", new Object[0]);
                this.mBrowserUsesSharedRelro = true;
                break;
            }
            default: {
                Log.wtf(TAG, "FATAL: illegal shared RELRO config", new Object[0]);
                throw new AssertionError();
            }
        }
        this.mInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUsingBrowserSharedRelros() {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureInitializedLocked();
            return this.mInBrowserProcess && this.mBrowserUsesSharedRelro;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareLibraryLoad() {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureInitializedLocked();
            this.mPrepareLibraryLoadCalled = true;
            if (this.mInBrowserProcess) {
                this.setupBaseLoadAddressLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishLibraryLoad() {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureInitializedLocked();
            if (this.mLoadedLibraries != null) {
                if (this.mInBrowserProcess) {
                    this.mSharedRelros = this.createBundleFromLibInfoMap(this.mLoadedLibraries);
                    if (this.mBrowserUsesSharedRelro) {
                        this.useSharedRelrosLocked(this.mSharedRelros);
                    }
                }
                if (this.mWaitForSharedRelros) {
                    assert (!this.mInBrowserProcess);
                    while (this.mSharedRelros == null) {
                        try {
                            this.mLock.wait();
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    this.useSharedRelrosLocked(this.mSharedRelros);
                    this.mSharedRelros.clear();
                    this.mSharedRelros = null;
                }
            }
            if (NativeLibraries.sEnableLinkerTests) {
                this.runTestRunnerClassForTesting(this.mMemoryDeviceConfig, this.mInBrowserProcess);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void useSharedRelros(Bundle bundle) {
        Bundle clonedBundle = null;
        if (bundle != null) {
            bundle.setClassLoader(Linker.LibInfo.class.getClassLoader());
            clonedBundle = new Bundle(Linker.LibInfo.class.getClassLoader());
            Parcel parcel = Parcel.obtain();
            bundle.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            clonedBundle.readFromParcel(parcel);
            parcel.recycle();
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mSharedRelros = clonedBundle;
            this.mLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getSharedRelros() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mInBrowserProcess) {
                return null;
            }
            return this.mSharedRelros;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableSharedRelros() {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureInitializedLocked();
            this.mInBrowserProcess = false;
            this.mWaitForSharedRelros = false;
            this.mBrowserUsesSharedRelro = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initServiceProcess(long baseLoadAddress) {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureInitializedLocked();
            this.mInBrowserProcess = false;
            this.mBrowserUsesSharedRelro = false;
            this.mWaitForSharedRelros = true;
            this.mBaseLoadAddress = baseLoadAddress;
            this.mCurrentLoadAddress = baseLoadAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBaseLoadAddress() {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureInitializedLocked();
            if (!this.mInBrowserProcess) {
                Log.w(TAG, "Shared RELRO sections are disabled in this process!", new Object[0]);
                return 0L;
            }
            this.setupBaseLoadAddressLocked();
            return this.mBaseLoadAddress;
        }
    }

    private void setupBaseLoadAddressLocked() {
        assert (Thread.holdsLock(this.mLock));
        if (this.mBaseLoadAddress == -1L) {
            this.mCurrentLoadAddress = this.mBaseLoadAddress = this.getRandomBaseLoadAddress();
            if (this.mBaseLoadAddress == 0L) {
                Log.w(TAG, "Disabling shared RELROs due address space pressure", new Object[0]);
                this.mBrowserUsesSharedRelro = false;
                this.mWaitForSharedRelros = false;
            }
        }
    }

    private void dumpBundle(Bundle bundle) {
    }

    private void useSharedRelrosLocked(Bundle bundle) {
        assert (Thread.holdsLock(this.mLock));
        if (bundle == null) {
            return;
        }
        if (this.mLoadedLibraries == null) {
            return;
        }
        HashMap<String, Linker.LibInfo> relroMap = this.createLibInfoMapFromBundle(bundle);
        for (Map.Entry<String, Linker.LibInfo> entry : relroMap.entrySet()) {
            Linker.LibInfo libInfo;
            String libName = entry.getKey();
            if (LegacyLinker.nativeUseSharedRelro(libName, libInfo = entry.getValue())) continue;
            Log.w(TAG, "Could not use shared RELRO section for " + libName, new Object[0]);
        }
        if (!this.mInBrowserProcess) {
            this.closeLibInfoMap(relroMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void loadLibraryImpl(@Nullable String zipFilePath, String libFilePath, boolean isFixedAddressPermitted) {
        Object object = this.mLock;
        synchronized (object) {
            this.ensureInitializedLocked();
            assert (this.mPrepareLibraryLoadCalled);
            if (this.mLoadedLibraries == null) {
                this.mLoadedLibraries = new HashMap();
            }
            if (this.mLoadedLibraries.containsKey(libFilePath)) {
                return;
            }
            Linker.LibInfo libInfo = new Linker.LibInfo();
            long loadAddress = 0L;
            if (isFixedAddressPermitted && (this.mInBrowserProcess && this.mBrowserUsesSharedRelro || this.mWaitForSharedRelros) && (loadAddress = this.mCurrentLoadAddress) > this.mBaseLoadAddress + 0xC000000L) {
                String errorMessage = "Load address outside reservation, for: " + libFilePath;
                Log.e(TAG, errorMessage, new Object[0]);
                throw new UnsatisfiedLinkError(errorMessage);
            }
            String sharedRelRoName = libFilePath;
            if (zipFilePath != null) {
                if (!LegacyLinker.nativeLoadLibraryInZipFile(zipFilePath, libFilePath, loadAddress, libInfo)) {
                    String errorMessage = "Unable to load library: " + libFilePath + ", in: " + zipFilePath;
                    Log.e(TAG, errorMessage, new Object[0]);
                    throw new UnsatisfiedLinkError(errorMessage);
                }
                sharedRelRoName = zipFilePath;
            } else if (!LegacyLinker.nativeLoadLibrary(libFilePath, loadAddress, libInfo)) {
                String errorMessage = "Unable to load library: " + libFilePath;
                Log.e(TAG, errorMessage, new Object[0]);
                throw new UnsatisfiedLinkError(errorMessage);
            }
            if (NativeLibraries.sEnableLinkerTests) {
                String tag = this.mInBrowserProcess ? "BROWSER_LIBRARY_ADDRESS" : "RENDERER_LIBRARY_ADDRESS";
                Log.i(TAG, String.format(Locale.US, "%s: %s %x", tag, libFilePath, libInfo.mLoadAddress), new Object[0]);
            }
            if (this.mInBrowserProcess && !LegacyLinker.nativeCreateSharedRelro(sharedRelRoName, this.mCurrentLoadAddress, libInfo)) {
                Log.w(TAG, String.format(Locale.US, "Could not create shared RELRO for %s at %x", libFilePath, this.mCurrentLoadAddress), new Object[0]);
            }
            if (loadAddress != 0L && this.mCurrentLoadAddress != 0L) {
                this.mCurrentLoadAddress = libInfo.mLoadAddress + libInfo.mLoadSize + 0x1000000L;
            }
            this.mLoadedLibraries.put(sharedRelRoName, libInfo);
        }
    }

    @CalledByNative
    public static void postCallbackOnMainThread(final long opaque) {
        ThreadUtils.postOnUiThread(new Runnable(){

            @Override
            public void run() {
                LegacyLinker.nativeRunCallbackOnUiThread(opaque);
            }
        });
    }

    private static native void nativeRunCallbackOnUiThread(long var0);

    private static native boolean nativeLoadLibrary(String var0, long var1, Linker.LibInfo var3);

    private static native boolean nativeLoadLibraryInZipFile(@Nullable String var0, String var1, long var2, Linker.LibInfo var4);

    private static native boolean nativeCreateSharedRelro(String var0, long var1, Linker.LibInfo var3);

    private static native boolean nativeUseSharedRelro(String var0, Linker.LibInfo var1);
}

