/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.library_loader;

import android.content.Context;
import android.os.AsyncTask;
import android.os.SystemClock;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.chromium.base.CommandLine;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.TraceEvent;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.library_loader.Linker;
import org.chromium.base.library_loader.NativeLibraries;
import org.chromium.base.library_loader.NativeLibraryPreloader;
import org.chromium.base.library_loader.ProcessInitException;
import org.chromium.base.metrics.RecordHistogram;

@JNINamespace(value="base::android")
public class LibraryLoader {
    private static final String TAG = "LibraryLoader";
    private static final boolean DEBUG = false;
    private static final Object sLock = new Object();
    private static NativeLibraryPreloader sLibraryPreloader;
    private static volatile LibraryLoader sInstance;
    private boolean mLoaded;
    private boolean mCommandLineSwitched;
    private volatile boolean mInitialized;
    private boolean mIsUsingBrowserSharedRelros;
    private boolean mLoadAtFixedAddressFailed;
    private boolean mLibraryWasLoadedFromApk;
    private final int mLibraryProcessType;
    private final AtomicBoolean mPrefetchLibraryHasBeenCalled;
    private long mLibraryLoadTimeMs;
    private int mLibraryPreloaderStatus = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNativeLibraryPreloader(NativeLibraryPreloader loader) {
        Object object = sLock;
        synchronized (object) {
            assert (!(sLibraryPreloader != null || sInstance != null && LibraryLoader.sInstance.mLoaded));
            sLibraryPreloader = loader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LibraryLoader get(int libraryProcessType) throws ProcessInitException {
        Object object = sLock;
        synchronized (object) {
            if (sInstance != null) {
                if (LibraryLoader.sInstance.mLibraryProcessType == libraryProcessType) {
                    return sInstance;
                }
                throw new ProcessInitException(2);
            }
            sInstance = new LibraryLoader(libraryProcessType);
            return sInstance;
        }
    }

    private LibraryLoader(int libraryProcessType) {
        this.mLibraryProcessType = libraryProcessType;
        this.mPrefetchLibraryHasBeenCalled = new AtomicBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureInitialized(Context context) throws ProcessInitException {
        ContextUtils.initApplicationContext(context.getApplicationContext());
        Object object = sLock;
        synchronized (object) {
            if (this.mInitialized) {
                return;
            }
            this.loadAlreadyLocked(context);
            this.initializeAlreadyLocked();
        }
    }

    public static boolean isInitialized() {
        return sInstance != null && LibraryLoader.sInstance.mInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNow(Context context) throws ProcessInitException {
        Object object = sLock;
        synchronized (object) {
            this.loadAlreadyLocked(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws ProcessInitException {
        Object object = sLock;
        synchronized (object) {
            this.initializeAlreadyLocked();
        }
    }

    public void asyncPrefetchLibrariesToMemory() {
        final boolean coldStart = this.mPrefetchLibraryHasBeenCalled.compareAndSet(false, true);
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                TraceEvent.begin("LibraryLoader.asyncPrefetchLibrariesToMemory");
                int percentage = LibraryLoader.nativePercentageOfResidentNativeLibraryCode();
                boolean success = false;
                if (coldStart && !(success = LibraryLoader.nativeForkAndPrefetchNativeLibrary())) {
                    Log.w(LibraryLoader.TAG, "Forking a process to prefetch the native library failed.", new Object[0]);
                }
                RecordHistogram.initialize();
                if (coldStart) {
                    RecordHistogram.recordBooleanHistogram("LibraryLoader.PrefetchStatus", success);
                }
                if (percentage != -1) {
                    String histogram = "LibraryLoader.PercentageOfResidentCodeBeforePrefetch" + (coldStart ? ".ColdStartup" : ".WarmStartup");
                    RecordHistogram.recordPercentageHistogram(histogram, percentage);
                }
                TraceEvent.end("LibraryLoader.asyncPrefetchLibrariesToMemory");
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    private void loadLibrary(Linker linker, @Nullable String zipFilePath, String libFilePath) {
        if (linker.isUsingBrowserSharedRelros()) {
            this.mIsUsingBrowserSharedRelros = true;
            try {
                linker.loadLibrary(zipFilePath, libFilePath);
            }
            catch (UnsatisfiedLinkError e) {
                Log.w(TAG, "Failed to load native library with shared RELRO, retrying without", new Object[0]);
                this.mLoadAtFixedAddressFailed = true;
                linker.loadLibraryNoFixedAddress(zipFilePath, libFilePath);
            }
        } else {
            linker.loadLibrary(zipFilePath, libFilePath);
        }
        if (zipFilePath != null) {
            this.mLibraryWasLoadedFromApk = true;
        }
    }

    private void loadAlreadyLocked(Context context) throws ProcessInitException {
        try {
            if (!this.mLoaded) {
                assert (!this.mInitialized);
                long startTime = SystemClock.uptimeMillis();
                if (Linker.isUsed()) {
                    Linker linker = Linker.getInstance();
                    linker.prepareLibraryLoad();
                    for (String library : NativeLibraries.LIBRARIES) {
                        if (linker.isChromiumLinkerLibrary(library)) continue;
                        String zipFilePath = null;
                        String libFilePath = System.mapLibraryName(library);
                        if (Linker.isInZipFile()) {
                            zipFilePath = context.getApplicationInfo().sourceDir;
                            Log.i(TAG, "Loading " + library + " from within " + zipFilePath, new Object[0]);
                        } else {
                            Log.i(TAG, "Loading " + library, new Object[0]);
                        }
                        this.loadLibrary(linker, zipFilePath, libFilePath);
                    }
                    linker.finishLibraryLoad();
                } else {
                    if (sLibraryPreloader != null) {
                        this.mLibraryPreloaderStatus = sLibraryPreloader.loadLibrary(context);
                    }
                    for (String library : NativeLibraries.LIBRARIES) {
                        System.loadLibrary(library);
                    }
                }
                long stopTime = SystemClock.uptimeMillis();
                this.mLibraryLoadTimeMs = stopTime - startTime;
                Log.i(TAG, String.format("Time to load native libraries: %d ms (timestamps %d-%d)", this.mLibraryLoadTimeMs, startTime % 10000L, stopTime % 10000L), new Object[0]);
                this.mLoaded = true;
            }
        }
        catch (UnsatisfiedLinkError e) {
            throw new ProcessInitException(2, (Throwable)e);
        }
        Log.i(TAG, String.format("Expected native library version number \"%s\", actual native library version number \"%s\"", NativeLibraries.sVersionNumber, this.nativeGetVersionNumber()), new Object[0]);
        if (!NativeLibraries.sVersionNumber.equals(this.nativeGetVersionNumber())) {
            throw new ProcessInitException(3);
        }
    }

    private static boolean isAbiSplit(String splitName) {
        return splitName.startsWith("abi_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchCommandLineForWebView() {
        Object object = sLock;
        synchronized (object) {
            this.ensureCommandLineSwitchedAlreadyLocked();
        }
    }

    private void ensureCommandLineSwitchedAlreadyLocked() {
        assert (this.mLoaded);
        if (this.mCommandLineSwitched) {
            return;
        }
        this.nativeInitCommandLine(CommandLine.getJavaSwitchesOrNull());
        CommandLine.enableNativeProxy();
        this.mCommandLineSwitched = true;
        ContextUtils.initApplicationContextForNative();
    }

    private void initializeAlreadyLocked() throws ProcessInitException {
        if (this.mInitialized) {
            return;
        }
        this.ensureCommandLineSwitchedAlreadyLocked();
        if (!this.nativeLibraryLoaded()) {
            Log.e(TAG, "error calling nativeLibraryLoaded", new Object[0]);
            throw new ProcessInitException(1);
        }
        TraceEvent.registerNativeEnabledObserver();
        this.mInitialized = true;
    }

    public void onNativeInitializationComplete(Context context) {
        this.recordBrowserProcessHistogram(context);
    }

    private void recordBrowserProcessHistogram(Context context) {
        Linker.getInstance();
        if (Linker.isUsed()) {
            this.nativeRecordChromiumAndroidLinkerBrowserHistogram(this.mIsUsingBrowserSharedRelros, this.mLoadAtFixedAddressFailed, this.getLibraryLoadFromApkStatus(context), this.mLibraryLoadTimeMs);
        }
        if (sLibraryPreloader != null) {
            this.nativeRecordLibraryPreloaderBrowserHistogram(this.mLibraryPreloaderStatus);
        }
    }

    private int getLibraryLoadFromApkStatus(Context context) {
        if (!$assertionsDisabled) {
            Linker.getInstance();
            if (!Linker.isUsed()) {
                throw new AssertionError();
            }
        }
        if (this.mLibraryWasLoadedFromApk) {
            return 3;
        }
        return 0;
    }

    public void registerRendererProcessHistogram(boolean requestedSharedRelro, boolean loadAtFixedAddressFailed) {
        Linker.getInstance();
        if (Linker.isUsed()) {
            this.nativeRegisterChromiumAndroidLinkerRendererHistogram(requestedSharedRelro, loadAtFixedAddressFailed, this.mLibraryLoadTimeMs);
        }
        if (sLibraryPreloader != null) {
            this.nativeRegisterLibraryPreloaderRendererHistogram(this.mLibraryPreloaderStatus);
        }
    }

    @CalledByNative
    public static int getLibraryProcessType() {
        if (sInstance == null) {
            return 0;
        }
        return LibraryLoader.sInstance.mLibraryProcessType;
    }

    private native void nativeInitCommandLine(String[] var1);

    private native boolean nativeLibraryLoaded();

    private native void nativeRecordChromiumAndroidLinkerBrowserHistogram(boolean var1, boolean var2, int var3, long var4);

    private native void nativeRecordLibraryPreloaderBrowserHistogram(int var1);

    private native void nativeRegisterChromiumAndroidLinkerRendererHistogram(boolean var1, boolean var2, long var3);

    private native void nativeRegisterLibraryPreloaderRendererHistogram(int var1);

    private native String nativeGetVersionNumber();

    private static native boolean nativeForkAndPrefetchNativeLibrary();

    private static native int nativePercentageOfResidentNativeLibraryCode();
}

