/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.library_loader;

import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.annotations.AccessedByNative;
import org.chromium.base.library_loader.LegacyLinker;
import org.chromium.base.library_loader.ModernLinker;
import org.chromium.base.library_loader.NativeLibraries;

public abstract class Linker {
    private static final String TAG = "LibraryLoader";
    private static final String LINKER_JNI_LIBRARY = "chromium_android_linker";
    public static final int BROWSER_SHARED_RELRO_CONFIG_NEVER = 0;
    public static final int BROWSER_SHARED_RELRO_CONFIG_LOW_RAM_ONLY = 1;
    public static final int BROWSER_SHARED_RELRO_CONFIG_ALWAYS = 2;
    public static final int BROWSER_SHARED_RELRO_CONFIG = 1;
    public static final int MEMORY_DEVICE_CONFIG_INIT = 0;
    public static final int MEMORY_DEVICE_CONFIG_LOW = 1;
    public static final int MEMORY_DEVICE_CONFIG_NORMAL = 2;
    protected int mMemoryDeviceConfig = 0;
    protected static final boolean DEBUG = false;
    public static final String EXTRA_LINKER_SHARED_RELROS = "org.chromium.base.android.linker.shared_relros";
    protected final Object mLock = new Object();
    private String mTestRunnerClassName = null;
    protected static final int BREAKPAD_GUARD_REGION_BYTES = 0x1000000;
    protected static final int ADDRESS_SPACE_RESERVATION = 0xC000000;
    public static final int LINKER_IMPLEMENTATION_LEGACY = 1;
    public static final int LINKER_IMPLEMENTATION_MODERN = 2;
    private static Linker sSingleton = null;
    private static Object sSingletonLock = new Object();

    protected Linker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Linker getInstance() {
        Object object = sSingletonLock;
        synchronized (object) {
            if (sSingleton == null) {
                String appClass = ContextUtils.getApplicationContext().getApplicationInfo().className;
                boolean isIncrementalInstall = appClass != null && appClass.contains("incrementalinstall");
                sSingleton = Build.VERSION.SDK_INT >= 23 && !isIncrementalInstall ? ModernLinker.create() : LegacyLinker.create();
                Log.i(TAG, "Using linker: " + sSingleton.getClass().getName(), new Object[0]);
            }
            return sSingleton;
        }
    }

    public static boolean areTestsEnabled() {
        return NativeLibraries.sEnableLinkerTests;
    }

    private static void assertForTesting(boolean flag) {
        if (!flag) {
            throw new AssertionError();
        }
    }

    private static void assertLinkerTestsAreEnabled() {
        if (!NativeLibraries.sEnableLinkerTests) {
            throw new AssertionError((Object)"Testing method called in non-testing context");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setImplementationForTesting(int type2) {
        Linker.assertLinkerTestsAreEnabled();
        Linker.assertForTesting(type2 == 1 || type2 == 2);
        Object object = sSingletonLock;
        synchronized (object) {
            Linker.assertForTesting(sSingleton == null);
            if (type2 == 2) {
                sSingleton = ModernLinker.create();
            } else if (type2 == 1) {
                sSingleton = LegacyLinker.create();
            }
            Log.i(TAG, "Forced linker: " + sSingleton.getClass().getName(), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getImplementationForTesting() {
        Linker.assertLinkerTestsAreEnabled();
        Object object = sSingletonLock;
        synchronized (object) {
            Linker.assertForTesting(sSingleton == this);
            if (sSingleton instanceof ModernLinker) {
                return 2;
            }
            if (sSingleton instanceof LegacyLinker) {
                return 1;
            }
            Log.wtf(TAG, "Invalid linker: " + sSingleton.getClass().getName(), new Object[0]);
            Linker.assertForTesting(false);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTestRunnerClassNameForTesting(String testRunnerClassName) {
        Linker.assertLinkerTestsAreEnabled();
        Object object = this.mLock;
        synchronized (object) {
            Linker.assertForTesting(this.mTestRunnerClassName == null);
            this.mTestRunnerClassName = testRunnerClassName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getTestRunnerClassNameForTesting() {
        Linker.assertLinkerTestsAreEnabled();
        Object object = this.mLock;
        synchronized (object) {
            return this.mTestRunnerClassName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setupForTesting(int type2, String testRunnerClassName) {
        Linker.assertLinkerTestsAreEnabled();
        Object object = sSingletonLock;
        synchronized (object) {
            if (sSingleton == null) {
                Linker.setImplementationForTesting(type2);
                sSingleton.setTestRunnerClassNameForTesting(testRunnerClassName);
                return;
            }
            Linker.assertForTesting(sSingleton.getImplementationForTesting() == type2);
            String ourTestRunnerClassName = sSingleton.getTestRunnerClassNameForTesting();
            if (testRunnerClassName == null) {
                Linker.assertForTesting(ourTestRunnerClassName == null);
            } else {
                Linker.assertForTesting(ourTestRunnerClassName.equals(testRunnerClassName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void runTestRunnerClassForTesting(int memoryDeviceConfig, boolean inBrowserProcess) {
        Linker.assertLinkerTestsAreEnabled();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTestRunnerClassName == null) {
                Log.wtf(TAG, "Linker runtime tests not set up for this process", new Object[0]);
                Linker.assertForTesting(false);
            }
            TestRunner testRunner = null;
            try {
                testRunner = (TestRunner)Class.forName(this.mTestRunnerClassName).newInstance();
            }
            catch (Exception e) {
                Log.wtf(TAG, "Could not instantiate test runner class by name", e);
                Linker.assertForTesting(false);
            }
            if (!testRunner.runChecks(memoryDeviceConfig, inBrowserProcess)) {
                Log.wtf(TAG, "Linker runtime tests failed in this process", new Object[0]);
                Linker.assertForTesting(false);
            }
            Log.i(TAG, "All linker tests passed", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMemoryDeviceConfigForTesting(int memoryDeviceConfig) {
        Linker.assertLinkerTestsAreEnabled();
        Linker.assertForTesting(memoryDeviceConfig == 1 || memoryDeviceConfig == 2);
        Object object = this.mLock;
        synchronized (object) {
            Linker.assertForTesting(this.mMemoryDeviceConfig == 0);
            this.mMemoryDeviceConfig = memoryDeviceConfig;
        }
    }

    public boolean isChromiumLinkerLibrary(String library) {
        return library.equals(LINKER_JNI_LIBRARY) || library.equals("chromium_android_linker.cr");
    }

    protected static void loadLinkerJniLibrary() {
        String libName = "libchromium_android_linker.so";
        try {
            System.loadLibrary(LINKER_JNI_LIBRARY);
        }
        catch (UnsatisfiedLinkError e) {
            Log.w(TAG, "Couldn't load " + libName + ", trying " + libName + ".cr", new Object[0]);
            System.loadLibrary("chromium_android_linker.cr");
        }
    }

    protected long getRandomBaseLoadAddress() {
        long address = Linker.nativeGetRandomBaseLoadAddress();
        return address;
    }

    public void loadLibrary(@Nullable String zipFilePath, String libFilePath) {
        boolean isFixedAddressPermitted = true;
        this.loadLibraryImpl(zipFilePath, libFilePath, true);
    }

    public void loadLibraryNoFixedAddress(@Nullable String zipFilePath, String libFilePath) {
        boolean isFixedAddressPermitted = false;
        this.loadLibraryImpl(zipFilePath, libFilePath, false);
    }

    public static boolean isInZipFile() {
        return NativeLibraries.sUseLibraryInZipFile;
    }

    public static boolean isUsed() {
        return NativeLibraries.sUseLinker;
    }

    public abstract boolean isUsingBrowserSharedRelros();

    public abstract void prepareLibraryLoad();

    public abstract void finishLibraryLoad();

    public abstract void useSharedRelros(Bundle var1);

    public abstract Bundle getSharedRelros();

    public abstract void disableSharedRelros();

    public abstract void initServiceProcess(long var1);

    public abstract long getBaseLoadAddress();

    abstract void loadLibraryImpl(@Nullable String var1, String var2, boolean var3);

    protected Bundle createBundleFromLibInfoMap(HashMap<String, LibInfo> map) {
        Bundle bundle = new Bundle(map.size());
        for (Map.Entry<String, LibInfo> entry : map.entrySet()) {
            bundle.putParcelable(entry.getKey(), (Parcelable)entry.getValue());
        }
        return bundle;
    }

    protected HashMap<String, LibInfo> createLibInfoMapFromBundle(Bundle bundle) {
        HashMap<String, LibInfo> map = new HashMap<String, LibInfo>();
        for (String library : bundle.keySet()) {
            LibInfo libInfo = (LibInfo)bundle.getParcelable(library);
            map.put(library, libInfo);
        }
        return map;
    }

    protected void closeLibInfoMap(HashMap<String, LibInfo> map) {
        for (Map.Entry<String, LibInfo> entry : map.entrySet()) {
            entry.getValue().close();
        }
    }

    private static native long nativeGetRandomBaseLoadAddress();

    public static class LibInfo
    implements Parcelable {
        public static final Parcelable.Creator<LibInfo> CREATOR = new Parcelable.Creator<LibInfo>(){

            public LibInfo createFromParcel(Parcel in) {
                return new LibInfo(in);
            }

            public LibInfo[] newArray(int size) {
                return new LibInfo[size];
            }
        };
        @AccessedByNative
        public long mLoadAddress;
        @AccessedByNative
        public long mLoadSize;
        @AccessedByNative
        public long mRelroStart;
        @AccessedByNative
        public long mRelroSize;
        @AccessedByNative
        public int mRelroFd;

        public LibInfo() {
            this.mLoadAddress = 0L;
            this.mLoadSize = 0L;
            this.mRelroStart = 0L;
            this.mRelroSize = 0L;
            this.mRelroFd = -1;
        }

        public void close() {
            if (this.mRelroFd >= 0) {
                try {
                    ParcelFileDescriptor.adoptFd((int)this.mRelroFd).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mRelroFd = -1;
            }
        }

        public LibInfo(Parcel in) {
            this.mLoadAddress = in.readLong();
            this.mLoadSize = in.readLong();
            this.mRelroStart = in.readLong();
            this.mRelroSize = in.readLong();
            ParcelFileDescriptor fd = (ParcelFileDescriptor)ParcelFileDescriptor.CREATOR.createFromParcel(in);
            this.mRelroFd = fd == null ? -1 : fd.detachFd();
        }

        public void writeToParcel(Parcel out, int flags) {
            if (this.mRelroFd >= 0) {
                out.writeLong(this.mLoadAddress);
                out.writeLong(this.mLoadSize);
                out.writeLong(this.mRelroStart);
                out.writeLong(this.mRelroSize);
                try {
                    ParcelFileDescriptor fd = ParcelFileDescriptor.fromFd((int)this.mRelroFd);
                    fd.writeToParcel(out, 0);
                    fd.close();
                }
                catch (IOException e) {
                    Log.e(Linker.TAG, "Can't write LibInfo file descriptor to parcel", e);
                }
            }
        }

        public int describeContents() {
            return 1;
        }

        public String toString() {
            return String.format(Locale.US, "[load=0x%x-0x%x relro=0x%x-0x%x fd=%d]", this.mLoadAddress, this.mLoadAddress + this.mLoadSize, this.mRelroStart, this.mRelroStart + this.mRelroSize, this.mRelroFd);
        }
    }

    public static interface TestRunner {
        public boolean runChecks(int var1, boolean var2);
    }
}

