/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base.multidex;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.support.multidex.MultiDex;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.chromium.base.BuildConfig;
import org.chromium.base.Log;
import org.chromium.base.VisibleForTesting;

public class ChromiumMultiDexInstaller {
    private static final String TAG = "base_multidex";
    private static final String IGNORE_MULTIDEX_KEY = ".ignore_multidex";

    @VisibleForTesting
    public static void install(Context context) {
        if (!BuildConfig.isMultidexEnabled()) {
            return;
        }
        if (Build.VERSION.SDK_INT < 21 && !ChromiumMultiDexInstaller.shouldInstallMultiDex(context)) {
            Log.i(TAG, "Skipping multidex installation: not needed for process.", new Object[0]);
        } else {
            MultiDex.install((Context)context);
            Log.i(TAG, "Completed multidex installation.", new Object[0]);
        }
    }

    private static String getProcessName(Context context) {
        try {
            String currentProcessName = null;
            int pid = Process.myPid();
            ActivityManager manager = (ActivityManager)context.getSystemService("activity");
            for (ActivityManager.RunningAppProcessInfo processInfo : manager.getRunningAppProcesses()) {
                if (processInfo.pid != pid) continue;
                currentProcessName = processInfo.processName;
                break;
            }
            return currentProcessName;
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    private static boolean shouldInstallMultiDex(Context context) {
        try {
            Method isIsolatedMethod = Process.class.getMethod("isIsolated", new Class[0]);
            Object retVal = isIsolatedMethod.invoke(null, new Object[0]);
            if (retVal != null && retVal instanceof Boolean && ((Boolean)retVal).booleanValue()) {
                return false;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException isIsolatedMethod) {
            // empty catch block
        }
        String currentProcessName = ChromiumMultiDexInstaller.getProcessName(context);
        if (currentProcessName == null) {
            return true;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            ApplicationInfo appInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (appInfo == null || appInfo.metaData == null) {
                return true;
            }
            return !appInfo.metaData.getBoolean(currentProcessName + IGNORE_MULTIDEX_KEY, false);
        }
        catch (PackageManager.NameNotFoundException e) {
            return true;
        }
    }
}

