/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.components.location;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Process;
import android.provider.Settings;
import android.text.TextUtils;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.SuppressFBWarnings;

public class LocationUtils {
    private static Factory sFactory;
    private static LocationUtils sInstance;

    protected LocationUtils() {
    }

    @SuppressFBWarnings(value={"LI_LAZY_INIT_STATIC"})
    public static LocationUtils getInstance() {
        ThreadUtils.assertOnUiThread();
        if (sInstance == null) {
            sInstance = sFactory == null ? new LocationUtils() : sFactory.create();
        }
        return sInstance;
    }

    private boolean hasPermission(Context context, String name) {
        return ApiCompatibilityUtils.checkPermission(context, name, Process.myPid(), Process.myUid()) == 0;
    }

    public boolean hasAndroidLocationPermission(Context context) {
        return this.hasPermission(context, "android.permission.ACCESS_COARSE_LOCATION") || this.hasPermission(context, "android.permission.ACCESS_FINE_LOCATION");
    }

    public boolean isSystemLocationSettingEnabled(Context context) {
        if (Build.VERSION.SDK_INT >= 19) {
            return Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"location_mode", (int)0) != 0;
        }
        return !TextUtils.isEmpty((CharSequence)Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"location_providers_allowed"));
    }

    public Intent getSystemLocationSettingsIntent() {
        Intent i = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
        i.setFlags(0x10000000);
        return i;
    }

    @VisibleForTesting
    public static void setFactory(Factory factory) {
        sFactory = factory;
        sInstance = null;
    }

    public static interface Factory {
        public LocationUtils create();
    }
}

