/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.app;

import android.content.Context;
import android.content.Intent;
import android.graphics.SurfaceTexture;
import android.os.Bundle;
import android.os.Debug;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.view.Surface;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.chromium.base.CommandLine;
import org.chromium.base.ContextUtils;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.SuppressFBWarnings;
import org.chromium.base.library_loader.LibraryLoader;
import org.chromium.base.library_loader.Linker;
import org.chromium.base.library_loader.ProcessInitException;
import org.chromium.content.app.ChromiumLinkerParams;
import org.chromium.content.app.ContentMain;
import org.chromium.content.browser.ChildProcessCreationParams;
import org.chromium.content.browser.FileDescriptorInfo;
import org.chromium.content.common.ContentSwitches;
import org.chromium.content.common.IChildProcessCallback;
import org.chromium.content.common.IChildProcessService;
import org.chromium.content.common.SurfaceWrapper;

@JNINamespace(value="content")
public class ChildProcessServiceImpl {
    private static final String MAIN_THREAD_NAME = "ChildProcessMain";
    private static final String TAG = "ChildProcessService";
    protected static final FileDescriptorInfo[] EMPTY_FILE_DESCRIPTOR_INFO = new FileDescriptorInfo[0];
    private IChildProcessCallback mCallback;
    private Thread mMainThread;
    private String[] mCommandLineParams;
    private int mCpuCount;
    private long mCpuFeatures;
    private FileDescriptorInfo[] mFdInfos;
    private ChromiumLinkerParams mLinkerParams;
    private int mLibraryProcessType;
    private static AtomicReference<Context> sContext = new AtomicReference<Object>(null);
    private boolean mLibraryInitialized = false;
    private boolean mIsBound = false;
    private final Semaphore mActivitySemaphore = new Semaphore(1);
    private final IChildProcessService.Stub mBinder = new IChildProcessService.Stub(){

        @Override
        public int setupConnection(Bundle args, IChildProcessCallback callback) {
            ChildProcessServiceImpl.this.mCallback = callback;
            ChildProcessServiceImpl.this.getServiceInfo(args);
            return Process.myPid();
        }

        @Override
        public void crashIntentionallyForTesting() {
            Process.killProcess((int)Process.myPid());
        }
    };
    private ClassLoader mHostClassLoader;

    private Linker getLinker() {
        if (Linker.areTestsEnabled()) {
            assert (this.mLinkerParams != null);
            Linker.setupForTesting(this.mLinkerParams.mLinkerImplementationForTesting, this.mLinkerParams.mTestRunnerClassNameForTesting);
        }
        return Linker.getInstance();
    }

    static Context getContext() {
        return sContext.get();
    }

    public void create(Context context, final Context hostBrowserContext) {
        this.mHostClassLoader = hostBrowserContext.getClassLoader();
        Log.i(TAG, "Creating new ChildProcessService pid=%d", Process.myPid());
        if (sContext.get() != null) {
            throw new RuntimeException("Illegal child process reuse.");
        }
        sContext.set(context);
        ContextUtils.initApplicationContext(context);
        this.mMainThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @SuppressFBWarnings(value={"DM_EXIT"})
            public void run() {
                try {
                    Thread thread = ChildProcessServiceImpl.this.mMainThread;
                    synchronized (thread) {
                        while (ChildProcessServiceImpl.this.mCommandLineParams == null) {
                            ChildProcessServiceImpl.this.mMainThread.wait();
                        }
                    }
                    CommandLine.init(ChildProcessServiceImpl.this.mCommandLineParams);
                    Linker linker = null;
                    boolean requestedSharedRelro = false;
                    if (Linker.isUsed()) {
                        Thread thread2 = ChildProcessServiceImpl.this.mMainThread;
                        synchronized (thread2) {
                            while (!ChildProcessServiceImpl.this.mIsBound) {
                                ChildProcessServiceImpl.this.mMainThread.wait();
                            }
                        }
                        linker = ChildProcessServiceImpl.this.getLinker();
                        if (((ChildProcessServiceImpl)ChildProcessServiceImpl.this).mLinkerParams.mWaitForSharedRelro) {
                            requestedSharedRelro = true;
                            linker.initServiceProcess(((ChildProcessServiceImpl)ChildProcessServiceImpl.this).mLinkerParams.mBaseLoadAddress);
                        } else {
                            linker.disableSharedRelros();
                        }
                    }
                    boolean isLoaded = false;
                    if (CommandLine.getInstance().hasSwitch("renderer-wait-for-java-debugger")) {
                        Debug.waitForDebugger();
                    }
                    boolean loadAtFixedAddressFailed = false;
                    try {
                        LibraryLoader.get(ChildProcessServiceImpl.this.mLibraryProcessType).loadNow(hostBrowserContext);
                        isLoaded = true;
                    }
                    catch (ProcessInitException e) {
                        if (requestedSharedRelro) {
                            Log.w(ChildProcessServiceImpl.TAG, "Failed to load native library with shared RELRO, retrying without", new Object[0]);
                            loadAtFixedAddressFailed = true;
                        }
                        Log.e(ChildProcessServiceImpl.TAG, "Failed to load native library", e);
                    }
                    if (!isLoaded && requestedSharedRelro) {
                        linker.disableSharedRelros();
                        try {
                            LibraryLoader.get(ChildProcessServiceImpl.this.mLibraryProcessType).loadNow(hostBrowserContext);
                            isLoaded = true;
                        }
                        catch (ProcessInitException e) {
                            Log.e(ChildProcessServiceImpl.TAG, "Failed to load native library on retry", e);
                        }
                    }
                    if (!isLoaded) {
                        System.exit(-1);
                    }
                    LibraryLoader.get(ChildProcessServiceImpl.this.mLibraryProcessType).registerRendererProcessHistogram(requestedSharedRelro, loadAtFixedAddressFailed);
                    LibraryLoader.get(ChildProcessServiceImpl.this.mLibraryProcessType).initialize();
                    Thread e = ChildProcessServiceImpl.this.mMainThread;
                    synchronized (e) {
                        ChildProcessServiceImpl.this.mLibraryInitialized = true;
                        ChildProcessServiceImpl.this.mMainThread.notifyAll();
                        while (ChildProcessServiceImpl.this.mFdInfos == null) {
                            ChildProcessServiceImpl.this.mMainThread.wait();
                        }
                    }
                    for (FileDescriptorInfo fdInfo : ChildProcessServiceImpl.this.mFdInfos) {
                        ChildProcessServiceImpl.nativeRegisterGlobalFileDescriptor(fdInfo.mId, fdInfo.mFd.detachFd(), fdInfo.mOffset, fdInfo.mSize);
                    }
                    ChildProcessServiceImpl.nativeInitChildProcessImpl(ChildProcessServiceImpl.this, ChildProcessServiceImpl.this.mCpuCount, ChildProcessServiceImpl.this.mCpuFeatures);
                    if (ChildProcessServiceImpl.this.mActivitySemaphore.tryAcquire()) {
                        ContentMain.start();
                        ChildProcessServiceImpl.nativeExitChildProcess();
                    }
                }
                catch (InterruptedException e) {
                    Log.w(ChildProcessServiceImpl.TAG, "%s startup failed: %s", ChildProcessServiceImpl.MAIN_THREAD_NAME, e);
                }
                catch (ProcessInitException e) {
                    Log.w(ChildProcessServiceImpl.TAG, "%s startup failed: %s", ChildProcessServiceImpl.MAIN_THREAD_NAME, e);
                }
            }
        }, MAIN_THREAD_NAME);
        this.mMainThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_EXIT"})
    public void destroy() {
        Log.i(TAG, "Destroying ChildProcessService pid=%d", Process.myPid());
        if (this.mActivitySemaphore.tryAcquire()) {
            System.exit(0);
            return;
        }
        Thread thread = this.mMainThread;
        synchronized (thread) {
            try {
                while (!this.mLibraryInitialized) {
                    this.mMainThread.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.nativeShutdownMainThread();
    }

    public IBinder bind(Intent intent) {
        this.initializeParams(intent);
        return this.mBinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeParams(Intent intent) {
        Thread thread = this.mMainThread;
        synchronized (thread) {
            this.mCommandLineParams = intent.getStringArrayExtra("com.google.android.apps.chrome.extra.command_line");
            this.mLinkerParams = new ChromiumLinkerParams(intent);
            this.mLibraryProcessType = ChildProcessCreationParams.getLibraryProcessType(intent);
            this.mIsBound = true;
            this.mMainThread.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getServiceInfo(Bundle bundle) {
        bundle.setClassLoader(this.mHostClassLoader);
        Thread thread = this.mMainThread;
        synchronized (thread) {
            if (this.mCommandLineParams == null) {
                this.mCommandLineParams = bundle.getStringArray("com.google.android.apps.chrome.extra.command_line");
            }
            assert (this.mCommandLineParams != null);
            this.mCpuCount = bundle.getInt("com.google.android.apps.chrome.extra.cpu_count");
            this.mCpuFeatures = bundle.getLong("com.google.android.apps.chrome.extra.cpu_features");
            assert (this.mCpuCount > 0);
            Parcelable[] fdInfosAsParcelable = bundle.getParcelableArray("com.google.android.apps.chrome.extra.extraFiles");
            if (fdInfosAsParcelable != null) {
                this.mFdInfos = new FileDescriptorInfo[fdInfosAsParcelable.length];
                System.arraycopy(fdInfosAsParcelable, 0, this.mFdInfos, 0, fdInfosAsParcelable.length);
            } else {
                String processType = ContentSwitches.getSwitchValue(this.mCommandLineParams, "type");
                assert ("download".equals(processType));
                this.mFdInfos = EMPTY_FILE_DESCRIPTOR_INFO;
            }
            Bundle sharedRelros = bundle.getBundle("org.chromium.base.android.linker.shared_relros");
            if (sharedRelros != null) {
                this.getLinker().useSharedRelros(sharedRelros);
                sharedRelros = null;
            }
            this.mMainThread.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void establishSurfaceTexturePeer(int pid, Object surfaceObject, int primaryID, int secondaryID) {
        if (this.mCallback == null) {
            Log.e(TAG, "No callback interface has been provided.", new Object[0]);
            return;
        }
        Surface surface = null;
        boolean needRelease = false;
        if (surfaceObject instanceof Surface) {
            surface = (Surface)surfaceObject;
        } else if (surfaceObject instanceof SurfaceTexture) {
            surface = new Surface((SurfaceTexture)surfaceObject);
            needRelease = true;
        } else {
            Log.e(TAG, "Not a valid surfaceObject: %s", surfaceObject);
            return;
        }
        try {
            this.mCallback.establishSurfacePeer(pid, surface, primaryID, secondaryID);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to call establishSurfaceTexturePeer: %s", new Object[]{e});
            return;
        }
        finally {
            if (needRelease) {
                surface.release();
            }
        }
    }

    @CalledByNative
    private Surface getViewSurface(int surfaceId) {
        if (this.mCallback == null) {
            Log.e(TAG, "No callback interface has been provided.", new Object[0]);
            return null;
        }
        try {
            SurfaceWrapper wrapper = this.mCallback.getViewSurface(surfaceId);
            return wrapper != null ? wrapper.getSurface() : null;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to call getViewSurface: %s", new Object[]{e});
            return null;
        }
    }

    @CalledByNative
    private void createSurfaceTextureSurface(int surfaceTextureId, int clientId, SurfaceTexture surfaceTexture) {
        if (this.mCallback == null) {
            Log.e(TAG, "No callback interface has been provided.", new Object[0]);
            return;
        }
        Surface surface = new Surface(surfaceTexture);
        try {
            this.mCallback.registerSurfaceTextureSurface(surfaceTextureId, clientId, surface);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to call registerSurfaceTextureSurface: %s", new Object[]{e});
        }
        surface.release();
    }

    @CalledByNative
    private void destroySurfaceTextureSurface(int surfaceTextureId, int clientId) {
        if (this.mCallback == null) {
            Log.e(TAG, "No callback interface has been provided.", new Object[0]);
            return;
        }
        try {
            this.mCallback.unregisterSurfaceTextureSurface(surfaceTextureId, clientId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to call unregisterSurfaceTextureSurface: %s", new Object[]{e});
        }
    }

    @CalledByNative
    private Surface getSurfaceTextureSurface(int surfaceTextureId) {
        if (this.mCallback == null) {
            Log.e(TAG, "No callback interface has been provided.", new Object[0]);
            return null;
        }
        try {
            return this.mCallback.getSurfaceTextureSurface(surfaceTextureId).getSurface();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to call getSurfaceTextureSurface: %s", new Object[]{e});
            return null;
        }
    }

    private static native void nativeRegisterGlobalFileDescriptor(int var0, int var1, long var2, long var4);

    private static native void nativeInitChildProcessImpl(ChildProcessServiceImpl var0, int var1, long var2);

    private static native void nativeExitChildProcess();

    private native void nativeShutdownMainThread();
}

