/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Pair;
import android.view.Surface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.chromium.base.CommandLine;
import org.chromium.base.CpuFeatures;
import org.chromium.base.Log;
import org.chromium.base.ThreadUtils;
import org.chromium.base.TraceEvent;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.library_loader.Linker;
import org.chromium.content.app.ChromiumLinkerParams;
import org.chromium.content.app.DownloadProcessService;
import org.chromium.content.app.PrivilegedProcessService;
import org.chromium.content.app.SandboxedProcessService;
import org.chromium.content.browser.BindingManager;
import org.chromium.content.browser.BindingManagerImpl;
import org.chromium.content.browser.ChildProcessConnection;
import org.chromium.content.browser.ChildProcessConnectionImpl;
import org.chromium.content.browser.ChildProcessCreationParams;
import org.chromium.content.browser.FileDescriptorInfo;
import org.chromium.content.common.ContentSwitches;
import org.chromium.content.common.IChildProcessCallback;
import org.chromium.content.common.SurfaceWrapper;

@JNINamespace(value="content")
public class ChildProcessLauncher {
    private static final String TAG = "ChildProcLauncher";
    static final int CALLBACK_FOR_UNKNOWN_PROCESS = 0;
    static final int CALLBACK_FOR_GPU_PROCESS = 1;
    static final int CALLBACK_FOR_RENDERER_PROCESS = 2;
    static final int CALLBACK_FOR_UTILITY_PROCESS = 3;
    static final int CALLBACK_FOR_DOWNLOAD_PROCESS = 4;
    private static Map<String, ChildConnectionAllocator> sSandboxedChildConnectionAllocatorMap;
    private static ChildConnectionAllocator sPrivilegedChildConnectionAllocator;
    private static final String NUM_SANDBOXED_SERVICES_KEY = "org.chromium.content.browser.NUM_SANDBOXED_SERVICES";
    private static final String NUM_PRIVILEGED_SERVICES_KEY = "org.chromium.content.browser.NUM_PRIVILEGED_SERVICES";
    private static final String SANDBOXED_SERVICES_NAME_KEY = "org.chromium.content.browser.SANDBOXED_SERVICES_NAME";
    @VisibleForTesting
    public static final String SWITCH_NUM_SANDBOXED_SERVICES_FOR_TESTING = "num-sandboxed-services";
    public static final String SWITCH_SANDBOXED_SERVICES_NAME_FOR_TESTING = "sandboxed-services-name";
    private static boolean sLinkerInitialized;
    private static long sLinkerLoadAddress;
    private static final long FREE_CONNECTION_DELAY_MILLIS = 1L;
    private static final int NULL_PROCESS_HANDLE = 0;
    private static Map<Integer, ChildProcessConnection> sServiceMap;
    private static ChildProcessConnection sSpareSandboxedConnection;
    private static BindingManager sBindingManager;
    private static Map<Integer, Surface> sViewSurfaceMap;
    private static Map<Pair<Integer, Integer>, Surface> sSurfaceTextureSurfaceMap;
    private static boolean sApplicationInForeground;

    private static int getNumberOfServices(Context context, boolean inSandbox, String packageName) {
        int numServices = -1;
        if (inSandbox && CommandLine.getInstance().hasSwitch(SWITCH_NUM_SANDBOXED_SERVICES_FOR_TESTING)) {
            String value = CommandLine.getInstance().getSwitchValue(SWITCH_NUM_SANDBOXED_SERVICES_FOR_TESTING);
            if (!TextUtils.isEmpty((CharSequence)value)) {
                try {
                    numServices = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    Log.w(TAG, "The value of --num-sandboxed-services is formatted wrongly: " + value, new Object[0]);
                }
            }
        } else {
            try {
                PackageManager packageManager = context.getPackageManager();
                ApplicationInfo appInfo = packageManager.getApplicationInfo(packageName, 128);
                if (appInfo.metaData != null) {
                    numServices = appInfo.metaData.getInt(inSandbox ? NUM_SANDBOXED_SERVICES_KEY : NUM_PRIVILEGED_SERVICES_KEY, -1);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new RuntimeException("Could not get application info");
            }
        }
        if (numServices < 0) {
            throw new RuntimeException("Illegal meta data value for number of child services");
        }
        return numServices;
    }

    private static String getClassNameOfService(Context context, boolean inSandbox, String packageName) {
        PackageManager packageManager;
        if (!inSandbox) {
            return PrivilegedProcessService.class.getName();
        }
        if (CommandLine.getInstance().hasSwitch(SWITCH_SANDBOXED_SERVICES_NAME_FOR_TESTING)) {
            return CommandLine.getInstance().getSwitchValue(SWITCH_SANDBOXED_SERVICES_NAME_FOR_TESTING);
        }
        String serviceName = null;
        try {
            packageManager = context.getPackageManager();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(packageName, 128);
            if (appInfo.metaData != null) {
                serviceName = appInfo.metaData.getString(SANDBOXED_SERVICES_NAME_KEY);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Could not get application info.");
        }
        if (serviceName != null) {
            try {
                packageManager = context.getPackageManager();
                packageManager.getServiceInfo(new ComponentName(packageName, serviceName + "0"), 0);
                return serviceName;
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new RuntimeException("Illegal meta data value: the child service doesn't exist");
            }
        }
        return SandboxedProcessService.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initConnectionAllocatorsIfNecessary(Context context, boolean inSandbox, String packageName) {
        Class<ChildProcessLauncher> clazz = ChildProcessLauncher.class;
        synchronized (ChildProcessLauncher.class) {
            if (inSandbox) {
                if (sSandboxedChildConnectionAllocatorMap == null) {
                    sSandboxedChildConnectionAllocatorMap = new ConcurrentHashMap<String, ChildConnectionAllocator>();
                }
                if (!sSandboxedChildConnectionAllocatorMap.containsKey(packageName)) {
                    Log.w(TAG, "Create a new ChildConnectionAllocator with package name = %s, inSandbox = true", packageName);
                    sSandboxedChildConnectionAllocatorMap.put(packageName, new ChildConnectionAllocator(true, ChildProcessLauncher.getNumberOfServices(context, true, packageName), ChildProcessLauncher.getClassNameOfService(context, true, packageName)));
                }
            } else if (sPrivilegedChildConnectionAllocator == null) {
                sPrivilegedChildConnectionAllocator = new ChildConnectionAllocator(false, ChildProcessLauncher.getNumberOfServices(context, false, packageName), ChildProcessLauncher.getClassNameOfService(context, false, packageName));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static ChildConnectionAllocator getConnectionAllocator(String packageName, boolean inSandbox) {
        if (!inSandbox) {
            return sPrivilegedChildConnectionAllocator;
        }
        return sSandboxedChildConnectionAllocatorMap.get(packageName);
    }

    private static PendingSpawnQueue getPendingSpawnQueue(Context context, String packageName, boolean inSandbox) {
        ChildProcessLauncher.initConnectionAllocatorsIfNecessary(context, inSandbox, packageName);
        return ChildProcessLauncher.getConnectionAllocator(packageName, inSandbox).getPendingSpawnQueue();
    }

    private static ChildProcessConnection allocateConnection(Context context, boolean inSandbox, ChromiumLinkerParams chromiumLinkerParams, boolean alwaysInForeground, ChildProcessCreationParams creationParams) {
        ChildProcessConnection.DeathCallback deathCallback = new ChildProcessConnection.DeathCallback(){

            @Override
            public void onChildProcessDied(ChildProcessConnection connection) {
                if (connection.getPid() != 0) {
                    ChildProcessLauncher.stop(connection.getPid());
                } else {
                    ChildProcessLauncher.freeConnection(connection);
                }
            }
        };
        String packageName = creationParams != null ? creationParams.getPackageName() : context.getPackageName();
        ChildProcessLauncher.initConnectionAllocatorsIfNecessary(context, inSandbox, packageName);
        return ChildProcessLauncher.getConnectionAllocator(packageName, inSandbox).allocate(context, deathCallback, chromiumLinkerParams, alwaysInForeground, creationParams);
    }

    private static ChromiumLinkerParams getLinkerParamsForNewConnection() {
        if (!sLinkerInitialized) {
            if (Linker.isUsed() && (sLinkerLoadAddress = Linker.getInstance().getBaseLoadAddress()) == 0L) {
                Log.i(TAG, "Shared RELRO support disabled!", new Object[0]);
            }
            sLinkerInitialized = true;
        }
        if (sLinkerLoadAddress == 0L) {
            return null;
        }
        boolean waitForSharedRelros = true;
        if (Linker.areTestsEnabled()) {
            Linker linker = Linker.getInstance();
            return new ChromiumLinkerParams(sLinkerLoadAddress, true, linker.getTestRunnerClassNameForTesting(), linker.getImplementationForTesting());
        }
        return new ChromiumLinkerParams(sLinkerLoadAddress, true);
    }

    private static ChildProcessConnection allocateBoundConnection(Context context, String[] commandLine, boolean inSandbox, boolean alwaysInForeground, ChildProcessCreationParams creationParams) {
        ChromiumLinkerParams chromiumLinkerParams = ChildProcessLauncher.getLinkerParamsForNewConnection();
        ChildProcessConnection connection = ChildProcessLauncher.allocateConnection(context, inSandbox, chromiumLinkerParams, alwaysInForeground, creationParams);
        if (connection != null) {
            String packageName;
            connection.start(commandLine);
            String string2 = packageName = creationParams != null ? creationParams.getPackageName() : context.getPackageName();
            if (inSandbox && !ChildProcessLauncher.getConnectionAllocator(packageName, inSandbox).isFreeConnectionAvailable()) {
                sBindingManager.releaseAllModerateBindings();
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void freeConnection(ChildProcessConnection connection) {
        Class<ChildProcessLauncher> clazz = ChildProcessLauncher.class;
        synchronized (ChildProcessLauncher.class) {
            if (connection.equals(sSpareSandboxedConnection)) {
                sSpareSandboxedConnection = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            final ChildProcessConnection conn = connection;
            ThreadUtils.postOnUiThreadDelayed(new Runnable(){

                @Override
                public void run() {
                    final PendingSpawnData pendingSpawn = ChildProcessLauncher.freeConnectionAndDequeuePending(conn);
                    if (pendingSpawn != null) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                ChildProcessLauncher.startInternal(pendingSpawn.context(), pendingSpawn.commandLine(), pendingSpawn.childProcessId(), pendingSpawn.filesToBeMapped(), pendingSpawn.clientContext(), pendingSpawn.callbackType(), pendingSpawn.inSandbox(), pendingSpawn.getCreationParams());
                            }
                        }).start();
                    }
                }
            }, 1L);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PendingSpawnData freeConnectionAndDequeuePending(ChildProcessConnection conn) {
        ChildConnectionAllocator allocator = ChildProcessLauncher.getConnectionAllocator(conn.getPackageName(), conn.isInSandbox());
        assert (allocator != null);
        PendingSpawnQueue pendingSpawnQueue = allocator.getPendingSpawnQueue();
        Object object = pendingSpawnQueue.mPendingSpawnsLock;
        synchronized (object) {
            allocator.free(conn);
            return pendingSpawnQueue.dequeueLocked();
        }
    }

    @VisibleForTesting
    public static void setBindingManagerForTesting(BindingManager manager) {
        sBindingManager = manager;
    }

    @CalledByNative
    private static boolean isOomProtected(int pid) {
        return sBindingManager.isOomProtected(pid);
    }

    @CalledByNative
    private static void registerViewSurface(int surfaceId, Surface surface) {
        if (!surface.isValid()) {
            throw new RuntimeException("Attempting to register invalid Surface.");
        }
        sViewSurfaceMap.put(surfaceId, surface);
    }

    @CalledByNative
    private static void unregisterViewSurface(int surfaceId) {
        sViewSurfaceMap.remove(surfaceId);
    }

    @CalledByNative
    private static Surface getViewSurface(int surfaceId) {
        Surface surface = sViewSurfaceMap.get(surfaceId);
        if (surface == null) {
            Log.e(TAG, "Invalid surfaceId.", new Object[0]);
            return null;
        }
        if (!surface.isValid()) {
            Log.e(TAG, "Requested surface is not valid.", new Object[0]);
            return null;
        }
        return surface;
    }

    private static void registerSurfaceTextureSurface(int surfaceTextureId, int clientId, Surface surface) {
        Pair key = new Pair((Object)surfaceTextureId, (Object)clientId);
        sSurfaceTextureSurfaceMap.put((Pair<Integer, Integer>)key, surface);
    }

    private static void unregisterSurfaceTextureSurface(int surfaceTextureId, int clientId) {
        Pair key = new Pair((Object)surfaceTextureId, (Object)clientId);
        Surface surface = sSurfaceTextureSurfaceMap.remove(key);
        if (surface == null) {
            return;
        }
        assert (surface.isValid());
        surface.release();
    }

    @CalledByNative
    private static void createSurfaceTextureSurface(int surfaceTextureId, int clientId, SurfaceTexture surfaceTexture) {
        ChildProcessLauncher.registerSurfaceTextureSurface(surfaceTextureId, clientId, new Surface(surfaceTexture));
    }

    @CalledByNative
    private static void destroySurfaceTextureSurface(int surfaceTextureId, int clientId) {
        ChildProcessLauncher.unregisterSurfaceTextureSurface(surfaceTextureId, clientId);
    }

    @CalledByNative
    private static SurfaceWrapper getSurfaceTextureSurface(int surfaceTextureId, int clientId) {
        Pair key = new Pair((Object)surfaceTextureId, (Object)clientId);
        Surface surface = sSurfaceTextureSurfaceMap.get(key);
        if (surface == null) {
            Log.e(TAG, "Invalid Id for surface texture.", new Object[0]);
            return null;
        }
        assert (surface.isValid());
        return new SurfaceWrapper(surface);
    }

    @CalledByNative
    public static void setInForeground(int pid, boolean inForeground) {
        sBindingManager.setInForeground(pid, inForeground);
    }

    public static void determinedVisibility(int pid) {
        sBindingManager.determinedVisibility(pid);
    }

    public static void onSentToBackground() {
        sApplicationInForeground = false;
        sBindingManager.onSentToBackground();
    }

    public static void startModerateBindingManagement(Context context, boolean moderateBindingTillBackgrounded) {
        sBindingManager.startModerateBindingManagement(context, ChildProcessLauncher.getNumberOfServices(context, true, context.getPackageName()), moderateBindingTillBackgrounded);
    }

    public static void onBroughtToForeground() {
        sApplicationInForeground = true;
        sBindingManager.onBroughtToForeground();
    }

    static boolean isApplicationInForeground() {
        return sApplicationInForeground;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warmUp(Context context) {
        Class<ChildProcessLauncher> clazz = ChildProcessLauncher.class;
        synchronized (ChildProcessLauncher.class) {
            assert (!ThreadUtils.runningOnUiThread());
            if (sSpareSandboxedConnection == null) {
                ChildProcessCreationParams params = ChildProcessCreationParams.get();
                if (params != null) {
                    params = params.copy();
                }
                sSpareSandboxedConnection = ChildProcessLauncher.allocateBoundConnection(context, null, true, false, params);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @CalledByNative
    private static FileDescriptorInfo makeFdInfo(int id2, int fd, boolean autoClose, long offset, long size) {
        ParcelFileDescriptor pFd;
        if (autoClose) {
            pFd = ParcelFileDescriptor.adoptFd((int)fd);
        } else {
            try {
                pFd = ParcelFileDescriptor.fromFd((int)fd);
            }
            catch (IOException e) {
                Log.e(TAG, "Invalid FD provided for process connection, aborting connection.", e);
                return null;
            }
        }
        return new FileDescriptorInfo(id2, pFd, offset, size);
    }

    @CalledByNative
    private static void start(Context context, String[] commandLine, int childProcessId, FileDescriptorInfo[] filesToBeMapped, long clientContext) {
        assert (clientContext != 0L);
        int callbackType = 0;
        boolean inSandbox = true;
        String processType = ContentSwitches.getSwitchValue(commandLine, "type");
        ChildProcessCreationParams params = ChildProcessCreationParams.get();
        if (params != null) {
            params = params.copy();
        }
        if ("renderer".equals(processType)) {
            callbackType = 2;
        } else {
            if (params != null && !params.getPackageName().equals(context.getPackageName())) {
                params = new ChildProcessCreationParams(context.getPackageName(), params.getExtraBindFlags(), params.getLibraryProcessType());
            }
            if ("gpu-process".equals(processType)) {
                callbackType = 1;
                inSandbox = false;
            } else if ("utility".equals(processType)) {
                callbackType = 3;
            } else assert (false);
        }
        ChildProcessLauncher.startInternal(context, commandLine, childProcessId, filesToBeMapped, clientContext, callbackType, inSandbox, params);
    }

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    private static void startDownloadProcessIfNecessary(Context context, String[] commandLine) {
        assert (Build.VERSION.SDK_INT >= 18);
        String processType = ContentSwitches.getSwitchValue(commandLine, "type");
        assert ("download".equals(processType));
        Intent intent = new Intent();
        intent.setClass(context, DownloadProcessService.class);
        intent.setPackage(context.getPackageName());
        intent.putExtra("com.google.android.apps.chrome.extra.command_line", commandLine);
        Bundle bundle = ChildProcessLauncher.createsServiceBundle(commandLine, null, Linker.getInstance().getSharedRelros());
        bundle.putBinder("com.google.android.apps.chrome.extra.child_process_callback", ChildProcessLauncher.createCallback(0, 4).asBinder());
        intent.putExtras(bundle);
        ChromiumLinkerParams linkerParams = ChildProcessLauncher.getLinkerParamsForNewConnection();
        if (linkerParams != null) {
            linkerParams.addIntentExtras(intent);
        }
        context.startService(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void startInternal(Context context, String[] commandLine, int childProcessId, FileDescriptorInfo[] filesToBeMapped, long clientContext, int callbackType, boolean inSandbox, ChildProcessCreationParams creationParams) {
        try {
            TraceEvent.begin("ChildProcessLauncher.startInternal");
            ChildProcessConnection allocatedConnection = null;
            String packageName = creationParams != null ? creationParams.getPackageName() : context.getPackageName();
            Class<ChildProcessLauncher> clazz = ChildProcessLauncher.class;
            synchronized (ChildProcessLauncher.class) {
                if (inSandbox && sSpareSandboxedConnection != null && sSpareSandboxedConnection.getPackageName().equals(packageName)) {
                    allocatedConnection = sSpareSandboxedConnection;
                    sSpareSandboxedConnection = null;
                }
                // ** MonitorExit[var11_10] (shouldn't be in output)
                if (allocatedConnection == null) {
                    boolean alwaysInForeground = false;
                    if (callbackType == 1) {
                        alwaysInForeground = true;
                    }
                    PendingSpawnQueue pendingSpawnQueue = ChildProcessLauncher.getPendingSpawnQueue(context, packageName, inSandbox);
                    Object object = pendingSpawnQueue.mPendingSpawnsLock;
                    synchronized (object) {
                        allocatedConnection = ChildProcessLauncher.allocateBoundConnection(context, commandLine, inSandbox, alwaysInForeground, creationParams);
                        if (allocatedConnection == null) {
                            Log.d(TAG, "Allocation of new service failed. Queuing up pending spawn.");
                            pendingSpawnQueue.enqueueLocked(new PendingSpawnData(context, commandLine, childProcessId, filesToBeMapped, clientContext, callbackType, inSandbox, creationParams));
                            return;
                        }
                    }
                }
                Log.d(TAG, "Setting up connection to process: slot=%d", allocatedConnection.getServiceNumber());
                ChildProcessLauncher.triggerConnectionSetup(allocatedConnection, commandLine, childProcessId, filesToBeMapped, callbackType, clientContext);
                return;
            }
        }
        finally {
            TraceEvent.end("ChildProcessLauncher.startInternal");
        }
    }

    protected static Bundle createsServiceBundle(String[] commandLine, FileDescriptorInfo[] filesToBeMapped, Bundle sharedRelros) {
        Bundle bundle = new Bundle();
        bundle.putStringArray("com.google.android.apps.chrome.extra.command_line", commandLine);
        bundle.putParcelableArray("com.google.android.apps.chrome.extra.extraFiles", (Parcelable[])filesToBeMapped);
        bundle.putInt("com.google.android.apps.chrome.extra.cpu_count", CpuFeatures.getCount());
        bundle.putLong("com.google.android.apps.chrome.extra.cpu_features", CpuFeatures.getMask());
        bundle.putBundle("org.chromium.base.android.linker.shared_relros", sharedRelros);
        return bundle;
    }

    @VisibleForTesting
    static void triggerConnectionSetup(final ChildProcessConnection connection, String[] commandLine, int childProcessId, FileDescriptorInfo[] filesToBeMapped, final int callbackType, final long clientContext) {
        ChildProcessConnection.ConnectionCallback connectionCallback = new ChildProcessConnection.ConnectionCallback(){

            @Override
            public void onConnected(int pid) {
                Log.d(ChildProcessLauncher.TAG, "on connect callback, pid=%d context=%d callbackType=%d", pid, clientContext, callbackType);
                if (pid != 0) {
                    sBindingManager.addNewConnection(pid, connection);
                    sServiceMap.put(pid, connection);
                }
                if (clientContext != 0L) {
                    ChildProcessLauncher.nativeOnChildProcessStarted(clientContext, pid);
                }
            }
        };
        assert (callbackType != 0);
        connection.setupConnection(commandLine, filesToBeMapped, ChildProcessLauncher.createCallback(childProcessId, callbackType), connectionCallback, Linker.getInstance().getSharedRelros());
    }

    @CalledByNative
    static void stop(int pid) {
        Log.d(TAG, "stopping child connection: pid=%d", pid);
        ChildProcessConnection connection = sServiceMap.remove(pid);
        if (connection == null) {
            ChildProcessLauncher.logPidWarning(pid, "Tried to stop non-existent connection");
            return;
        }
        sBindingManager.clearConnection(pid);
        connection.stop();
        ChildProcessLauncher.freeConnection(connection);
    }

    private static IChildProcessCallback createCallback(final int childProcessId, final int callbackType) {
        return new IChildProcessCallback.Stub(){

            @Override
            public void establishSurfacePeer(int pid, Surface surface, int primaryID, int secondaryID) {
                if (callbackType != 1) {
                    Log.e(ChildProcessLauncher.TAG, "Illegal callback for non-GPU process.", new Object[0]);
                    return;
                }
                ChildProcessLauncher.nativeEstablishSurfacePeer(pid, surface, primaryID, secondaryID);
            }

            @Override
            public SurfaceWrapper getViewSurface(int surfaceId) {
                if (callbackType != 1) {
                    Log.e(ChildProcessLauncher.TAG, "Illegal callback for non-GPU process.", new Object[0]);
                    return null;
                }
                Surface surface = ChildProcessLauncher.getViewSurface(surfaceId);
                if (surface == null) {
                    return null;
                }
                return new SurfaceWrapper(surface);
            }

            @Override
            public void registerSurfaceTextureSurface(int surfaceTextureId, int clientId, Surface surface) {
                if (callbackType != 1) {
                    Log.e(ChildProcessLauncher.TAG, "Illegal callback for non-GPU process.", new Object[0]);
                    return;
                }
                ChildProcessLauncher.registerSurfaceTextureSurface(surfaceTextureId, clientId, surface);
            }

            @Override
            public void unregisterSurfaceTextureSurface(int surfaceTextureId, int clientId) {
                if (callbackType != 1) {
                    Log.e(ChildProcessLauncher.TAG, "Illegal callback for non-GPU process.", new Object[0]);
                    return;
                }
                ChildProcessLauncher.unregisterSurfaceTextureSurface(surfaceTextureId, clientId);
            }

            @Override
            public SurfaceWrapper getSurfaceTextureSurface(int surfaceTextureId) {
                if (callbackType != 2) {
                    Log.e(ChildProcessLauncher.TAG, "Illegal callback for non-renderer process.", new Object[0]);
                    return null;
                }
                return ChildProcessLauncher.getSurfaceTextureSurface(surfaceTextureId, childProcessId);
            }

            @Override
            public void onDownloadStarted(boolean started, int downloadId) {
                if (callbackType != 4) {
                    Log.e(ChildProcessLauncher.TAG, "Illegal callback for non-download process.", new Object[0]);
                    return;
                }
            }
        };
    }

    static void logPidWarning(int pid, String message) {
        if (pid > 0 && !ChildProcessLauncher.nativeIsSingleProcess()) {
            Log.w(TAG, "%s, pid=%d", message, pid);
        }
    }

    @VisibleForTesting
    static ChildProcessConnection allocateBoundConnectionForTesting(Context context, ChildProcessCreationParams creationParams) {
        return ChildProcessLauncher.allocateBoundConnection(context, null, true, false, creationParams);
    }

    @VisibleForTesting
    static ChildProcessConnection allocateConnectionForTesting(Context context, ChildProcessCreationParams creationParams) {
        return ChildProcessLauncher.allocateConnection(context, true, ChildProcessLauncher.getLinkerParamsForNewConnection(), false, creationParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void enqueuePendingSpawnForTesting(Context context, String[] commandLine, ChildProcessCreationParams creationParams, boolean inSandbox) {
        String packageName = creationParams != null ? creationParams.getPackageName() : context.getPackageName();
        PendingSpawnQueue pendingSpawnQueue = ChildProcessLauncher.getPendingSpawnQueue(context, packageName, inSandbox);
        Object object = pendingSpawnQueue.mPendingSpawnsLock;
        synchronized (object) {
            pendingSpawnQueue.enqueueLocked(new PendingSpawnData(context, commandLine, 1, new FileDescriptorInfo[0], 0L, 2, true, creationParams));
        }
    }

    @VisibleForTesting
    static int allocatedSandboxedConnectionsCountForTesting(Context context, String packageName) {
        ChildProcessLauncher.initConnectionAllocatorsIfNecessary(context, true, packageName);
        return sSandboxedChildConnectionAllocatorMap.get(packageName).allocatedConnectionsCountForTesting();
    }

    @VisibleForTesting
    static int connectedServicesCountForTesting() {
        return sServiceMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static int pendingSpawnsCountForTesting(Context context, String packageName, boolean inSandbox) {
        PendingSpawnQueue pendingSpawnQueue = ChildProcessLauncher.getPendingSpawnQueue(context, packageName, inSandbox);
        Object object = pendingSpawnQueue.mPendingSpawnsLock;
        synchronized (object) {
            return pendingSpawnQueue.sizeLocked();
        }
    }

    @VisibleForTesting
    public static boolean crashProcessForTesting(int pid) {
        if (sServiceMap.get(pid) == null) {
            return false;
        }
        try {
            ((ChildProcessConnectionImpl)sServiceMap.get(pid)).crashServiceForTesting();
        }
        catch (RemoteException ex) {
            return false;
        }
        return true;
    }

    private static native void nativeOnChildProcessStarted(long var0, int var2);

    private static native void nativeEstablishSurfacePeer(int var0, Surface var1, int var2, int var3);

    private static native boolean nativeIsSingleProcess();

    static {
        sLinkerInitialized = false;
        sLinkerLoadAddress = 0L;
        sServiceMap = new ConcurrentHashMap<Integer, ChildProcessConnection>();
        sSpareSandboxedConnection = null;
        sBindingManager = BindingManagerImpl.createBindingManager();
        sViewSurfaceMap = new ConcurrentHashMap<Integer, Surface>();
        sSurfaceTextureSurfaceMap = new ConcurrentHashMap<Pair<Integer, Integer>, Surface>();
        sApplicationInForeground = true;
    }

    private static class PendingSpawnQueue {
        private Queue<PendingSpawnData> mPendingSpawns = new LinkedList<PendingSpawnData>();
        final Object mPendingSpawnsLock = new Object();

        private PendingSpawnQueue() {
        }

        public void enqueueLocked(PendingSpawnData pendingSpawn) {
            assert (Thread.holdsLock(this.mPendingSpawnsLock));
            this.mPendingSpawns.add(pendingSpawn);
        }

        public PendingSpawnData dequeueLocked() {
            assert (Thread.holdsLock(this.mPendingSpawnsLock));
            return this.mPendingSpawns.poll();
        }

        public int sizeLocked() {
            assert (Thread.holdsLock(this.mPendingSpawnsLock));
            return this.mPendingSpawns.size();
        }
    }

    private static class PendingSpawnData {
        private final Context mContext;
        private final String[] mCommandLine;
        private final int mChildProcessId;
        private final FileDescriptorInfo[] mFilesToBeMapped;
        private final long mClientContext;
        private final int mCallbackType;
        private final boolean mInSandbox;
        private final ChildProcessCreationParams mCreationParams;

        private PendingSpawnData(Context context, String[] commandLine, int childProcessId, FileDescriptorInfo[] filesToBeMapped, long clientContext, int callbackType, boolean inSandbox, ChildProcessCreationParams creationParams) {
            this.mContext = context;
            this.mCommandLine = commandLine;
            this.mChildProcessId = childProcessId;
            this.mFilesToBeMapped = filesToBeMapped;
            this.mClientContext = clientContext;
            this.mCallbackType = callbackType;
            this.mInSandbox = inSandbox;
            this.mCreationParams = creationParams;
        }

        private Context context() {
            return this.mContext;
        }

        private String[] commandLine() {
            return this.mCommandLine;
        }

        private int childProcessId() {
            return this.mChildProcessId;
        }

        private FileDescriptorInfo[] filesToBeMapped() {
            return this.mFilesToBeMapped;
        }

        private long clientContext() {
            return this.mClientContext;
        }

        private int callbackType() {
            return this.mCallbackType;
        }

        private boolean inSandbox() {
            return this.mInSandbox;
        }

        private ChildProcessCreationParams getCreationParams() {
            return this.mCreationParams;
        }
    }

    private static class ChildConnectionAllocator {
        private final ChildProcessConnection[] mChildProcessConnections;
        private final ArrayList<Integer> mFreeConnectionIndices;
        private final Object mConnectionLock = new Object();
        private final String mChildClassName;
        private final boolean mInSandbox;
        private final PendingSpawnQueue mPendingSpawnQueue = new PendingSpawnQueue();

        public ChildConnectionAllocator(boolean inSandbox, int numChildServices, String serviceClassName) {
            this.mChildProcessConnections = new ChildProcessConnectionImpl[numChildServices];
            this.mFreeConnectionIndices = new ArrayList(numChildServices);
            for (int i = 0; i < numChildServices; ++i) {
                this.mFreeConnectionIndices.add(i);
            }
            this.mChildClassName = serviceClassName;
            this.mInSandbox = inSandbox;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChildProcessConnection allocate(Context context, ChildProcessConnection.DeathCallback deathCallback, ChromiumLinkerParams chromiumLinkerParams, boolean alwaysInForeground, ChildProcessCreationParams creationParams) {
            Object object = this.mConnectionLock;
            synchronized (object) {
                if (this.mFreeConnectionIndices.isEmpty()) {
                    Log.d(ChildProcessLauncher.TAG, "Ran out of services to allocate.");
                    return null;
                }
                int slot = this.mFreeConnectionIndices.remove(0);
                assert (this.mChildProcessConnections[slot] == null);
                this.mChildProcessConnections[slot] = new ChildProcessConnectionImpl(context, slot, this.mInSandbox, deathCallback, this.mChildClassName, chromiumLinkerParams, alwaysInForeground, creationParams);
                Log.d(ChildProcessLauncher.TAG, "Allocator allocated a connection, sandbox: %b, slot: %d", this.mInSandbox, slot);
                return this.mChildProcessConnections[slot];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void free(ChildProcessConnection connection) {
            Object object = this.mConnectionLock;
            synchronized (object) {
                int slot = connection.getServiceNumber();
                if (this.mChildProcessConnections[slot] != connection) {
                    int occupier = this.mChildProcessConnections[slot] == null ? -1 : this.mChildProcessConnections[slot].getServiceNumber();
                    Log.e(ChildProcessLauncher.TAG, "Unable to find connection to free in slot: %d already occupied by service: %d", slot, occupier);
                    assert (false);
                } else {
                    this.mChildProcessConnections[slot] = null;
                    assert (!this.mFreeConnectionIndices.contains(slot));
                    this.mFreeConnectionIndices.add(slot);
                    Log.d(ChildProcessLauncher.TAG, "Allocator freed a connection, sandbox: %b, slot: %d", this.mInSandbox, slot);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isFreeConnectionAvailable() {
            Object object = this.mConnectionLock;
            synchronized (object) {
                return !this.mFreeConnectionIndices.isEmpty();
            }
        }

        public PendingSpawnQueue getPendingSpawnQueue() {
            return this.mPendingSpawnQueue;
        }

        @VisibleForTesting
        int allocatedConnectionsCountForTesting() {
            return this.mChildProcessConnections.length - this.mFreeConnectionIndices.size();
        }
    }
}

