/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import java.util.concurrent.FutureTask;
import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.MainDex;
import org.chromium.content.browser.LocationProviderFactory;

@MainDex
@VisibleForTesting
public class LocationProviderAdapter {
    private LocationProviderFactory.LocationProvider mImpl;

    private LocationProviderAdapter(Context context) {
        this.mImpl = LocationProviderFactory.get(context);
    }

    @CalledByNative
    static LocationProviderAdapter create(Context context) {
        return new LocationProviderAdapter(context);
    }

    @CalledByNative
    public boolean start(final boolean enableHighAccuracy) {
        FutureTask<Object> task = new FutureTask<Object>(new Runnable(){

            @Override
            public void run() {
                LocationProviderAdapter.this.mImpl.start(enableHighAccuracy);
            }
        }, null);
        ThreadUtils.runOnUiThread(task);
        return true;
    }

    @CalledByNative
    public void stop() {
        FutureTask<Object> task = new FutureTask<Object>(new Runnable(){

            @Override
            public void run() {
                LocationProviderAdapter.this.mImpl.stop();
            }
        }, null);
        ThreadUtils.runOnUiThread(task);
    }

    public boolean isRunning() {
        assert (ThreadUtils.runningOnUiThread());
        return this.mImpl.isRunning();
    }

    public static void newLocationAvailable(double latitude, double longitude, double timestamp, boolean hasAltitude, double altitude, boolean hasAccuracy, double accuracy, boolean hasHeading, double heading, boolean hasSpeed, double speed) {
        LocationProviderAdapter.nativeNewLocationAvailable(latitude, longitude, timestamp, hasAltitude, altitude, hasAccuracy, accuracy, hasHeading, heading, hasSpeed, speed);
    }

    public static void newErrorAvailable(String message) {
        LocationProviderAdapter.nativeNewErrorAvailable(message);
    }

    private static native void nativeNewLocationAvailable(double var0, double var2, double var4, boolean var6, double var7, boolean var9, double var10, boolean var12, double var13, boolean var15, double var16);

    private static native void nativeNewErrorAvailable(String var0);
}

