/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.media.AudioManager;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="content")
public class MediaSessionDelegate
implements AudioManager.OnAudioFocusChangeListener {
    private static final String TAG = "MediaSession";
    public static final double DUCKING_VOLUME_MULTIPLIER = (double)0.2f;
    public static final double DEFAULT_VOLUME_MULTIPLIER = 1.0;
    private Context mContext;
    private int mFocusType;
    private boolean mIsDucking = false;
    private long mNativeMediaSessionDelegateAndroid;

    private MediaSessionDelegate(Context context, long nativeMediaSessionDelegateAndroid) {
        this.mContext = context;
        this.mNativeMediaSessionDelegateAndroid = nativeMediaSessionDelegateAndroid;
    }

    @CalledByNative
    private static MediaSessionDelegate create(Context context, long nativeMediaSessionDelegateAndroid) {
        return new MediaSessionDelegate(context, nativeMediaSessionDelegateAndroid);
    }

    @CalledByNative
    private void tearDown() {
        this.abandonAudioFocus();
        this.mNativeMediaSessionDelegateAndroid = 0L;
    }

    @CalledByNative
    private boolean requestAudioFocus(boolean transientFocus) {
        this.mFocusType = transientFocus ? 3 : 1;
        return this.requestAudioFocusInternal();
    }

    @CalledByNative
    private void abandonAudioFocus() {
        AudioManager am = (AudioManager)this.mContext.getSystemService("audio");
        am.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
    }

    private boolean requestAudioFocusInternal() {
        AudioManager am = (AudioManager)this.mContext.getSystemService("audio");
        int result = am.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, this.mFocusType);
        return result == 1;
    }

    public void onAudioFocusChange(int focusChange) {
        if (this.mNativeMediaSessionDelegateAndroid == 0L) {
            return;
        }
        switch (focusChange) {
            case 1: {
                if (this.mIsDucking) {
                    this.nativeOnSetVolumeMultiplier(this.mNativeMediaSessionDelegateAndroid, 1.0);
                    this.mIsDucking = false;
                    break;
                }
                this.nativeOnResume(this.mNativeMediaSessionDelegateAndroid);
                break;
            }
            case -2: {
                this.nativeOnSuspend(this.mNativeMediaSessionDelegateAndroid, true);
                break;
            }
            case -3: {
                this.mIsDucking = true;
                this.nativeRecordSessionDuck(this.mNativeMediaSessionDelegateAndroid);
                this.nativeOnSetVolumeMultiplier(this.mNativeMediaSessionDelegateAndroid, 0.2f);
                break;
            }
            case -1: {
                this.abandonAudioFocus();
                this.nativeOnSuspend(this.mNativeMediaSessionDelegateAndroid, false);
                break;
            }
            default: {
                Log.w(TAG, "onAudioFocusChange called with unexpected value %d", focusChange);
            }
        }
    }

    private native void nativeOnSuspend(long var1, boolean var3);

    private native void nativeOnResume(long var1);

    private native void nativeOnSetVolumeMultiplier(long var1, double var3);

    private native void nativeRecordSessionDuck(long var1);
}

