/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.view.MotionEvent;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.ContentViewCore;

@JNINamespace(value="content")
public class MotionEventSynthesizer {
    private static final int MAX_NUM_POINTERS = 16;
    private static final int ACTION_START = 0;
    private static final int ACTION_MOVE = 1;
    private static final int ACTION_CANCEL = 2;
    private static final int ACTION_END = 3;
    private static final int ACTION_SCROLL = 4;
    private final ContentViewCore mContentViewCore;
    private final MotionEvent.PointerProperties[] mPointerProperties;
    private final MotionEvent.PointerCoords[] mPointerCoords;
    private long mDownTimeInMs;

    MotionEventSynthesizer(ContentViewCore contentViewCore) {
        this.mContentViewCore = contentViewCore;
        this.mPointerProperties = new MotionEvent.PointerProperties[16];
        this.mPointerCoords = new MotionEvent.PointerCoords[16];
    }

    @CalledByNative
    void setPointer(int index, int x, int y, int id2) {
        assert (0 <= index && index < 16);
        float scaleFactor = this.mContentViewCore.getRenderCoordinates().getDeviceScaleFactor();
        MotionEvent.PointerCoords coords = new MotionEvent.PointerCoords();
        coords.x = scaleFactor * (float)x;
        coords.y = scaleFactor * (float)y;
        coords.pressure = 1.0f;
        this.mPointerCoords[index] = coords;
        MotionEvent.PointerProperties properties = new MotionEvent.PointerProperties();
        properties.id = id2;
        this.mPointerProperties[index] = properties;
    }

    @CalledByNative
    void setScrollDeltas(int x, int y, int dx, int dy) {
        this.setPointer(0, x, y, 0);
        float scaleFactor = this.mContentViewCore.getRenderCoordinates().getDeviceScaleFactor();
        this.mPointerCoords[0].setAxisValue(10, scaleFactor * (float)dx);
        this.mPointerCoords[0].setAxisValue(9, scaleFactor * (float)dy);
    }

    @CalledByNative
    void inject(int action, int pointerCount, long timeInMs) {
        switch (action) {
            case 0: {
                this.mDownTimeInMs = timeInMs;
                MotionEvent event = MotionEvent.obtain((long)this.mDownTimeInMs, (long)timeInMs, (int)0, (int)1, (MotionEvent.PointerProperties[])this.mPointerProperties, (MotionEvent.PointerCoords[])this.mPointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)0, (int)0);
                this.mContentViewCore.onTouchEvent(event);
                event.recycle();
                if (pointerCount <= 1) break;
                event = MotionEvent.obtain((long)this.mDownTimeInMs, (long)timeInMs, (int)5, (int)pointerCount, (MotionEvent.PointerProperties[])this.mPointerProperties, (MotionEvent.PointerCoords[])this.mPointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)0, (int)0);
                this.mContentViewCore.onTouchEvent(event);
                event.recycle();
                break;
            }
            case 1: {
                MotionEvent event = MotionEvent.obtain((long)this.mDownTimeInMs, (long)timeInMs, (int)2, (int)pointerCount, (MotionEvent.PointerProperties[])this.mPointerProperties, (MotionEvent.PointerCoords[])this.mPointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)0, (int)0);
                this.mContentViewCore.onTouchEvent(event);
                event.recycle();
                break;
            }
            case 2: {
                MotionEvent event = MotionEvent.obtain((long)this.mDownTimeInMs, (long)timeInMs, (int)3, (int)1, (MotionEvent.PointerProperties[])this.mPointerProperties, (MotionEvent.PointerCoords[])this.mPointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)0, (int)0);
                this.mContentViewCore.onTouchEvent(event);
                event.recycle();
                break;
            }
            case 3: {
                MotionEvent event;
                if (pointerCount > 1) {
                    event = MotionEvent.obtain((long)this.mDownTimeInMs, (long)timeInMs, (int)6, (int)pointerCount, (MotionEvent.PointerProperties[])this.mPointerProperties, (MotionEvent.PointerCoords[])this.mPointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)0, (int)0);
                    this.mContentViewCore.onTouchEvent(event);
                    event.recycle();
                }
                event = MotionEvent.obtain((long)this.mDownTimeInMs, (long)timeInMs, (int)1, (int)1, (MotionEvent.PointerProperties[])this.mPointerProperties, (MotionEvent.PointerCoords[])this.mPointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)0, (int)0);
                this.mContentViewCore.onTouchEvent(event);
                event.recycle();
                break;
            }
            case 4: {
                assert (pointerCount == 1);
                MotionEvent event = MotionEvent.obtain((long)this.mDownTimeInMs, (long)timeInMs, (int)8, (int)pointerCount, (MotionEvent.PointerProperties[])this.mPointerProperties, (MotionEvent.PointerCoords[])this.mPointerCoords, (int)0, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0, (int)2, (int)0);
                this.mContentViewCore.onGenericMotionEvent(event);
                event.recycle();
                break;
            }
            default: {
                assert (false) : "Unreached";
                break;
            }
        }
    }
}

