/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.content.pm.FeatureInfo;
import android.os.Build;

public final class SPenSupport {
    private static final int SPEN_ACTION_DOWN = 211;
    private static final int SPEN_ACTION_UP = 212;
    private static final int SPEN_ACTION_MOVE = 213;
    private static final int SPEN_ACTION_CANCEL = 214;
    private static Boolean sIsSPenSupported;

    public static boolean isSPenSupported(Context context) {
        if (sIsSPenSupported == null) {
            sIsSPenSupported = SPenSupport.detectSPenSupport(context);
        }
        return sIsSPenSupported;
    }

    private static boolean detectSPenSupport(Context context) {
        FeatureInfo[] infos;
        if (!"SAMSUNG".equalsIgnoreCase(Build.MANUFACTURER)) {
            return false;
        }
        for (FeatureInfo info : infos = context.getPackageManager().getSystemAvailableFeatures()) {
            if (!"com.sec.feature.spen_usp".equalsIgnoreCase(info.name)) continue;
            return true;
        }
        return false;
    }

    public static int convertSPenEventAction(int eventActionMasked) {
        switch (eventActionMasked) {
            case 211: {
                return 0;
            }
            case 212: {
                return 1;
            }
            case 213: {
                return 2;
            }
            case 214: {
                return 3;
            }
        }
        return eventActionMasked;
    }
}

