/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.view.View;
import android.view.ViewTreeObserver;
import java.util.ArrayList;
import org.chromium.content.browser.PositionObserver;

public class ViewPositionObserver
implements PositionObserver {
    private View mView;
    private final int[] mPosition = new int[2];
    private final ArrayList<PositionObserver.Listener> mListeners;
    private ViewTreeObserver.OnPreDrawListener mPreDrawListener;

    public ViewPositionObserver(View view) {
        this.mView = view;
        this.mListeners = new ArrayList();
        this.updatePosition();
        this.mPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                ViewPositionObserver.this.updatePosition();
                return true;
            }
        };
    }

    @Override
    public int getPositionX() {
        this.updatePosition();
        return this.mPosition[0];
    }

    @Override
    public int getPositionY() {
        this.updatePosition();
        return this.mPosition[1];
    }

    @Override
    public void addListener(PositionObserver.Listener listener) {
        if (this.mListeners.contains(listener)) {
            return;
        }
        if (this.mListeners.isEmpty()) {
            this.mView.getViewTreeObserver().addOnPreDrawListener(this.mPreDrawListener);
            this.updatePosition();
        }
        this.mListeners.add(listener);
    }

    @Override
    public void removeListener(PositionObserver.Listener listener) {
        if (!this.mListeners.contains(listener)) {
            return;
        }
        this.mListeners.remove(listener);
        if (this.mListeners.isEmpty()) {
            this.mView.getViewTreeObserver().removeOnPreDrawListener(this.mPreDrawListener);
        }
    }

    private void notifyListeners() {
        for (int i = 0; i < this.mListeners.size(); ++i) {
            this.mListeners.get(i).onPositionChanged(this.mPosition[0], this.mPosition[1]);
        }
    }

    private void updatePosition() {
        int previousPositionX = this.mPosition[0];
        int previousPositionY = this.mPosition[1];
        this.mView.getLocationInWindow(this.mPosition);
        if (this.mPosition[0] != previousPositionX || this.mPosition[1] != previousPositionY) {
            this.notifyListeners();
        }
    }

    @Override
    public void clearListener() {
        this.mListeners.clear();
    }
}

