/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.annotation.TargetApi;
import android.os.Build;
import android.view.ActionMode;
import android.view.View;
import android.view.ViewConfiguration;
import org.chromium.base.Log;

@TargetApi(value=23)
public class WebActionMode {
    private static final String TAG = "cr.WebActionMode";
    private static final int SHOW_DELAY_MS = 300;
    protected final ActionMode mActionMode;
    private final View mView;
    private boolean mHidden;
    private boolean mPendingInvalidateContentRect;
    private final Runnable mRepeatingHideRunnable;

    public WebActionMode(ActionMode actionMode, View view) {
        assert (actionMode != null);
        assert (view != null);
        this.mActionMode = actionMode;
        this.mView = view;
        this.mRepeatingHideRunnable = new Runnable(){

            @Override
            public void run() {
                assert (WebActionMode.this.mHidden);
                long hideDuration = WebActionMode.this.getDefaultHideDuration();
                WebActionMode.this.mView.postDelayed(WebActionMode.this.mRepeatingHideRunnable, hideDuration - 1L);
                WebActionMode.this.hideTemporarily(hideDuration);
            }
        };
    }

    public void finish() {
        this.mActionMode.finish();
    }

    public void invalidate() {
        if (this.mHidden) {
            assert (this.canHide());
            this.mHidden = false;
            this.mView.removeCallbacks(this.mRepeatingHideRunnable);
            this.mPendingInvalidateContentRect = false;
        }
        try {
            this.mActionMode.invalidate();
        }
        catch (NullPointerException e) {
            Log.w(TAG, "Ignoring NPE from ActionMode.invalidate() as workaround for L", e);
        }
    }

    public void invalidateContentRect() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.mHidden) {
                this.mPendingInvalidateContentRect = true;
            } else {
                this.mPendingInvalidateContentRect = false;
                this.mActionMode.invalidateContentRect();
            }
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.mActionMode.onWindowFocusChanged(hasWindowFocus);
        }
    }

    public void hide(boolean hide) {
        if (!this.canHide()) {
            return;
        }
        if (this.mHidden == hide) {
            return;
        }
        this.mHidden = hide;
        if (this.mHidden) {
            this.mRepeatingHideRunnable.run();
        } else {
            this.mHidden = false;
            this.mView.removeCallbacks(this.mRepeatingHideRunnable);
            this.hideTemporarily(300L);
            if (this.mPendingInvalidateContentRect) {
                this.mPendingInvalidateContentRect = false;
                this.invalidateContentRect();
            }
        }
    }

    private void hideTemporarily(long duration) {
        assert (this.canHide());
        if (Build.VERSION.SDK_INT >= 23) {
            this.mActionMode.hide(duration);
        }
    }

    private boolean canHide() {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.mActionMode.getType() == 1;
        }
        return false;
    }

    private long getDefaultHideDuration() {
        if (Build.VERSION.SDK_INT >= 23) {
            return ViewConfiguration.getDefaultActionModeHideDuration();
        }
        return 2000L;
    }
}

