/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.annotation.TargetApi;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Build;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import java.util.List;
import org.chromium.content.R;
import org.chromium.ui.base.DeviceFormFactor;

public class WebActionModeCallback
implements ActionMode.Callback {
    public static final int MENU_ITEM_SHARE = 1;
    public static final int MENU_ITEM_WEB_SEARCH = 2;
    public static final int MENU_ITEM_PROCESS_TEXT = 4;
    protected final ActionHandler mActionHandler;
    private final Context mContext;
    private boolean mEditable;
    private boolean mIsPasswordType;
    private boolean mIsInsertion;
    private boolean mIsDestroyed;

    public WebActionModeCallback(Context context, ActionHandler actionHandler) {
        this.mContext = context;
        this.mActionHandler = actionHandler;
    }

    protected Context getContext() {
        return this.mContext;
    }

    public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
        mode.setTitle(DeviceFormFactor.isTablet(this.getContext()) ? this.getContext().getString(R.string.actionbar_textselection_title) : null);
        mode.setSubtitle(null);
        this.mEditable = this.mActionHandler.isSelectionEditable();
        this.mIsPasswordType = this.mActionHandler.isSelectionPassword();
        this.mIsInsertion = this.mActionHandler.isInsertion();
        this.createActionMenu(mode, menu2);
        return true;
    }

    public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
        boolean isEditableNow = this.mActionHandler.isSelectionEditable();
        boolean isPasswordNow = this.mActionHandler.isSelectionPassword();
        boolean isInsertionNow = this.mActionHandler.isInsertion();
        if (this.mEditable != isEditableNow || this.mIsPasswordType != isPasswordNow || this.mIsInsertion != isInsertionNow) {
            this.mEditable = isEditableNow;
            this.mIsPasswordType = isPasswordNow;
            this.mIsInsertion = isInsertionNow;
            menu2.clear();
            this.createActionMenu(mode, menu2);
            return true;
        }
        return false;
    }

    private void createActionMenu(ActionMode mode, Menu menu2) {
        try {
            mode.getMenuInflater().inflate(R.menu.select_action_menu, menu2);
        }
        catch (Resources.NotFoundException e) {
            new MenuInflater(this.getContext()).inflate(R.menu.select_action_menu, menu2);
        }
        if (this.mIsInsertion) {
            menu2.removeItem(R.id.select_action_menu_select_all);
            menu2.removeItem(R.id.select_action_menu_cut);
            menu2.removeItem(R.id.select_action_menu_copy);
            menu2.removeItem(R.id.select_action_menu_share);
            menu2.removeItem(R.id.select_action_menu_web_search);
            return;
        }
        if (!this.mEditable || !this.canPaste()) {
            menu2.removeItem(R.id.select_action_menu_paste);
        }
        if (!this.mEditable) {
            menu2.removeItem(R.id.select_action_menu_cut);
        }
        if (this.mEditable || !this.mActionHandler.isSelectActionModeAllowed(1)) {
            menu2.removeItem(R.id.select_action_menu_share);
        }
        if (this.mEditable || this.mActionHandler.isIncognito() || !this.mActionHandler.isSelectActionModeAllowed(2)) {
            menu2.removeItem(R.id.select_action_menu_web_search);
        }
        if (this.mIsPasswordType) {
            menu2.removeItem(R.id.select_action_menu_copy);
            menu2.removeItem(R.id.select_action_menu_cut);
            return;
        }
        this.initializeTextProcessingMenu(menu2);
    }

    public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
        if (this.mIsDestroyed) {
            return true;
        }
        int id2 = item.getItemId();
        int groupId = item.getGroupId();
        if (id2 == R.id.select_action_menu_select_all) {
            this.mActionHandler.selectAll();
        } else if (id2 == R.id.select_action_menu_cut) {
            this.mActionHandler.cut();
            mode.finish();
        } else if (id2 == R.id.select_action_menu_copy) {
            this.mActionHandler.copy();
            mode.finish();
        } else if (id2 == R.id.select_action_menu_paste) {
            this.mActionHandler.paste();
            mode.finish();
        } else if (id2 == R.id.select_action_menu_share) {
            this.mActionHandler.share();
            mode.finish();
        } else if (id2 == R.id.select_action_menu_web_search) {
            this.mActionHandler.search();
            mode.finish();
        } else if (groupId == R.id.select_action_menu_text_processing_menus) {
            this.mActionHandler.processText(item.getIntent());
        } else {
            return false;
        }
        return true;
    }

    public void onDestroyActionMode(ActionMode mode) {
        this.mIsDestroyed = true;
        this.mActionHandler.onDestroyActionMode();
    }

    public void onGetContentRect(ActionMode mode, View view, Rect outRect) {
        if (this.mIsDestroyed) {
            return;
        }
        this.mActionHandler.onGetContentRect(outRect);
    }

    private boolean canPaste() {
        ClipboardManager clipMgr = (ClipboardManager)this.getContext().getSystemService("clipboard");
        return clipMgr.hasPrimaryClip();
    }

    private void initializeTextProcessingMenu(Menu menu2) {
        if (Build.VERSION.SDK_INT < 23 || !this.mActionHandler.isSelectActionModeAllowed(4)) {
            return;
        }
        PackageManager packageManager = this.getContext().getPackageManager();
        List supportedActivities = packageManager.queryIntentActivities(this.createProcessTextIntent(), 0);
        for (int i = 0; i < supportedActivities.size(); ++i) {
            ResolveInfo resolveInfo = (ResolveInfo)supportedActivities.get(i);
            CharSequence label = resolveInfo.loadLabel(this.getContext().getPackageManager());
            menu2.add(R.id.select_action_menu_text_processing_menus, 0, i, label).setIntent(this.createProcessTextIntentForResolveInfo(resolveInfo)).setShowAsAction(1);
        }
    }

    @TargetApi(value=23)
    private Intent createProcessTextIntent() {
        return new Intent().setAction("android.intent.action.PROCESS_TEXT").setType("text/plain");
    }

    @TargetApi(value=23)
    private Intent createProcessTextIntentForResolveInfo(ResolveInfo info) {
        boolean isReadOnly = !this.mActionHandler.isSelectionEditable();
        return this.createProcessTextIntent().putExtra("android.intent.extra.PROCESS_TEXT_READONLY", isReadOnly).setClassName(info.activityInfo.packageName, info.activityInfo.name);
    }

    public static interface ActionHandler {
        public void selectAll();

        public void copy();

        public void cut();

        public void paste();

        public void share();

        public void processText(Intent var1);

        public void search();

        public boolean isSelectionEditable();

        public void onDestroyActionMode();

        public void onGetContentRect(Rect var1);

        public boolean isSelectionPassword();

        public boolean isInsertion();

        public boolean isIncognito();

        public boolean isSelectActionModeAllowed(int var1);
    }
}

