/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.accessibility;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.Settings;
import android.text.SpannableString;
import android.text.style.URLSpan;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.RenderCoordinates;
import org.chromium.content.browser.accessibility.KitKatBrowserAccessibilityManager;
import org.chromium.content.browser.accessibility.LollipopBrowserAccessibilityManager;

@JNINamespace(value="content")
public class BrowserAccessibilityManager {
    private static final String TAG = "BrowserAccessibilityManager";
    private static final int ACTION_SET_TEXT = 0x200000;
    private static final String ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE = "ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE";
    private static final int WINDOW_CONTENT_CHANGED_DELAY_MS = 500;
    private final AccessibilityNodeProvider mAccessibilityNodeProvider;
    private ContentViewCore mContentViewCore;
    private final AccessibilityManager mAccessibilityManager;
    private final RenderCoordinates mRenderCoordinates;
    private long mNativeObj;
    private Rect mAccessibilityFocusRect;
    private boolean mIsHovering;
    private int mLastHoverId = -1;
    protected int mCurrentRootId;
    private final int[] mTempLocation = new int[2];
    private final ViewGroup mView;
    private boolean mUserHasTouchExplored;
    private boolean mPendingScrollToMakeNodeVisible;
    private boolean mNotifyFrameInfoInitializedCalled;
    private int mSelectionGranularity;
    private int mSelectionStartIndex;
    private int mSelectionEndIndex;
    protected int mAccessibilityFocusId;
    private Runnable mSendWindowContentChangedRunnable;

    @CalledByNative
    private static BrowserAccessibilityManager create(long nativeBrowserAccessibilityManagerAndroid, ContentViewCore contentViewCore) {
        if (Build.VERSION.SDK_INT >= 21) {
            return new LollipopBrowserAccessibilityManager(nativeBrowserAccessibilityManagerAndroid, contentViewCore);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            return new KitKatBrowserAccessibilityManager(nativeBrowserAccessibilityManagerAndroid, contentViewCore);
        }
        return new BrowserAccessibilityManager(nativeBrowserAccessibilityManagerAndroid, contentViewCore);
    }

    protected BrowserAccessibilityManager(long nativeBrowserAccessibilityManagerAndroid, ContentViewCore contentViewCore) {
        this.mNativeObj = nativeBrowserAccessibilityManagerAndroid;
        this.mContentViewCore = contentViewCore;
        this.mAccessibilityFocusId = -1;
        this.mIsHovering = false;
        this.mCurrentRootId = -1;
        this.mView = this.mContentViewCore.getContainerView();
        this.mRenderCoordinates = this.mContentViewCore.getRenderCoordinates();
        this.mAccessibilityManager = (AccessibilityManager)this.mContentViewCore.getContext().getSystemService("accessibility");
        final BrowserAccessibilityManager delegate = this;
        this.mAccessibilityNodeProvider = new AccessibilityNodeProvider(){

            public AccessibilityNodeInfo createAccessibilityNodeInfo(int virtualViewId) {
                return delegate.createAccessibilityNodeInfo(virtualViewId);
            }

            public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(String text, int virtualViewId) {
                return delegate.findAccessibilityNodeInfosByText(text, virtualViewId);
            }

            public boolean performAction(int virtualViewId, int action, Bundle arguments) {
                return delegate.performAction(virtualViewId, action, arguments);
            }
        };
        this.mContentViewCore.setBrowserAccessibilityManager(this);
    }

    @CalledByNative
    private void onNativeObjectDestroyed(long nativeBrowserAccessibilityManagerAndroid) {
        if (nativeBrowserAccessibilityManagerAndroid != this.mNativeObj) {
            return;
        }
        if (this.mContentViewCore != null && this.mContentViewCore.getBrowserAccessibilityManager() == this) {
            this.mContentViewCore.setBrowserAccessibilityManager(null);
        }
        this.mNativeObj = 0L;
        this.mContentViewCore = null;
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        return this.mAccessibilityNodeProvider;
    }

    protected AccessibilityNodeInfo createAccessibilityNodeInfo(int virtualViewId) {
        if (!this.mAccessibilityManager.isEnabled() || this.mNativeObj == 0L) {
            return null;
        }
        int rootId = this.nativeGetRootId(this.mNativeObj);
        if (virtualViewId == -1) {
            return this.createNodeForHost(rootId);
        }
        if (!this.isFrameInfoInitialized()) {
            return null;
        }
        AccessibilityNodeInfo info = AccessibilityNodeInfo.obtain((View)this.mView);
        info.setPackageName((CharSequence)this.mContentViewCore.getContext().getPackageName());
        info.setSource((View)this.mView, virtualViewId);
        if (virtualViewId == rootId) {
            info.setParent((View)this.mView);
        }
        if (this.nativePopulateAccessibilityNodeInfo(this.mNativeObj, info, virtualViewId)) {
            return info;
        }
        info.recycle();
        return null;
    }

    protected List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(String text, int virtualViewId) {
        return new ArrayList<AccessibilityNodeInfo>();
    }

    protected static boolean isValidMovementGranularity(int granularity) {
        switch (granularity) {
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    protected boolean performAction(int virtualViewId, int action, Bundle arguments) {
        if (!this.mAccessibilityManager.isEnabled() || this.mNativeObj == 0L || !this.nativeIsNodeValid(this.mNativeObj, virtualViewId)) {
            return false;
        }
        switch (action) {
            case 64: {
                if (!this.moveAccessibilityFocusToId(virtualViewId)) {
                    return true;
                }
                if (!this.mIsHovering) {
                    this.nativeScrollToMakeNodeVisible(this.mNativeObj, this.mAccessibilityFocusId);
                } else {
                    this.mPendingScrollToMakeNodeVisible = true;
                }
                return true;
            }
            case 128: {
                this.sendAccessibilityEvent(virtualViewId, 65536);
                if (this.mAccessibilityFocusId == virtualViewId) {
                    this.mAccessibilityFocusId = -1;
                    this.mAccessibilityFocusRect = null;
                }
                return true;
            }
            case 16: {
                this.nativeClick(this.mNativeObj, virtualViewId);
                return true;
            }
            case 1: {
                this.nativeFocus(this.mNativeObj, virtualViewId);
                return true;
            }
            case 2: {
                this.nativeBlur(this.mNativeObj);
                return true;
            }
            case 1024: {
                if (arguments == null) {
                    return false;
                }
                String elementType = arguments.getString("ACTION_ARGUMENT_HTML_ELEMENT_STRING");
                if (elementType == null) {
                    return false;
                }
                elementType = elementType.toUpperCase(Locale.US);
                return this.jumpToElementType(elementType, true);
            }
            case 2048: {
                if (arguments == null) {
                    return false;
                }
                String elementType = arguments.getString("ACTION_ARGUMENT_HTML_ELEMENT_STRING");
                if (elementType == null) {
                    return false;
                }
                elementType = elementType.toUpperCase(Locale.US);
                return this.jumpToElementType(elementType, false);
            }
            case 0x200000: {
                if (!this.nativeIsEditableText(this.mNativeObj, virtualViewId)) {
                    return false;
                }
                if (arguments == null) {
                    return false;
                }
                String newText = arguments.getString(ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE);
                if (newText == null) {
                    return false;
                }
                this.nativeSetTextFieldValue(this.mNativeObj, virtualViewId, newText);
                this.nativeSetSelection(this.mNativeObj, virtualViewId, newText.length(), newText.length());
                return true;
            }
            case 131072: {
                if (!this.nativeIsEditableText(this.mNativeObj, virtualViewId)) {
                    return false;
                }
                int selectionStart = 0;
                int selectionEnd = 0;
                if (arguments != null) {
                    selectionStart = arguments.getInt("ACTION_ARGUMENT_SELECTION_START_INT");
                    selectionEnd = arguments.getInt("ACTION_ARGUMENT_SELECTION_END_INT");
                }
                this.nativeSetSelection(this.mNativeObj, virtualViewId, selectionStart, selectionEnd);
                return true;
            }
            case 256: {
                if (arguments == null) {
                    return false;
                }
                int granularity = arguments.getInt("ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT");
                boolean extend = arguments.getBoolean("ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN");
                if (!BrowserAccessibilityManager.isValidMovementGranularity(granularity)) {
                    return false;
                }
                return this.nextAtGranularity(granularity, extend);
            }
            case 512: {
                if (arguments == null) {
                    return false;
                }
                int granularity = arguments.getInt("ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT");
                boolean extend = arguments.getBoolean("ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN");
                if (!BrowserAccessibilityManager.isValidMovementGranularity(granularity)) {
                    return false;
                }
                return this.previousAtGranularity(granularity, extend);
            }
            case 4096: {
                return this.scrollForward(virtualViewId);
            }
            case 8192: {
                return this.scrollBackward(virtualViewId);
            }
        }
        return false;
    }

    public boolean onHoverEvent(MotionEvent event) {
        if (!this.mAccessibilityManager.isEnabled() || this.mNativeObj == 0L) {
            return false;
        }
        if (event.getAction() == 10) {
            this.mIsHovering = false;
            if (this.mLastHoverId != -1) {
                this.sendAccessibilityEvent(this.mLastHoverId, 256);
                this.mLastHoverId = -1;
            }
            if (this.mPendingScrollToMakeNodeVisible) {
                this.nativeScrollToMakeNodeVisible(this.mNativeObj, this.mAccessibilityFocusId);
            }
            this.mPendingScrollToMakeNodeVisible = false;
            return true;
        }
        this.mIsHovering = true;
        this.mUserHasTouchExplored = true;
        float x = event.getX();
        float y = event.getY();
        int cssX = (int)this.mRenderCoordinates.fromPixToLocalCss(x);
        int cssY = (int)this.mRenderCoordinates.fromPixToLocalCss(y);
        this.nativeHitTest(this.mNativeObj, cssX, cssY);
        return true;
    }

    public void notifyFrameInfoInitialized() {
        if (this.mNotifyFrameInfoInitializedCalled) {
            return;
        }
        this.mNotifyFrameInfoInitializedCalled = true;
        this.sendWindowContentChangedOnView();
        if (this.mAccessibilityFocusId != -1) {
            this.moveAccessibilityFocusToIdAndRefocusIfNeeded(this.mAccessibilityFocusId);
        }
    }

    private boolean jumpToElementType(String elementType, boolean forwards) {
        int id2 = this.nativeFindElementType(this.mNativeObj, this.mAccessibilityFocusId, elementType, forwards);
        if (id2 == 0) {
            return false;
        }
        this.moveAccessibilityFocusToId(id2);
        this.nativeScrollToMakeNodeVisible(this.mNativeObj, this.mAccessibilityFocusId);
        return true;
    }

    private void setGranularityAndUpdateSelection(int granularity) {
        if (this.mSelectionGranularity == 0) {
            this.mSelectionStartIndex = -1;
            this.mSelectionEndIndex = -1;
        }
        this.mSelectionGranularity = granularity;
        if (this.nativeIsEditableText(this.mNativeObj, this.mAccessibilityFocusId)) {
            this.mSelectionStartIndex = this.nativeGetEditableTextSelectionStart(this.mNativeObj, this.mAccessibilityFocusId);
            this.mSelectionEndIndex = this.nativeGetEditableTextSelectionEnd(this.mNativeObj, this.mAccessibilityFocusId);
        }
    }

    private boolean nextAtGranularity(int granularity, boolean extendSelection) {
        this.setGranularityAndUpdateSelection(granularity);
        return this.nativeNextAtGranularity(this.mNativeObj, this.mSelectionGranularity, extendSelection, this.mAccessibilityFocusId, this.mSelectionEndIndex);
    }

    private boolean previousAtGranularity(int granularity, boolean extendSelection) {
        this.setGranularityAndUpdateSelection(granularity);
        return this.nativePreviousAtGranularity(this.mNativeObj, this.mSelectionGranularity, extendSelection, this.mAccessibilityFocusId, this.mSelectionEndIndex);
    }

    @CalledByNative
    private void finishGranularityMove(String text, boolean extendSelection, int itemStartIndex, int itemEndIndex, boolean forwards) {
        if (this.mNativeObj == 0L) {
            return;
        }
        AccessibilityEvent selectionEvent = this.buildAccessibilityEvent(this.mAccessibilityFocusId, 8192);
        if (selectionEvent == null) {
            return;
        }
        AccessibilityEvent traverseEvent = this.buildAccessibilityEvent(this.mAccessibilityFocusId, 131072);
        if (traverseEvent == null) {
            selectionEvent.recycle();
            return;
        }
        this.mSelectionEndIndex = forwards ? itemEndIndex : itemStartIndex;
        if (!extendSelection) {
            this.mSelectionStartIndex = this.mSelectionEndIndex;
        }
        if (this.nativeIsEditableText(this.mNativeObj, this.mAccessibilityFocusId)) {
            this.nativeSetSelection(this.mNativeObj, this.mAccessibilityFocusId, this.mSelectionStartIndex, this.mSelectionEndIndex);
        }
        selectionEvent.setFromIndex(this.mSelectionStartIndex);
        selectionEvent.setToIndex(this.mSelectionStartIndex);
        selectionEvent.setItemCount(text.length());
        traverseEvent.setFromIndex(itemStartIndex);
        traverseEvent.setToIndex(itemEndIndex);
        traverseEvent.setItemCount(text.length());
        traverseEvent.setMovementGranularity(this.mSelectionGranularity);
        traverseEvent.setContentDescription((CharSequence)text);
        if (forwards) {
            traverseEvent.setAction(256);
        } else {
            traverseEvent.setAction(512);
        }
        this.mView.requestSendAccessibilityEvent((View)this.mView, selectionEvent);
        this.mView.requestSendAccessibilityEvent((View)this.mView, traverseEvent);
    }

    private boolean scrollForward(int virtualViewId) {
        if (this.nativeIsSlider(this.mNativeObj, virtualViewId)) {
            return this.nativeAdjustSlider(this.mNativeObj, virtualViewId, true);
        }
        return this.nativeScroll(this.mNativeObj, virtualViewId, 0);
    }

    private boolean scrollBackward(int virtualViewId) {
        if (this.nativeIsSlider(this.mNativeObj, virtualViewId)) {
            return this.nativeAdjustSlider(this.mNativeObj, virtualViewId, false);
        }
        return this.nativeScroll(this.mNativeObj, virtualViewId, 1);
    }

    private boolean moveAccessibilityFocusToId(int newAccessibilityFocusId) {
        if (newAccessibilityFocusId == this.mAccessibilityFocusId) {
            return false;
        }
        this.mAccessibilityFocusId = newAccessibilityFocusId;
        this.mAccessibilityFocusRect = null;
        this.mSelectionGranularity = 0;
        this.mSelectionStartIndex = 0;
        this.mSelectionEndIndex = 0;
        if (this.mAccessibilityFocusId == this.mCurrentRootId) {
            this.nativeSetAccessibilityFocus(this.mNativeObj, -1);
        } else {
            this.nativeSetAccessibilityFocus(this.mNativeObj, this.mAccessibilityFocusId);
        }
        this.sendAccessibilityEvent(this.mAccessibilityFocusId, 32768);
        return true;
    }

    private void moveAccessibilityFocusToIdAndRefocusIfNeeded(int newAccessibilityFocusId) {
        if (newAccessibilityFocusId == this.mAccessibilityFocusId) {
            this.sendAccessibilityEvent(newAccessibilityFocusId, 65536);
            this.mAccessibilityFocusId = -1;
        }
        this.moveAccessibilityFocusToId(newAccessibilityFocusId);
    }

    @CalledByNative
    private void sendDelayedWindowContentChangedEvent() {
        if (this.mNativeObj == 0L) {
            return;
        }
        if (this.mSendWindowContentChangedRunnable != null) {
            return;
        }
        this.mSendWindowContentChangedRunnable = new Runnable(){

            @Override
            public void run() {
                BrowserAccessibilityManager.this.sendWindowContentChangedOnView();
            }
        };
        this.mView.postDelayed(this.mSendWindowContentChangedRunnable, 500L);
    }

    private void sendWindowContentChangedOnView() {
        if (this.mNativeObj == 0L || this.mContentViewCore == null || this.mView == null) {
            return;
        }
        if (this.mSendWindowContentChangedRunnable != null) {
            this.mView.removeCallbacks(this.mSendWindowContentChangedRunnable);
            this.mSendWindowContentChangedRunnable = null;
        }
        this.mView.sendAccessibilityEvent(2048);
    }

    private void sendWindowContentChangedOnVirtualView(int virtualViewId) {
        this.sendAccessibilityEvent(virtualViewId, 2048);
    }

    private void sendAccessibilityEvent(int virtualViewId, int eventType) {
        if (virtualViewId == -1) {
            this.mView.sendAccessibilityEvent(eventType);
            return;
        }
        AccessibilityEvent event = this.buildAccessibilityEvent(virtualViewId, eventType);
        if (event != null) {
            this.mView.requestSendAccessibilityEvent((View)this.mView, event);
        }
    }

    private AccessibilityEvent buildAccessibilityEvent(int virtualViewId, int eventType) {
        if (!this.mAccessibilityManager.isEnabled() || this.mNativeObj == 0L || !this.isFrameInfoInitialized()) {
            return null;
        }
        this.mView.postInvalidate();
        AccessibilityEvent event = AccessibilityEvent.obtain((int)eventType);
        event.setPackageName((CharSequence)this.mContentViewCore.getContext().getPackageName());
        event.setSource((View)this.mView, virtualViewId);
        if (!this.nativePopulateAccessibilityEvent(this.mNativeObj, event, virtualViewId, eventType)) {
            event.recycle();
            return null;
        }
        return event;
    }

    private Bundle getOrCreateBundleForAccessibilityEvent(AccessibilityEvent event) {
        Bundle bundle = (Bundle)event.getParcelableData();
        if (bundle == null) {
            bundle = new Bundle();
            event.setParcelableData((Parcelable)bundle);
        }
        return bundle;
    }

    private AccessibilityNodeInfo createNodeForHost(int rootId) {
        AccessibilityNodeInfo result = AccessibilityNodeInfo.obtain((View)this.mView);
        AccessibilityNodeInfo source = AccessibilityNodeInfo.obtain((View)this.mView);
        this.mView.onInitializeAccessibilityNodeInfo(source);
        Rect rect = new Rect();
        source.getBoundsInParent(rect);
        result.setBoundsInParent(rect);
        source.getBoundsInScreen(rect);
        result.setBoundsInScreen(rect);
        ViewParent parent = this.mView.getParentForAccessibility();
        if (parent instanceof View) {
            result.setParent((View)parent);
        }
        result.setVisibleToUser(source.isVisibleToUser());
        result.setEnabled(source.isEnabled());
        result.setPackageName(source.getPackageName());
        result.setClassName(source.getClassName());
        if (this.isFrameInfoInitialized()) {
            result.addChild((View)this.mView, rootId);
        }
        return result;
    }

    private boolean isFrameInfoInitialized() {
        return (double)this.mRenderCoordinates.getContentWidthCss() != 0.0 || (double)this.mRenderCoordinates.getContentHeightCss() != 0.0;
    }

    @CalledByNative
    private void handlePageLoaded(int id2) {
        if (this.mNativeObj == 0L) {
            return;
        }
        if (this.mUserHasTouchExplored) {
            return;
        }
        if (this.mContentViewCore.shouldSetAccessibilityFocusOnPageLoad()) {
            this.moveAccessibilityFocusToIdAndRefocusIfNeeded(id2);
        }
    }

    @CalledByNative
    private void handleFocusChanged(int id2) {
        if (this.mNativeObj == 0L) {
            return;
        }
        this.sendAccessibilityEvent(id2, 8);
        this.moveAccessibilityFocusToId(id2);
    }

    @CalledByNative
    private void handleCheckStateChanged(int id2) {
        if (this.mNativeObj == 0L) {
            return;
        }
        this.sendAccessibilityEvent(id2, 1);
    }

    @CalledByNative
    private void handleClicked(int id2) {
        if (this.mNativeObj == 0L) {
            return;
        }
        this.sendAccessibilityEvent(id2, 1);
    }

    @CalledByNative
    private void handleTextSelectionChanged(int id2) {
        if (this.mNativeObj == 0L) {
            return;
        }
        this.sendAccessibilityEvent(id2, 8192);
    }

    @CalledByNative
    private void handleEditableTextChanged(int id2) {
        if (this.mNativeObj == 0L) {
            return;
        }
        this.sendAccessibilityEvent(id2, 16);
    }

    @CalledByNative
    private void handleSliderChanged(int id2) {
        if (this.mNativeObj == 0L) {
            return;
        }
        this.sendAccessibilityEvent(id2, 4096);
    }

    @CalledByNative
    private void handleContentChanged(int id2) {
        if (this.mNativeObj == 0L) {
            return;
        }
        int rootId = this.nativeGetRootId(this.mNativeObj);
        if (rootId != this.mCurrentRootId) {
            this.mCurrentRootId = rootId;
            this.sendWindowContentChangedOnView();
        } else {
            this.sendWindowContentChangedOnVirtualView(id2);
        }
    }

    @CalledByNative
    private void handleNavigate() {
        if (this.mNativeObj == 0L) {
            return;
        }
        this.mAccessibilityFocusId = -1;
        this.mAccessibilityFocusRect = null;
        this.mUserHasTouchExplored = false;
        this.sendWindowContentChangedOnView();
    }

    @CalledByNative
    private void handleScrollPositionChanged(int id2) {
        if (this.mNativeObj == 0L) {
            return;
        }
        this.sendAccessibilityEvent(id2, 4096);
    }

    @CalledByNative
    private void handleScrolledToAnchor(int id2) {
        if (this.mNativeObj == 0L) {
            return;
        }
        this.moveAccessibilityFocusToId(id2);
    }

    @CalledByNative
    private void handleHover(int id2) {
        if (this.mNativeObj == 0L) {
            return;
        }
        if (this.mLastHoverId == id2) {
            return;
        }
        if (!this.mIsHovering) {
            return;
        }
        this.sendAccessibilityEvent(id2, 128);
        if (this.mLastHoverId != -1) {
            this.sendAccessibilityEvent(this.mLastHoverId, 256);
        }
        this.mLastHoverId = id2;
    }

    @CalledByNative
    private void announceLiveRegionText(String text) {
        this.mView.announceForAccessibility((CharSequence)text);
    }

    @CalledByNative
    private void setAccessibilityNodeInfoParent(AccessibilityNodeInfo node, int parentId) {
        node.setParent((View)this.mView, parentId);
    }

    @CalledByNative
    private void addAccessibilityNodeInfoChild(AccessibilityNodeInfo node, int childId) {
        node.addChild((View)this.mView, childId);
    }

    @CalledByNative
    private void setAccessibilityNodeInfoBooleanAttributes(AccessibilityNodeInfo node, int virtualViewId, boolean checkable, boolean checked, boolean clickable, boolean enabled, boolean focusable, boolean focused, boolean password, boolean scrollable, boolean selected, boolean visibleToUser) {
        node.setCheckable(checkable);
        node.setChecked(checked);
        node.setClickable(clickable);
        node.setEnabled(enabled);
        node.setFocusable(focusable);
        node.setFocused(focused);
        node.setPassword(password);
        node.setScrollable(scrollable);
        node.setSelected(selected);
        node.setVisibleToUser(visibleToUser);
        node.setMovementGranularities(7);
        if (this.mAccessibilityFocusId == virtualViewId) {
            node.setAccessibilityFocused(true);
        } else {
            node.setAccessibilityFocused(false);
        }
    }

    @CalledByNative
    protected void addAccessibilityNodeInfoActions(AccessibilityNodeInfo node, int virtualViewId, boolean canScrollForward, boolean canScrollBackward, boolean canScrollUp, boolean canScrollDown, boolean canScrollLeft, boolean canScrollRight, boolean clickable, boolean editableText, boolean enabled, boolean focusable, boolean focused) {
        node.addAction(1024);
        node.addAction(2048);
        node.addAction(256);
        node.addAction(512);
        if (editableText && enabled) {
            node.addAction(0x200000);
            node.addAction(131072);
        }
        if (canScrollForward) {
            node.addAction(4096);
        }
        if (canScrollBackward) {
            node.addAction(8192);
        }
        if (focusable) {
            if (focused) {
                node.addAction(2);
            } else {
                node.addAction(1);
            }
        }
        if (this.mAccessibilityFocusId == virtualViewId) {
            node.addAction(128);
        } else {
            node.addAction(64);
        }
        if (clickable) {
            node.addAction(16);
        }
    }

    @CalledByNative
    private void setAccessibilityNodeInfoClassName(AccessibilityNodeInfo node, String className) {
        node.setClassName((CharSequence)className);
    }

    @SuppressLint(value={"NewApi"})
    @CalledByNative
    private void setAccessibilityNodeInfoText(AccessibilityNodeInfo node, String text, boolean annotateAsLink, boolean isEditableText) {
        String charSequence = text;
        if (annotateAsLink) {
            SpannableString spannable = new SpannableString((CharSequence)text);
            spannable.setSpan((Object)new URLSpan(""), 0, spannable.length(), 0);
            charSequence = spannable;
        }
        if (isEditableText) {
            node.setText((CharSequence)charSequence);
        } else {
            node.setContentDescription((CharSequence)charSequence);
        }
    }

    @CalledByNative
    private void setAccessibilityNodeInfoLocation(AccessibilityNodeInfo node, int virtualViewId, int absoluteLeft, int absoluteTop, int parentRelativeLeft, int parentRelativeTop, int width, int height, boolean isRootNode) {
        Rect boundsInParent = new Rect(parentRelativeLeft, parentRelativeTop, parentRelativeLeft + width, parentRelativeTop + height);
        if (isRootNode) {
            boundsInParent.offset(0, (int)this.mRenderCoordinates.getContentOffsetYPix());
        }
        node.setBoundsInParent(boundsInParent);
        Rect rect = new Rect(absoluteLeft, absoluteTop, absoluteLeft + width, absoluteTop + height);
        rect.offset(-((int)this.mRenderCoordinates.getScrollX()), -((int)this.mRenderCoordinates.getScrollY()));
        rect.left = (int)this.mRenderCoordinates.fromLocalCssToPix(rect.left);
        rect.top = (int)this.mRenderCoordinates.fromLocalCssToPix(rect.top);
        rect.bottom = (int)this.mRenderCoordinates.fromLocalCssToPix(rect.bottom);
        rect.right = (int)this.mRenderCoordinates.fromLocalCssToPix(rect.right);
        rect.offset(0, (int)this.mRenderCoordinates.getContentOffsetYPix());
        int[] viewLocation = new int[2];
        this.mView.getLocationOnScreen(viewLocation);
        rect.offset(viewLocation[0], viewLocation[1]);
        int viewportRectTop = viewLocation[1] + (int)this.mRenderCoordinates.getContentOffsetYPix();
        int viewportRectBottom = viewportRectTop + this.mContentViewCore.getViewportHeightPix();
        if (rect.top < viewportRectTop) {
            rect.top = viewportRectTop;
        }
        if (rect.bottom > viewportRectBottom) {
            rect.bottom = viewportRectBottom;
        }
        node.setBoundsInScreen(rect);
        if (virtualViewId == this.mAccessibilityFocusId && virtualViewId != this.mCurrentRootId) {
            if (this.mAccessibilityFocusRect == null) {
                this.mAccessibilityFocusRect = rect;
            } else if (!this.mAccessibilityFocusRect.equals((Object)rect)) {
                this.mAccessibilityFocusRect = rect;
                this.moveAccessibilityFocusToIdAndRefocusIfNeeded(virtualViewId);
            }
        }
    }

    @CalledByNative
    protected void setAccessibilityNodeInfoKitKatAttributes(AccessibilityNodeInfo node, boolean isRoot, boolean isEditableText, String roleDescription) {
    }

    @CalledByNative
    protected void setAccessibilityNodeInfoLollipopAttributes(AccessibilityNodeInfo node, boolean canOpenPopup, boolean contentInvalid, boolean dismissable, boolean multiLine, int inputType, int liveRegion) {
    }

    @CalledByNative
    protected void setAccessibilityNodeInfoCollectionInfo(AccessibilityNodeInfo node, int rowCount, int columnCount, boolean hierarchical) {
    }

    @CalledByNative
    protected void setAccessibilityNodeInfoCollectionItemInfo(AccessibilityNodeInfo node, int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading) {
    }

    @CalledByNative
    protected void setAccessibilityNodeInfoRangeInfo(AccessibilityNodeInfo node, int rangeType, float min, float max, float current) {
    }

    @CalledByNative
    protected void setAccessibilityNodeInfoViewIdResourceName(AccessibilityNodeInfo node, String viewIdResourceName) {
    }

    @CalledByNative
    private void setAccessibilityEventBooleanAttributes(AccessibilityEvent event, boolean checked, boolean enabled, boolean password, boolean scrollable) {
        event.setChecked(checked);
        event.setEnabled(enabled);
        event.setPassword(password);
        event.setScrollable(scrollable);
    }

    @CalledByNative
    private void setAccessibilityEventClassName(AccessibilityEvent event, String className) {
        event.setClassName((CharSequence)className);
    }

    @CalledByNative
    private void setAccessibilityEventListAttributes(AccessibilityEvent event, int currentItemIndex, int itemCount) {
        event.setCurrentItemIndex(currentItemIndex);
        event.setItemCount(itemCount);
    }

    @CalledByNative
    private void setAccessibilityEventScrollAttributes(AccessibilityEvent event, int scrollX, int scrollY, int maxScrollX, int maxScrollY) {
        event.setScrollX(scrollX);
        event.setScrollY(scrollY);
        event.setMaxScrollX(maxScrollX);
        event.setMaxScrollY(maxScrollY);
    }

    @CalledByNative
    private void setAccessibilityEventTextChangedAttrs(AccessibilityEvent event, int fromIndex, int addedCount, int removedCount, String beforeText, String text) {
        event.setFromIndex(fromIndex);
        event.setAddedCount(addedCount);
        event.setRemovedCount(removedCount);
        event.setBeforeText((CharSequence)beforeText);
        event.getText().add(text);
    }

    @CalledByNative
    private void setAccessibilityEventSelectionAttrs(AccessibilityEvent event, int fromIndex, int toIndex, int itemCount, String text) {
        event.setFromIndex(fromIndex);
        event.setToIndex(toIndex);
        event.setItemCount(itemCount);
        event.getText().add(text);
    }

    @CalledByNative
    protected void setAccessibilityEventLollipopAttributes(AccessibilityEvent event, boolean canOpenPopup, boolean contentInvalid, boolean dismissable, boolean multiLine, int inputType, int liveRegion) {
        Bundle bundle = this.getOrCreateBundleForAccessibilityEvent(event);
        bundle.putBoolean("AccessibilityNodeInfo.canOpenPopup", canOpenPopup);
        bundle.putBoolean("AccessibilityNodeInfo.contentInvalid", contentInvalid);
        bundle.putBoolean("AccessibilityNodeInfo.dismissable", dismissable);
        bundle.putBoolean("AccessibilityNodeInfo.multiLine", multiLine);
        bundle.putInt("AccessibilityNodeInfo.inputType", inputType);
        bundle.putInt("AccessibilityNodeInfo.liveRegion", liveRegion);
    }

    @CalledByNative
    protected void setAccessibilityEventCollectionInfo(AccessibilityEvent event, int rowCount, int columnCount, boolean hierarchical) {
        Bundle bundle = this.getOrCreateBundleForAccessibilityEvent(event);
        bundle.putInt("AccessibilityNodeInfo.CollectionInfo.rowCount", rowCount);
        bundle.putInt("AccessibilityNodeInfo.CollectionInfo.columnCount", columnCount);
        bundle.putBoolean("AccessibilityNodeInfo.CollectionInfo.hierarchical", hierarchical);
    }

    @CalledByNative
    protected void setAccessibilityEventHeadingFlag(AccessibilityEvent event, boolean heading) {
        Bundle bundle = this.getOrCreateBundleForAccessibilityEvent(event);
        bundle.putBoolean("AccessibilityNodeInfo.CollectionItemInfo.heading", heading);
    }

    @CalledByNative
    protected void setAccessibilityEventCollectionItemInfo(AccessibilityEvent event, int rowIndex, int rowSpan, int columnIndex, int columnSpan) {
        Bundle bundle = this.getOrCreateBundleForAccessibilityEvent(event);
        bundle.putInt("AccessibilityNodeInfo.CollectionItemInfo.rowIndex", rowIndex);
        bundle.putInt("AccessibilityNodeInfo.CollectionItemInfo.rowSpan", rowSpan);
        bundle.putInt("AccessibilityNodeInfo.CollectionItemInfo.columnIndex", columnIndex);
        bundle.putInt("AccessibilityNodeInfo.CollectionItemInfo.columnSpan", columnSpan);
    }

    @CalledByNative
    protected void setAccessibilityEventRangeInfo(AccessibilityEvent event, int rangeType, float min, float max, float current) {
        Bundle bundle = this.getOrCreateBundleForAccessibilityEvent(event);
        bundle.putInt("AccessibilityNodeInfo.RangeInfo.type", rangeType);
        bundle.putFloat("AccessibilityNodeInfo.RangeInfo.min", min);
        bundle.putFloat("AccessibilityNodeInfo.RangeInfo.max", max);
        bundle.putFloat("AccessibilityNodeInfo.RangeInfo.current", current);
    }

    @CalledByNative
    boolean shouldExposePasswordText() {
        return Settings.Secure.getInt((ContentResolver)this.mContentViewCore.getContext().getContentResolver(), (String)"speak_password", (int)0) == 1;
    }

    private native int nativeGetRootId(long var1);

    private native boolean nativeIsNodeValid(long var1, int var3);

    private native boolean nativeIsEditableText(long var1, int var3);

    private native int nativeGetEditableTextSelectionStart(long var1, int var3);

    private native int nativeGetEditableTextSelectionEnd(long var1, int var3);

    private native void nativeHitTest(long var1, int var3, int var4);

    private native boolean nativePopulateAccessibilityNodeInfo(long var1, AccessibilityNodeInfo var3, int var4);

    private native boolean nativePopulateAccessibilityEvent(long var1, AccessibilityEvent var3, int var4, int var5);

    private native void nativeClick(long var1, int var3);

    private native void nativeFocus(long var1, int var3);

    private native void nativeBlur(long var1);

    private native void nativeScrollToMakeNodeVisible(long var1, int var3);

    private native int nativeFindElementType(long var1, int var3, String var4, boolean var5);

    private native void nativeSetTextFieldValue(long var1, int var3, String var4);

    private native void nativeSetSelection(long var1, int var3, int var4, int var5);

    private native boolean nativeNextAtGranularity(long var1, int var3, boolean var4, int var5, int var6);

    private native boolean nativePreviousAtGranularity(long var1, int var3, boolean var4, int var5, int var6);

    private native boolean nativeAdjustSlider(long var1, int var3, boolean var4);

    private native void nativeSetAccessibilityFocus(long var1, int var3);

    private native boolean nativeIsSlider(long var1, int var3);

    private native boolean nativeScroll(long var1, int var3, int var4);

    protected native String nativeGetSupportedHtmlElementTypes(long var1);
}

