/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.accessibility.captioning;

import android.graphics.Color;
import android.graphics.Typeface;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import org.chromium.base.VisibleForTesting;
import org.chromium.content.browser.accessibility.captioning.CaptioningStyle;
import org.chromium.content.browser.accessibility.captioning.SystemCaptioningBridge;
import org.chromium.content.browser.accessibility.captioning.TextTrackSettings;

public class CaptioningChangeDelegate {
    private static final String FONT_STYLE_ITALIC = "italic";
    @VisibleForTesting
    public static final String DEFAULT_CAPTIONING_PREF_VALUE = "";
    private boolean mTextTracksEnabled;
    private String mTextTrackBackgroundColor;
    private String mTextTrackFontFamily;
    private String mTextTrackFontStyle;
    private String mTextTrackFontVariant;
    private String mTextTrackTextColor;
    private String mTextTrackTextShadow;
    private String mTextTrackTextSize;
    private final Map<SystemCaptioningBridge.SystemCaptioningBridgeListener, Boolean> mListeners = new WeakHashMap<SystemCaptioningBridge.SystemCaptioningBridgeListener, Boolean>();

    public void onEnabledChanged(boolean enabled) {
        this.mTextTracksEnabled = enabled;
        this.notifySettingsChanged();
    }

    public void onFontScaleChanged(float fontScale) {
        this.mTextTrackTextSize = CaptioningChangeDelegate.androidFontScaleToPercentage(fontScale);
        this.notifySettingsChanged();
    }

    public void onLocaleChanged(Locale locale) {
    }

    public void onUserStyleChanged(CaptioningStyle userStyle) {
        this.mTextTrackTextColor = CaptioningChangeDelegate.androidColorToCssColor(userStyle.getForegroundColor());
        this.mTextTrackBackgroundColor = CaptioningChangeDelegate.androidColorToCssColor(userStyle.getBackgroundColor());
        ClosedCaptionEdgeAttribute edge = ClosedCaptionEdgeAttribute.fromSystemEdgeAttribute(userStyle.getEdgeType(), CaptioningChangeDelegate.androidColorToCssColor(userStyle.getEdgeColor()));
        this.mTextTrackTextShadow = edge.getTextShadow();
        Typeface typeFace = userStyle.getTypeface();
        ClosedCaptionFont font = ClosedCaptionFont.fromSystemFont(typeFace);
        this.mTextTrackFontFamily = font.getFontFamily();
        this.mTextTrackFontStyle = typeFace != null && typeFace.isItalic() ? FONT_STYLE_ITALIC : DEFAULT_CAPTIONING_PREF_VALUE;
        this.mTextTrackFontVariant = DEFAULT_CAPTIONING_PREF_VALUE;
        this.notifySettingsChanged();
    }

    public static String androidColorToCssColor(Integer color2) {
        if (color2 == null) {
            return DEFAULT_CAPTIONING_PREF_VALUE;
        }
        String alpha = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.US)).format((double)Color.alpha((int)color2) / 255.0);
        return String.format("rgba(%s, %s, %s, %s)", Color.red((int)color2), Color.green((int)color2), Color.blue((int)color2), alpha);
    }

    public static String androidFontScaleToPercentage(float fontScale) {
        return new DecimalFormat("#%", new DecimalFormatSymbols(Locale.US)).format(fontScale);
    }

    private void notifySettingsChanged() {
        for (SystemCaptioningBridge.SystemCaptioningBridgeListener listener : this.mListeners.keySet()) {
            this.notifyListener(listener);
        }
    }

    public void notifyListener(SystemCaptioningBridge.SystemCaptioningBridgeListener listener) {
        if (this.mTextTracksEnabled) {
            TextTrackSettings settings = new TextTrackSettings(this.mTextTracksEnabled, this.mTextTrackBackgroundColor, this.mTextTrackFontFamily, this.mTextTrackFontStyle, this.mTextTrackFontVariant, this.mTextTrackTextColor, this.mTextTrackTextShadow, this.mTextTrackTextSize);
            listener.onSystemCaptioningChanged(settings);
        } else {
            listener.onSystemCaptioningChanged(new TextTrackSettings());
        }
    }

    public void addListener(SystemCaptioningBridge.SystemCaptioningBridgeListener listener) {
        this.mListeners.put(listener, null);
    }

    public void removeListener(SystemCaptioningBridge.SystemCaptioningBridgeListener listener) {
        this.mListeners.remove(listener);
    }

    public boolean hasActiveListener() {
        return !this.mListeners.isEmpty();
    }

    public static enum ClosedCaptionFont {
        DEFAULT("", EnumSet.noneOf(Flags.class)),
        SANS_SERIF("sans-serif", EnumSet.of(Flags.SANS_SERIF)),
        SANS_SERIF_CONDENSED("sans-serif-condensed", EnumSet.of(Flags.SANS_SERIF)),
        SANS_SERIF_MONOSPACE("sans-serif-monospace", EnumSet.of(Flags.SANS_SERIF, Flags.MONOSPACE)),
        SERIF("serif", EnumSet.of(Flags.SERIF)),
        SERIF_MONOSPACE("serif-monospace", EnumSet.of(Flags.SERIF, Flags.MONOSPACE)),
        CASUAL("casual", EnumSet.noneOf(Flags.class)),
        CURSIVE("cursive", EnumSet.noneOf(Flags.class)),
        SANS_SERIF_SMALLCAPS("sans-serif-smallcaps", EnumSet.of(Flags.SANS_SERIF)),
        MONOSPACE("monospace", EnumSet.of(Flags.MONOSPACE));

        private final String mFontFamily;
        @VisibleForTesting
        final EnumSet<Flags> mFlags;

        private ClosedCaptionFont(String fontFamily, EnumSet<Flags> flags) {
            this.mFontFamily = fontFamily;
            this.mFlags = flags;
        }

        public static ClosedCaptionFont fromSystemFont(Typeface typeFace) {
            if (typeFace == null) {
                return DEFAULT;
            }
            for (ClosedCaptionFont font : ClosedCaptionFont.values()) {
                if (!ClosedCaptionFont.belongsToFontFamily(typeFace, font)) continue;
                return font;
            }
            return DEFAULT;
        }

        private static boolean belongsToFontFamily(Typeface typeFace, ClosedCaptionFont font) {
            return Typeface.create((String)font.getFontFamily(), (int)typeFace.getStyle()).equals((Object)typeFace);
        }

        public String getFontFamily() {
            return this.mFontFamily;
        }

        @VisibleForTesting
        static enum Flags {
            SANS_SERIF,
            SERIF,
            MONOSPACE;

        }
    }

    public static enum ClosedCaptionEdgeAttribute {
        NONE(""),
        OUTLINE("%2$s %2$s 0 %1$s, -%2$s -%2$s 0 %1$s, %2$s -%2$s 0 %1$s, -%2$s %2$s 0 %1$s"),
        DROP_SHADOW("%1$s %2$s %2$s 0.1em"),
        RAISED("-%2$s -%2$s 0 %1$s"),
        DEPRESSED("%2$s %2$s 0 %1$s");

        private static String sDefaultEdgeColor;
        private static String sShadowOffset;
        private static String sEdgeColor;
        private final String mTextShadow;

        private ClosedCaptionEdgeAttribute(String textShadow) {
            this.mTextShadow = textShadow;
        }

        public static ClosedCaptionEdgeAttribute fromSystemEdgeAttribute(Integer type2, String color2) {
            if (type2 == null) {
                return NONE;
            }
            sEdgeColor = color2 == null || color2.isEmpty() ? sDefaultEdgeColor : color2;
            switch (type2) {
                case 1: {
                    return OUTLINE;
                }
                case 2: {
                    return DROP_SHADOW;
                }
                case 3: {
                    return RAISED;
                }
                case 4: {
                    return DEPRESSED;
                }
            }
            return NONE;
        }

        public static void setShadowOffset(String shadowOffset) {
            sShadowOffset = shadowOffset;
        }

        public static void setDefaultEdgeColor(String color2) {
            sDefaultEdgeColor = color2;
        }

        public String getTextShadow() {
            return String.format(this.mTextShadow, sEdgeColor, sShadowOffset);
        }

        static {
            sDefaultEdgeColor = "silver";
            sShadowOffset = "0.05em";
        }
    }
}

