/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.View;
import org.chromium.content.browser.FloatingWebActionModeCallback;
import org.chromium.content.browser.WebActionModeCallback;
import org.chromium.content.browser.input.LegacyPastePopupMenu;
import org.chromium.content.browser.input.PastePopupMenu;

@TargetApi(value=23)
public class FloatingPastePopupMenu
implements PastePopupMenu {
    private static final int CONTENT_RECT_OFFSET_DIP = 15;
    private static final int SLOP_LENGTH_DIP = 10;
    private final View mParent;
    private final PastePopupMenu.PastePopupMenuDelegate mDelegate;
    private final Context mContext;
    private final int mContentRectOffset;
    private final int mSlopLengthSquared;
    private ActionMode mActionMode;
    private WebActionModeCallback.ActionHandler mActionHandler;
    private int mRawPositionX;
    private int mRawPositionY;
    private LegacyPastePopupMenu mFallbackPastePopupMenu;

    public FloatingPastePopupMenu(Context context, View parent, PastePopupMenu.PastePopupMenuDelegate delegate) {
        assert (Build.VERSION.SDK_INT >= 23);
        this.mParent = parent;
        this.mDelegate = delegate;
        this.mContext = context;
        this.mContentRectOffset = (int)TypedValue.applyDimension((int)1, (float)15.0f, (DisplayMetrics)this.mContext.getResources().getDisplayMetrics());
        int slopLength = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.mContext.getResources().getDisplayMetrics());
        this.mSlopLengthSquared = slopLength * slopLength;
    }

    @Override
    public void show(int x, int y) {
        int dy;
        int dx;
        if (this.mFallbackPastePopupMenu != null) {
            this.mFallbackPastePopupMenu.show(x, y);
            return;
        }
        if (this.isShowing() && (dx = this.mRawPositionX - x) * dx + (dy = this.mRawPositionY - y) * dy < this.mSlopLengthSquared) {
            return;
        }
        this.mRawPositionX = x;
        this.mRawPositionY = y;
        if (this.mActionMode != null) {
            this.mActionMode.invalidateContentRect();
            return;
        }
        this.ensureActionModeOrFallback();
    }

    @Override
    public void hide() {
        if (this.mFallbackPastePopupMenu != null) {
            this.mFallbackPastePopupMenu.hide();
            return;
        }
        if (this.mActionMode != null) {
            this.mActionMode.finish();
            this.mActionMode = null;
        }
    }

    @Override
    public boolean isShowing() {
        if (this.mFallbackPastePopupMenu != null) {
            return this.mFallbackPastePopupMenu.isShowing();
        }
        return this.mActionMode != null;
    }

    private void ensureActionModeOrFallback() {
        if (this.mActionMode != null) {
            return;
        }
        if (this.mFallbackPastePopupMenu != null) {
            return;
        }
        FloatingWebActionModeCallback callback2 = new FloatingWebActionModeCallback(new WebActionModeCallback(this.mParent.getContext(), this.getActionHandler()));
        ActionMode actionMode = this.mParent.startActionMode((ActionMode.Callback)callback2, 1);
        if (actionMode != null) {
            assert (actionMode.getType() == 1);
            this.mActionMode = actionMode;
        } else {
            this.mFallbackPastePopupMenu = new LegacyPastePopupMenu(this.mContext, this.mParent, this.mDelegate);
            this.mFallbackPastePopupMenu.show(this.mRawPositionX, this.mRawPositionY);
        }
    }

    private WebActionModeCallback.ActionHandler getActionHandler() {
        if (this.mActionHandler != null) {
            return this.mActionHandler;
        }
        this.mActionHandler = new WebActionModeCallback.ActionHandler(){

            @Override
            public void selectAll() {
            }

            @Override
            public void cut() {
            }

            @Override
            public void copy() {
            }

            @Override
            public void paste() {
                FloatingPastePopupMenu.this.mDelegate.paste();
            }

            @Override
            public void share() {
            }

            @Override
            public void search() {
            }

            @Override
            public void processText(Intent intent) {
            }

            @Override
            public boolean isSelectionPassword() {
                return false;
            }

            @Override
            public boolean isSelectionEditable() {
                return true;
            }

            @Override
            public boolean isInsertion() {
                return true;
            }

            @Override
            public void onDestroyActionMode() {
                FloatingPastePopupMenu.this.mActionMode = null;
                FloatingPastePopupMenu.this.mDelegate.onDismiss();
            }

            @Override
            public void onGetContentRect(Rect outRect) {
                outRect.set(FloatingPastePopupMenu.this.mRawPositionX - FloatingPastePopupMenu.this.mContentRectOffset, FloatingPastePopupMenu.this.mRawPositionY - FloatingPastePopupMenu.this.mContentRectOffset, FloatingPastePopupMenu.this.mRawPositionX + FloatingPastePopupMenu.this.mContentRectOffset, FloatingPastePopupMenu.this.mRawPositionY + FloatingPastePopupMenu.this.mContentRectOffset);
            }

            @Override
            public boolean isIncognito() {
                return false;
            }

            @Override
            public boolean isSelectActionModeAllowed(int actionModeItem) {
                return false;
            }
        };
        return this.mActionHandler;
    }
}

