/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.IBinder;
import android.os.ResultReceiver;
import android.os.StrictMode;
import android.view.View;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.InputMethodManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class InputMethodManagerWrapper {
    private static final boolean DEBUG_LOGS = false;
    private static final String TAG = "cr_Ime";
    private final Context mContext;

    public InputMethodManagerWrapper(Context context) {
        this.mContext = context;
    }

    private InputMethodManager getInputMethodManager() {
        return (InputMethodManager)this.mContext.getSystemService("input_method");
    }

    public void restartInput(View view) {
        this.getInputMethodManager().restartInput(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showSoftInput(View view, int flags, ResultReceiver resultReceiver) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            this.getInputMethodManager().showSoftInput(view, flags, resultReceiver);
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        }
    }

    public boolean isActive(View view) {
        boolean active = this.getInputMethodManager().isActive(view);
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hideSoftInputFromWindow(IBinder windowToken, int flags, ResultReceiver resultReceiver) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
        try {
            boolean bl = this.getInputMethodManager().hideSoftInputFromWindow(windowToken, flags, resultReceiver);
            return bl;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        }
    }

    public void updateSelection(View view, int selStart, int selEnd, int candidatesStart, int candidatesEnd) {
        this.getInputMethodManager().updateSelection(view, selStart, selEnd, candidatesStart, candidatesEnd);
    }

    @TargetApi(value=21)
    public void updateCursorAnchorInfo(View view, CursorAnchorInfo cursorAnchorInfo) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.getInputMethodManager().updateCursorAnchorInfo(view, cursorAnchorInfo);
        }
    }

    public void notifyUserAction() {
        if (Build.VERSION.SDK_INT > 23) {
            return;
        }
        InputMethodManager manager = this.getInputMethodManager();
        try {
            Method method = InputMethodManager.class.getMethod("notifyUserAction", new Class[0]);
            method.invoke((Object)manager, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            return;
        }
    }
}

