/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.util.List;
import org.chromium.content.R;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.input.SelectPopup;
import org.chromium.content.browser.input.SelectPopupAdapter;
import org.chromium.content.browser.input.SelectPopupItem;

public class SelectPopupDialog
implements SelectPopup {
    private static final int[] SELECT_DIALOG_ATTRS = new int[]{R.attr.select_dialog_multichoice, R.attr.select_dialog_singlechoice};
    private final AlertDialog mListBoxPopup;
    private final ContentViewCore mContentViewCore;
    private boolean mSelectionNotified;

    public SelectPopupDialog(ContentViewCore contentViewCore, Context windowContext, List<SelectPopupItem> items, boolean multiple, int[] selected) {
        this.mContentViewCore = contentViewCore;
        final ListView listView = new ListView(windowContext);
        AlertDialog.Builder b = new AlertDialog.Builder(windowContext).setView((View)listView).setCancelable(true);
        SelectPopupDialog.setInverseBackgroundForced(b);
        if (multiple) {
            b.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    SelectPopupDialog.this.notifySelection(SelectPopupDialog.getSelectedIndices(listView));
                }
            });
            b.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    SelectPopupDialog.this.notifySelection(null);
                }
            });
        }
        this.mListBoxPopup = b.create();
        SelectPopupAdapter adapter = new SelectPopupAdapter(this.mListBoxPopup.getContext(), this.getSelectDialogLayout(multiple), items);
        listView.setAdapter((ListAdapter)adapter);
        listView.setFocusableInTouchMode(true);
        if (multiple) {
            listView.setChoiceMode(2);
            for (int i = 0; i < selected.length; ++i) {
                listView.setItemChecked(selected[i], true);
            }
        } else {
            listView.setChoiceMode(1);
            listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
                    SelectPopupDialog.this.notifySelection(SelectPopupDialog.getSelectedIndices(listView));
                    SelectPopupDialog.this.mListBoxPopup.dismiss();
                }
            });
            if (selected.length > 0) {
                listView.setSelection(selected[0]);
                listView.setItemChecked(selected[0], true);
            }
        }
        this.mListBoxPopup.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                SelectPopupDialog.this.notifySelection(null);
            }
        });
    }

    private static void setInverseBackgroundForced(AlertDialog.Builder builder) {
        builder.setInverseBackgroundForced(true);
    }

    private int getSelectDialogLayout(boolean isMultiChoice) {
        TypedArray styledAttributes = this.mListBoxPopup.getContext().obtainStyledAttributes(R.style.SelectPopupDialog, SELECT_DIALOG_ATTRS);
        int resourceId = styledAttributes.getResourceId(isMultiChoice ? 0 : 1, 0);
        styledAttributes.recycle();
        return resourceId;
    }

    private static int[] getSelectedIndices(ListView listView) {
        SparseBooleanArray sparseArray = listView.getCheckedItemPositions();
        int selectedCount = 0;
        for (int i = 0; i < sparseArray.size(); ++i) {
            if (!sparseArray.valueAt(i)) continue;
            ++selectedCount;
        }
        int[] indices = new int[selectedCount];
        int j = 0;
        for (int i = 0; i < sparseArray.size(); ++i) {
            if (!sparseArray.valueAt(i)) continue;
            indices[j++] = sparseArray.keyAt(i);
        }
        return indices;
    }

    private void notifySelection(int[] indicies) {
        if (this.mSelectionNotified) {
            return;
        }
        this.mContentViewCore.selectPopupMenuItems(indicies);
        this.mSelectionNotified = true;
    }

    @Override
    public void show() {
        try {
            this.mListBoxPopup.show();
        }
        catch (WindowManager.BadTokenException e) {
            this.notifySelection(null);
        }
    }

    @Override
    public void hide(boolean sendsCancelMessage) {
        if (sendsCancelMessage) {
            this.mListBoxPopup.cancel();
            this.notifySelection(null);
        } else {
            this.mSelectionNotified = true;
            this.mListBoxPopup.cancel();
        }
    }
}

