/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.text.TextUtils;
import java.util.Locale;
import org.chromium.content.browser.input.Range;

public class TextInputState {
    private final CharSequence mText;
    private final Range mSelection;
    private final Range mComposition;
    private final boolean mSingleLine;
    private final boolean mFromIme;

    public TextInputState(CharSequence text, Range selection, Range composition, boolean singleLine, boolean fromIme) {
        selection.clamp(0, text.length());
        if (composition.start() != -1 || composition.end() != -1) {
            composition.clamp(0, text.length());
        }
        this.mText = text;
        this.mSelection = selection;
        this.mComposition = composition;
        this.mSingleLine = singleLine;
        this.mFromIme = fromIme;
    }

    public CharSequence text() {
        return this.mText;
    }

    public Range selection() {
        return this.mSelection;
    }

    public Range composition() {
        return this.mComposition;
    }

    public boolean singleLine() {
        return this.mSingleLine;
    }

    public boolean fromIme() {
        return this.mFromIme;
    }

    public CharSequence getSelectedText() {
        if (this.mSelection.start() == this.mSelection.end()) {
            return null;
        }
        return TextUtils.substring((CharSequence)this.mText, (int)this.mSelection.start(), (int)this.mSelection.end());
    }

    public CharSequence getTextAfterSelection(int maxChars) {
        return TextUtils.substring((CharSequence)this.mText, (int)this.mSelection.end(), (int)Math.min(this.mText.length(), this.mSelection.end() + maxChars));
    }

    public CharSequence getTextBeforeSelection(int maxChars) {
        return TextUtils.substring((CharSequence)this.mText, (int)Math.max(0, this.mSelection.start() - maxChars), (int)this.mSelection.start());
    }

    public boolean equals(Object o) {
        if (!(o instanceof TextInputState)) {
            return false;
        }
        TextInputState t = (TextInputState)o;
        if (t == this) {
            return true;
        }
        return TextUtils.equals((CharSequence)this.mText, (CharSequence)t.mText) && this.mSelection.equals(t.mSelection) && this.mComposition.equals(t.mComposition) && this.mSingleLine == t.mSingleLine && this.mFromIme == t.mFromIme;
    }

    public int hashCode() {
        return this.mText.hashCode() * 7 + this.mSelection.hashCode() * 11 + this.mComposition.hashCode() * 13 + (this.mSingleLine ? 19 : 0) + (this.mFromIme ? 23 : 0);
    }

    public boolean shouldUnblock() {
        return false;
    }

    public String toString() {
        return String.format(Locale.US, "TextInputState {[%s] SEL%s COM%s %s %s}", this.mText, this.mSelection, this.mComposition, this.mSingleLine ? "SIN" : "MUL", this.mFromIme ? "fromIME" : "NOTfromIME");
    }
}

