/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content_public.browser;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Parcelable;
import org.chromium.base.ObserverList;
import org.chromium.base.VisibleForTesting;
import org.chromium.content_public.browser.AccessibilitySnapshotCallback;
import org.chromium.content_public.browser.ContentBitmapCallback;
import org.chromium.content_public.browser.ImageDownloadCallback;
import org.chromium.content_public.browser.JavaScriptCallback;
import org.chromium.content_public.browser.NavigationController;
import org.chromium.content_public.browser.WebContentsObserver;

public interface WebContents
extends Parcelable {
    public void destroy();

    public boolean isDestroyed();

    public NavigationController getNavigationController();

    public String getTitle();

    public String getVisibleUrl();

    public boolean isLoading();

    public boolean isLoadingToDifferentDocument();

    public void stop();

    public void cut();

    public void copy();

    public void paste();

    public void replace(String var1);

    public void selectAll();

    public void unselect();

    public void insertCSS(String var1);

    public void onHide();

    public void onShow();

    public void suspendAllMediaPlayers();

    public void setAudioMuted(boolean var1);

    public int getBackgroundColor();

    @VisibleForTesting
    public void showInterstitialPage(String var1, long var2);

    public boolean isShowingInterstitialPage();

    public boolean focusLocationBarByDefault();

    public boolean isReady();

    public void exitFullscreen();

    public void updateTopControlsState(boolean var1, boolean var2, boolean var3);

    public void showImeIfNeeded();

    public void scrollFocusedEditableNodeIntoView();

    public void selectWordAroundCaret();

    public void adjustSelectionByCharacterOffset(int var1, int var2);

    public String getUrl();

    public String getLastCommittedUrl();

    public boolean isIncognito();

    public void resumeLoadingCreatedWebContents();

    public void evaluateJavaScript(String var1, JavaScriptCallback var2);

    @VisibleForTesting
    public void evaluateJavaScriptForTests(String var1, JavaScriptCallback var2);

    public void addMessageToDevToolsConsole(int var1, String var2);

    public void sendMessageToFrame(String var1, String var2, String var3);

    public boolean hasAccessedInitialDocument();

    public int getThemeColor();

    public void requestAccessibilitySnapshot(AccessibilitySnapshotCallback var1);

    public void resumeMediaSession();

    public void suspendMediaSession();

    public void stopMediaSession();

    public void addObserver(WebContentsObserver var1);

    public void removeObserver(WebContentsObserver var1);

    @VisibleForTesting
    public ObserverList.RewindableIterator<WebContentsObserver> getObserversForTesting();

    public void onContextMenuOpened();

    public void onContextMenuClosed();

    @VisibleForTesting
    public String getEncoding();

    public void getContentBitmapAsync(Bitmap.Config var1, float var2, Rect var3, ContentBitmapCallback var4);

    public void reloadLoFiImages();

    public int downloadImage(String var1, boolean var2, int var3, boolean var4, ImageDownloadCallback var5);
}

