/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.device.battery;

import android.util.Log;
import org.chromium.device.battery.BatteryMonitorFactory;
import org.chromium.mojo.system.MojoException;
import org.chromium.mojom.device.BatteryMonitor;
import org.chromium.mojom.device.BatteryStatus;

public class BatteryMonitorImpl
implements BatteryMonitor {
    private static final String TAG = "BatteryMonitorImpl";
    private final BatteryMonitorFactory mFactory;
    private BatteryMonitor.QueryNextStatusResponse mCallback;
    private BatteryStatus mStatus;
    private boolean mHasStatusToReport;
    private boolean mSubscribed;

    public BatteryMonitorImpl(BatteryMonitorFactory batteryMonitorFactory) {
        this.mFactory = batteryMonitorFactory;
        this.mHasStatusToReport = false;
        this.mSubscribed = true;
    }

    private void unsubscribe() {
        if (this.mSubscribed) {
            this.mFactory.unsubscribe(this);
            this.mSubscribed = false;
        }
    }

    @Override
    public void close() {
        this.unsubscribe();
    }

    @Override
    public void onConnectionError(MojoException e) {
        this.unsubscribe();
    }

    @Override
    public void queryNextStatus(BatteryMonitor.QueryNextStatusResponse callback) {
        if (this.mCallback != null) {
            Log.e((String)TAG, (String)"Overlapped call to queryNextStatus!");
            this.unsubscribe();
            return;
        }
        this.mCallback = callback;
        if (this.mHasStatusToReport) {
            this.reportStatus();
        }
    }

    void didChange(BatteryStatus batteryStatus) {
        this.mStatus = batteryStatus;
        this.mHasStatusToReport = true;
        if (this.mCallback != null) {
            this.reportStatus();
        }
    }

    void reportStatus() {
        this.mCallback.call(this.mStatus);
        this.mCallback = null;
        this.mHasStatusToReport = false;
    }
}

