/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.device.bluetooth;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.ParcelUuid;
import java.util.List;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.components.location.LocationUtils;
import org.chromium.device.bluetooth.Wrappers;

@JNINamespace(value="device")
@TargetApi(value=21)
final class ChromeBluetoothAdapter
extends BroadcastReceiver {
    private static final String TAG = "Bluetooth";
    private long mNativeBluetoothAdapterAndroid;
    private final Wrappers.BluetoothAdapterWrapper mAdapter;
    private ScanCallback mScanCallback;

    public ChromeBluetoothAdapter(long nativeBluetoothAdapterAndroid, Wrappers.BluetoothAdapterWrapper adapterWrapper) {
        this.mNativeBluetoothAdapterAndroid = nativeBluetoothAdapterAndroid;
        this.mAdapter = adapterWrapper;
        this.registerBroadcastReceiver();
        if (adapterWrapper == null) {
            Log.i(TAG, "ChromeBluetoothAdapter created with no adapterWrapper.", new Object[0]);
        } else {
            Log.i(TAG, "ChromeBluetoothAdapter created with provided adapterWrapper.", new Object[0]);
        }
    }

    @CalledByNative
    private void onBluetoothAdapterAndroidDestruction() {
        this.stopScan();
        this.mNativeBluetoothAdapterAndroid = 0L;
        this.unregisterBroadcastReceiver();
    }

    @CalledByNative
    private static ChromeBluetoothAdapter create(long nativeBluetoothAdapterAndroid, Object adapterWrapper) {
        return new ChromeBluetoothAdapter(nativeBluetoothAdapterAndroid, (Wrappers.BluetoothAdapterWrapper)adapterWrapper);
    }

    @CalledByNative
    private String getAddress() {
        if (this.isPresent()) {
            return this.mAdapter.getAddress();
        }
        return "";
    }

    @CalledByNative
    private String getName() {
        if (this.isPresent()) {
            return this.mAdapter.getName();
        }
        return "";
    }

    @CalledByNative
    private boolean isPresent() {
        return this.mAdapter != null;
    }

    @CalledByNative
    private boolean isPowered() {
        return this.isPresent() && this.mAdapter.isEnabled();
    }

    @CalledByNative
    private boolean setPowered(boolean powered) {
        if (powered) {
            return this.isPresent() && this.mAdapter.enable();
        }
        return this.isPresent() && this.mAdapter.disable();
    }

    @CalledByNative
    private boolean isDiscoverable() {
        return this.isPresent() && this.mAdapter.getScanMode() == 23;
    }

    @CalledByNative
    private boolean isDiscovering() {
        return this.isPresent() && (this.mAdapter.isDiscovering() || this.mScanCallback != null);
    }

    @CalledByNative
    private boolean startScan() {
        Wrappers.BluetoothLeScannerWrapper scanner = this.mAdapter.getBluetoothLeScanner();
        if (scanner == null) {
            return false;
        }
        if (!this.canScan()) {
            return false;
        }
        int scanMode = 2;
        assert (this.mScanCallback == null);
        this.mScanCallback = new ScanCallback();
        try {
            scanner.startScan(null, scanMode, this.mScanCallback);
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Cannot start scan: " + e, new Object[0]);
            this.mScanCallback = null;
            return false;
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Adapter is off. Cannot start scan: " + e, new Object[0]);
            this.mScanCallback = null;
            return false;
        }
        return true;
    }

    @CalledByNative
    private boolean stopScan() {
        if (this.mScanCallback == null) {
            return false;
        }
        try {
            Wrappers.BluetoothLeScannerWrapper scanner = this.mAdapter.getBluetoothLeScanner();
            if (scanner != null) {
                scanner.stopScan(this.mScanCallback);
            }
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Cannot stop scan: " + e, new Object[0]);
        }
        catch (IllegalStateException e) {
            Log.e(TAG, "Adapter is off. Cannot stop scan: " + e, new Object[0]);
        }
        this.mScanCallback = null;
        return true;
    }

    private boolean canScan() {
        Context context = this.mAdapter.getContext();
        boolean havePermission = LocationUtils.getInstance().hasAndroidLocationPermission(context);
        boolean locationServicesOn = LocationUtils.getInstance().isSystemLocationSettingEnabled(context);
        return havePermission && locationServicesOn;
    }

    private void registerBroadcastReceiver() {
        if (this.mAdapter != null) {
            this.mAdapter.getContext().registerReceiver((BroadcastReceiver)this, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
        }
    }

    private void unregisterBroadcastReceiver() {
        if (this.mAdapter != null) {
            this.mAdapter.getContext().unregisterReceiver((BroadcastReceiver)this);
        }
    }

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (this.isPresent() && "android.bluetooth.adapter.action.STATE_CHANGED".equals(action)) {
            int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
            Log.w(TAG, "onReceive: BluetoothAdapter.ACTION_STATE_CHANGED: %s", this.getBluetoothStateString(state));
            switch (state) {
                case 12: {
                    this.nativeOnAdapterStateChanged(this.mNativeBluetoothAdapterAndroid, true);
                    break;
                }
                case 10: {
                    this.nativeOnAdapterStateChanged(this.mNativeBluetoothAdapterAndroid, false);
                    break;
                }
            }
        }
    }

    private String getBluetoothStateString(int state) {
        switch (state) {
            case 10: {
                return "STATE_OFF";
            }
            case 12: {
                return "STATE_ON";
            }
            case 13: {
                return "STATE_TURNING_OFF";
            }
            case 11: {
                return "STATE_TURNING_ON";
            }
        }
        assert (false);
        return "illegal state: " + state;
    }

    private native void nativeOnScanFailed(long var1);

    private native void nativeCreateOrUpdateDeviceOnScan(long var1, String var3, Object var4, List<ParcelUuid> var5);

    private native void nativeOnAdapterStateChanged(long var1, boolean var3);

    private class ScanCallback
    extends Wrappers.ScanCallbackWrapper {
        private ScanCallback() {
        }

        @Override
        public void onBatchScanResult(List<Wrappers.ScanResultWrapper> results) {
            Log.v(ChromeBluetoothAdapter.TAG, "onBatchScanResults");
        }

        @Override
        public void onScanResult(int callbackType, Wrappers.ScanResultWrapper result) {
            Log.v(ChromeBluetoothAdapter.TAG, "onScanResult %d %s %s", callbackType, result.getDevice().getAddress(), result.getDevice().getName());
            List<ParcelUuid> uuids = result.getScanRecord_getServiceUuids();
            ChromeBluetoothAdapter.this.nativeCreateOrUpdateDeviceOnScan(ChromeBluetoothAdapter.this.mNativeBluetoothAdapterAndroid, result.getDevice().getAddress(), result.getDevice(), uuids);
        }

        @Override
        public void onScanFailed(int errorCode) {
            Log.w(ChromeBluetoothAdapter.TAG, "onScanFailed: %d", errorCode);
            ChromeBluetoothAdapter.this.nativeOnScanFailed(ChromeBluetoothAdapter.this.mNativeBluetoothAdapterAndroid);
        }
    }
}

