/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.device.bluetooth;

import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.device.bluetooth.ChromeBluetoothDevice;
import org.chromium.device.bluetooth.Wrappers;

@JNINamespace(value="device")
final class ChromeBluetoothRemoteGattDescriptor {
    private static final String TAG = "Bluetooth";
    private long mNativeBluetoothRemoteGattDescriptorAndroid;
    final Wrappers.BluetoothGattDescriptorWrapper mDescriptor;
    final ChromeBluetoothDevice mChromeDevice;

    private ChromeBluetoothRemoteGattDescriptor(long nativeBluetoothRemoteGattDescriptorAndroid, Wrappers.BluetoothGattDescriptorWrapper descriptorWrapper, ChromeBluetoothDevice chromeDevice) {
        this.mNativeBluetoothRemoteGattDescriptorAndroid = nativeBluetoothRemoteGattDescriptorAndroid;
        this.mDescriptor = descriptorWrapper;
        this.mChromeDevice = chromeDevice;
        this.mChromeDevice.mWrapperToChromeDescriptorsMap.put(descriptorWrapper, this);
        Log.v(TAG, "ChromeBluetoothRemoteGattDescriptor created.");
    }

    @CalledByNative
    private void onBluetoothRemoteGattDescriptorAndroidDestruction() {
        Log.v(TAG, "ChromeBluetoothRemoteGattDescriptor Destroyed.");
        this.mNativeBluetoothRemoteGattDescriptorAndroid = 0L;
        this.mChromeDevice.mWrapperToChromeDescriptorsMap.remove(this.mDescriptor);
    }

    void onDescriptorRead(int status) {
        Log.i(TAG, "onDescriptorRead status:%d==%s", status, status == 0 ? "OK" : "Error");
        if (this.mNativeBluetoothRemoteGattDescriptorAndroid != 0L) {
            this.nativeOnRead(this.mNativeBluetoothRemoteGattDescriptorAndroid, status, this.mDescriptor.getValue());
        }
    }

    void onDescriptorWrite(int status) {
        Log.i(TAG, "onDescriptorWrite status:%d==%s", status, status == 0 ? "OK" : "Error");
        if (this.mNativeBluetoothRemoteGattDescriptorAndroid != 0L) {
            this.nativeOnWrite(this.mNativeBluetoothRemoteGattDescriptorAndroid, status);
        }
    }

    @CalledByNative
    private static ChromeBluetoothRemoteGattDescriptor create(long nativeBluetoothRemoteGattDescriptorAndroid, Object bluetoothGattDescriptorWrapper, ChromeBluetoothDevice chromeDevice) {
        return new ChromeBluetoothRemoteGattDescriptor(nativeBluetoothRemoteGattDescriptorAndroid, (Wrappers.BluetoothGattDescriptorWrapper)bluetoothGattDescriptorWrapper, chromeDevice);
    }

    @CalledByNative
    private String getUUID() {
        return this.mDescriptor.getUuid().toString();
    }

    @CalledByNative
    private boolean readRemoteDescriptor() {
        if (!this.mChromeDevice.mBluetoothGatt.readDescriptor(this.mDescriptor)) {
            Log.i(TAG, "readRemoteDescriptor readDescriptor failed.", new Object[0]);
            return false;
        }
        return true;
    }

    @CalledByNative
    private boolean writeRemoteDescriptor(byte[] value) {
        if (!this.mDescriptor.setValue(value)) {
            Log.i(TAG, "writeRemoteDescriptor setValue failed.", new Object[0]);
            return false;
        }
        if (!this.mChromeDevice.mBluetoothGatt.writeDescriptor(this.mDescriptor)) {
            Log.i(TAG, "writeRemoteDescriptor writeDescriptor failed.", new Object[0]);
            return false;
        }
        return true;
    }

    native void nativeOnRead(long var1, int var3, byte[] var4);

    native void nativeOnWrite(long var1, int var3);
}

