/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.device.usb;

import android.annotation.TargetApi;
import android.hardware.usb.UsbConfiguration;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="device")
final class ChromeUsbDevice {
    private static final String TAG = "Usb";
    final UsbDevice mDevice;

    private ChromeUsbDevice(UsbDevice device) {
        this.mDevice = device;
        Log.v(TAG, "ChromeUsbDevice created.");
    }

    public UsbDevice getDevice() {
        return this.mDevice;
    }

    @CalledByNative
    private static ChromeUsbDevice create(UsbDevice device) {
        return new ChromeUsbDevice(device);
    }

    @CalledByNative
    private int getDeviceId() {
        return this.mDevice.getDeviceId();
    }

    @CalledByNative
    private int getDeviceClass() {
        return this.mDevice.getDeviceClass();
    }

    @CalledByNative
    private int getDeviceSubclass() {
        return this.mDevice.getDeviceSubclass();
    }

    @CalledByNative
    private int getDeviceProtocol() {
        return this.mDevice.getDeviceProtocol();
    }

    @CalledByNative
    private int getVendorId() {
        return this.mDevice.getVendorId();
    }

    @CalledByNative
    private int getProductId() {
        return this.mDevice.getProductId();
    }

    @TargetApi(value=23)
    @CalledByNative
    private int getDeviceVersion() {
        String[] parts = this.mDevice.getVersion().split("\\.");
        assert (parts.length == 2);
        return Integer.parseInt(parts[0]) << 8 | Integer.parseInt(parts[1]);
    }

    @TargetApi(value=21)
    @CalledByNative
    private String getManufacturerName() {
        return this.mDevice.getManufacturerName();
    }

    @TargetApi(value=21)
    @CalledByNative
    private String getProductName() {
        return this.mDevice.getProductName();
    }

    @TargetApi(value=21)
    @CalledByNative
    private String getSerialNumber() {
        return this.mDevice.getSerialNumber();
    }

    @TargetApi(value=21)
    @CalledByNative
    private UsbConfiguration[] getConfigurations() {
        int count = this.mDevice.getConfigurationCount();
        UsbConfiguration[] configurations = new UsbConfiguration[count];
        for (int i = 0; i < count; ++i) {
            configurations[i] = this.mDevice.getConfiguration(i);
        }
        return configurations;
    }

    @CalledByNative
    private UsbInterface[] getInterfaces() {
        int count = this.mDevice.getInterfaceCount();
        UsbInterface[] interfaces = new UsbInterface[count];
        for (int i = 0; i < count; ++i) {
            interfaces[i] = this.mDevice.getInterface(i);
        }
        return interfaces;
    }
}

