/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.device.usb;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import java.util.HashMap;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.device.usb.ChromeUsbDevice;

@JNINamespace(value="device")
final class ChromeUsbService {
    private static final String TAG = "Usb";
    private static final String ACTION_USB_PERMISSION = "org.chromium.device.ACTION_USB_PERMISSION";
    Context mContext;
    long mUsbServiceAndroid;
    UsbManager mUsbManager;
    BroadcastReceiver mUsbDeviceReceiver;

    private ChromeUsbService(Context context, long usbServiceAndroid) {
        this.mContext = context;
        this.mUsbServiceAndroid = usbServiceAndroid;
        this.mUsbManager = (UsbManager)this.mContext.getSystemService("usb");
        this.registerForUsbDeviceIntentBroadcast();
        Log.v(TAG, "ChromeUsbService created.");
    }

    @CalledByNative
    private static ChromeUsbService create(Context context, long usbServiceAndroid) {
        return new ChromeUsbService(context, usbServiceAndroid);
    }

    @CalledByNative
    private Object[] getDevices() {
        HashMap deviceList = this.mUsbManager.getDeviceList();
        return deviceList.values().toArray();
    }

    @CalledByNative
    private UsbDeviceConnection openDevice(ChromeUsbDevice wrapper) {
        UsbDevice device = wrapper.getDevice();
        return this.mUsbManager.openDevice(device);
    }

    @CalledByNative
    private void requestDevicePermission(ChromeUsbDevice wrapper, long nativeCallback) {
        UsbDevice device = wrapper.getDevice();
        if (this.mUsbManager.hasPermission(device)) {
            this.nativeDevicePermissionRequestComplete(this.mUsbServiceAndroid, device.getDeviceId(), true);
        } else {
            PendingIntent intent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
            this.mUsbManager.requestPermission(wrapper.getDevice(), intent);
        }
    }

    @CalledByNative
    private void close() {
        this.unregisterForUsbDeviceIntentBroadcast();
    }

    private native void nativeDeviceAttached(long var1, UsbDevice var3);

    private native void nativeDeviceDetached(long var1, int var3);

    private native void nativeDevicePermissionRequestComplete(long var1, int var3, boolean var4);

    private void registerForUsbDeviceIntentBroadcast() {
        this.mUsbDeviceReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(intent.getAction())) {
                    ChromeUsbService.this.nativeDeviceAttached(ChromeUsbService.this.mUsbServiceAndroid, device);
                } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(intent.getAction())) {
                    ChromeUsbService.this.nativeDeviceDetached(ChromeUsbService.this.mUsbServiceAndroid, device.getDeviceId());
                } else if (ChromeUsbService.ACTION_USB_PERMISSION.equals(intent.getAction())) {
                    ChromeUsbService.this.nativeDevicePermissionRequestComplete(ChromeUsbService.this.mUsbServiceAndroid, device.getDeviceId(), intent.getBooleanExtra("permission", false));
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        filter.addAction(ACTION_USB_PERMISSION);
        this.mContext.registerReceiver(this.mUsbDeviceReceiver, filter);
    }

    private void unregisterForUsbDeviceIntentBroadcast() {
        this.mContext.unregisterReceiver(this.mUsbDeviceReceiver);
        this.mUsbDeviceReceiver = null;
    }
}

