/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.content.Context;
import android.view.WindowManager;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.media.PhotoCapabilities;
import org.chromium.media.VideoCaptureFormat;

@JNINamespace(value="media")
public abstract class VideoCapture {
    protected int mCameraNativeOrientation;
    protected boolean mInvertDeviceOrientationReadings;
    protected VideoCaptureFormat mCaptureFormat = null;
    protected final Context mContext;
    protected final int mId;
    protected final long mNativeVideoCaptureDeviceAndroid;

    VideoCapture(Context context, int id2, long nativeVideoCaptureDeviceAndroid) {
        this.mContext = context;
        this.mId = id2;
        this.mNativeVideoCaptureDeviceAndroid = nativeVideoCaptureDeviceAndroid;
    }

    @CalledByNative
    public abstract boolean allocate(int var1, int var2, int var3);

    @CalledByNative
    public abstract boolean startCapture();

    @CalledByNative
    public abstract boolean stopCapture();

    @CalledByNative
    public abstract PhotoCapabilities getPhotoCapabilities();

    @CalledByNative
    public abstract boolean takePhoto(long var1);

    @CalledByNative
    public abstract void deallocate();

    @CalledByNative
    public final int queryWidth() {
        return this.mCaptureFormat.mWidth;
    }

    @CalledByNative
    public final int queryHeight() {
        return this.mCaptureFormat.mHeight;
    }

    @CalledByNative
    public final int queryFrameRate() {
        return this.mCaptureFormat.mFramerate;
    }

    @CalledByNative
    public final int getColorspace() {
        switch (this.mCaptureFormat.mPixelFormat) {
            case 842094169: {
                return 842094169;
            }
            case 35: {
                return 35;
            }
            case 17: {
                return 17;
            }
        }
        return 0;
    }

    protected final int getCameraRotation() {
        int rotation = this.mInvertDeviceOrientationReadings ? 360 - this.getDeviceRotation() : this.getDeviceRotation();
        return (this.mCameraNativeOrientation + rotation) % 360;
    }

    protected final int getDeviceRotation() {
        int orientation;
        if (this.mContext == null) {
            return 0;
        }
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            case 1: {
                orientation = 90;
                break;
            }
            case 2: {
                orientation = 180;
                break;
            }
            case 3: {
                orientation = 270;
                break;
            }
            default: {
                orientation = 0;
            }
        }
        return orientation;
    }

    public native void nativeOnFrameAvailable(long var1, byte[] var3, int var4, int var5);

    public native void nativeOnError(long var1, String var3);

    public native void nativeOnPhotoTaken(long var1, long var3, byte[] var5);
}

