/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Size;
import android.view.Surface;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.chromium.base.Log;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.media.PhotoCapabilities;
import org.chromium.media.VideoCapture;
import org.chromium.media.VideoCaptureFormat;

@JNINamespace(value="media")
@TargetApi(value=21)
public class VideoCaptureCamera2
extends VideoCapture {
    private static final double kNanoSecondsToFps = 1.0E-9;
    private static final String TAG = "VideoCapture";
    private final Object mCameraStateLock = new Object();
    private byte[] mCapturedData;
    private CameraDevice mCameraDevice;
    private CameraCaptureSession mPreviewSession;
    private CaptureRequest mPreviewRequest;
    private CameraState mCameraState = CameraState.STOPPED;

    private static CameraCharacteristics getCameraCharacteristics(Context appContext, int id2) {
        CameraManager manager = (CameraManager)appContext.getSystemService("camera");
        try {
            return manager.getCameraCharacteristics(Integer.toString(id2));
        }
        catch (CameraAccessException ex) {
            Log.e(TAG, "getCameraCharacteristics: ", new Object[]{ex});
            return null;
        }
    }

    private void notifyTakePhotoError(long callbackId) {
        this.nativeOnPhotoTaken(this.mNativeVideoCaptureDeviceAndroid, callbackId, new byte[0]);
    }

    private boolean createPreviewObjects() {
        Log.d(TAG, "createPreviewObjects");
        if (this.mCameraDevice == null) {
            return false;
        }
        ImageReader imageReader = ImageReader.newInstance((int)this.mCaptureFormat.getWidth(), (int)this.mCaptureFormat.getHeight(), (int)this.mCaptureFormat.getPixelFormat(), (int)2);
        HandlerThread thread = new HandlerThread("CameraPreview");
        thread.start();
        Handler backgroundHandler = new Handler(thread.getLooper());
        CrImageReaderListener imageReaderListener = new CrImageReaderListener();
        imageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)imageReaderListener, backgroundHandler);
        CaptureRequest.Builder previewRequestBuilder = null;
        try {
            previewRequestBuilder = this.mCameraDevice.createCaptureRequest(1);
        }
        catch (CameraAccessException | IllegalArgumentException | SecurityException ex) {
            Log.e(TAG, "createCaptureRequest: ", ex);
            return false;
        }
        if (previewRequestBuilder == null) {
            Log.e(TAG, "previewRequestBuilder error", new Object[0]);
            return false;
        }
        previewRequestBuilder.addTarget(imageReader.getSurface());
        previewRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
        previewRequestBuilder.set(CaptureRequest.NOISE_REDUCTION_MODE, (Object)1);
        previewRequestBuilder.set(CaptureRequest.EDGE_MODE, (Object)1);
        previewRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
        ArrayList<Surface> surfaceList = new ArrayList<Surface>(1);
        surfaceList.add(imageReader.getSurface());
        this.mPreviewRequest = previewRequestBuilder.build();
        CrPreviewSessionListener captureSessionListener = new CrPreviewSessionListener(this.mPreviewRequest);
        try {
            this.mCameraDevice.createCaptureSession(surfaceList, (CameraCaptureSession.StateCallback)captureSessionListener, null);
        }
        catch (CameraAccessException | IllegalArgumentException | SecurityException ex) {
            Log.e(TAG, "createCaptureSession: ", ex);
            return false;
        }
        return true;
    }

    private static void readImageIntoBuffer(Image image, byte[] data) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        Image.Plane[] planes = image.getPlanes();
        int offset = 0;
        for (int plane = 0; plane < planes.length; ++plane) {
            int planeHeight;
            ByteBuffer buffer = planes[plane].getBuffer();
            int rowStride = planes[plane].getRowStride();
            int pixelStride = planes[plane].getPixelStride();
            int planeWidth = plane == 0 ? imageWidth : imageWidth / 2;
            int n = planeHeight = plane == 0 ? imageHeight : imageHeight / 2;
            if (pixelStride == 1 && rowStride == planeWidth) {
                buffer.get(data, offset, planeWidth * planeHeight);
                offset += planeWidth * planeHeight;
                continue;
            }
            byte[] rowData = new byte[rowStride];
            for (int row = 0; row < planeHeight - 1; ++row) {
                buffer.get(rowData, 0, rowStride);
                for (int col = 0; col < planeWidth; ++col) {
                    data[offset++] = rowData[col * pixelStride];
                }
            }
            buffer.get(rowData, 0, Math.min(rowStride, buffer.remaining()));
            for (int col = 0; col < planeWidth; ++col) {
                data[offset++] = rowData[col * pixelStride];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeCameraStateAndNotify(CameraState state) {
        Object object = this.mCameraStateLock;
        synchronized (object) {
            this.mCameraState = state;
            this.mCameraStateLock.notifyAll();
        }
    }

    static boolean isLegacyDevice(Context appContext, int id2) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(appContext, id2);
        return cameraCharacteristics != null && (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL) == 2;
    }

    static int getNumberOfCameras(Context appContext) {
        CameraManager manager = (CameraManager)appContext.getSystemService("camera");
        try {
            return manager.getCameraIdList().length;
        }
        catch (CameraAccessException | SecurityException ex) {
            Log.e(TAG, "getNumberOfCameras: getCameraIdList(): ", ex);
            return 0;
        }
    }

    static int getCaptureApiType(int id2, Context appContext) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(appContext, id2);
        if (cameraCharacteristics == null) {
            return 5;
        }
        int supportedHWLevel = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        switch (supportedHWLevel) {
            case 2: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 0: {
                return 3;
            }
        }
        return 1;
    }

    static String getName(int id2, Context appContext) {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(appContext, id2);
        if (cameraCharacteristics == null) {
            return null;
        }
        int facing = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
        return "camera2 " + id2 + ", facing " + (facing == 0 ? "front" : "back");
    }

    static VideoCaptureFormat[] getDeviceSupportedFormats(Context appContext, int id2) {
        int[] formats;
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(appContext, id2);
        if (cameraCharacteristics == null) {
            return null;
        }
        int[] capabilities = (int[])cameraCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        boolean minFrameDurationAvailable = false;
        for (int cap : capabilities) {
            if (cap != 1) continue;
            minFrameDurationAvailable = true;
            break;
        }
        ArrayList<VideoCaptureFormat> formatList = new ArrayList<VideoCaptureFormat>();
        StreamConfigurationMap streamMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        for (int format : formats = streamMap.getOutputFormats()) {
            Size[] sizes = streamMap.getOutputSizes(format);
            if (sizes == null) continue;
            for (Size size : sizes) {
                long minFrameDuration;
                double minFrameRate = 0.0;
                minFrameRate = minFrameDurationAvailable ? ((minFrameDuration = streamMap.getOutputMinFrameDuration(format, size)) == 0L ? 0.0 : 9.999999999999999E8 * (double)minFrameDuration) : 0.0;
                formatList.add(new VideoCaptureFormat(size.getWidth(), size.getHeight(), (int)minFrameRate, 0));
            }
        }
        return formatList.toArray(new VideoCaptureFormat[formatList.size()]);
    }

    VideoCaptureCamera2(Context context, int id2, long nativeVideoCaptureDeviceAndroid) {
        super(context, id2, nativeVideoCaptureDeviceAndroid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocate(int width, int height, int frameRate) {
        Log.d(TAG, "allocate: requested (%d x %d) @%dfps", width, height, frameRate);
        Object object = this.mCameraStateLock;
        synchronized (object) {
            if (this.mCameraState == CameraState.OPENING || this.mCameraState == CameraState.CONFIGURING) {
                Log.e(TAG, "allocate() invoked while Camera is busy opening/configuring.", new Object[0]);
                return false;
            }
        }
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        StreamConfigurationMap streamMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        Size[] supportedSizes = streamMap.getOutputSizes(35);
        if (supportedSizes == null) {
            return false;
        }
        Size closestSupportedSize = null;
        int minDiff = Integer.MAX_VALUE;
        for (Size size : supportedSizes) {
            int diff = Math.abs(size.getWidth() - width) + Math.abs(size.getHeight() - height);
            if (diff >= minDiff) continue;
            minDiff = diff;
            closestSupportedSize = size;
        }
        if (minDiff == Integer.MAX_VALUE) {
            Log.e(TAG, "No supported resolutions.", new Object[0]);
            return false;
        }
        Log.d(TAG, "allocate: matched (%d x %d)", closestSupportedSize.getWidth(), closestSupportedSize.getHeight());
        this.mCaptureFormat = new VideoCaptureFormat(closestSupportedSize.getWidth(), closestSupportedSize.getHeight(), frameRate, 35);
        int expectedFrameSize = this.mCaptureFormat.mWidth * this.mCaptureFormat.mHeight * ImageFormat.getBitsPerPixel((int)this.mCaptureFormat.mPixelFormat) / 8;
        this.mCapturedData = new byte[expectedFrameSize];
        this.mCameraNativeOrientation = (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        this.mInvertDeviceOrientationReadings = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 1;
        return true;
    }

    @Override
    public boolean startCapture() {
        Log.d(TAG, "startCapture");
        this.changeCameraStateAndNotify(CameraState.OPENING);
        CameraManager manager = (CameraManager)this.mContext.getSystemService("camera");
        Handler mainHandler = new Handler(this.mContext.getMainLooper());
        CrStateListener stateListener = new CrStateListener();
        try {
            manager.openCamera(Integer.toString(this.mId), (CameraDevice.StateCallback)stateListener, mainHandler);
        }
        catch (CameraAccessException | IllegalArgumentException | SecurityException ex) {
            Log.e(TAG, "allocate: manager.openCamera: ", ex);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopCapture() {
        Log.d(TAG, "stopCapture");
        Object object = this.mCameraStateLock;
        synchronized (object) {
            while (this.mCameraState != CameraState.STARTED && this.mCameraState != CameraState.STOPPED) {
                try {
                    this.mCameraStateLock.wait();
                }
                catch (InterruptedException ex) {
                    Log.e(TAG, "CaptureStartedEvent: ", ex);
                }
            }
            if (this.mCameraState == CameraState.STOPPED) {
                return true;
            }
        }
        try {
            this.mPreviewSession.abortCaptures();
        }
        catch (CameraAccessException | IllegalStateException ex) {
            Log.e(TAG, "abortCaptures: ", ex);
            return false;
        }
        if (this.mCameraDevice == null) {
            return false;
        }
        this.mCameraDevice.close();
        this.changeCameraStateAndNotify(CameraState.STOPPED);
        return true;
    }

    @Override
    public PhotoCapabilities getPhotoCapabilities() {
        CameraCharacteristics cameraCharacteristics = VideoCaptureCamera2.getCameraCharacteristics(this.mContext, this.mId);
        int maxZoom = Math.round(((Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue() * 100.0f);
        int currentZoom = 100 * ((Rect)this.mPreviewRequest.get(CaptureRequest.SCALER_CROP_REGION)).width() / ((Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE)).width();
        return new PhotoCapabilities(maxZoom, 100, currentZoom);
    }

    @Override
    public boolean takePhoto(long callbackId) {
        Log.d(TAG, "takePhoto " + callbackId);
        if (this.mCameraDevice == null || this.mCameraState != CameraState.STARTED) {
            return false;
        }
        ImageReader imageReader = ImageReader.newInstance((int)this.mCaptureFormat.getWidth(), (int)this.mCaptureFormat.getHeight(), (int)256, (int)1);
        HandlerThread thread = new HandlerThread("CameraPicture");
        thread.start();
        Handler backgroundHandler = new Handler(thread.getLooper());
        CrPhotoReaderListener photoReaderListener = new CrPhotoReaderListener(callbackId);
        imageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)photoReaderListener, backgroundHandler);
        ArrayList<Surface> surfaceList = new ArrayList<Surface>(1);
        surfaceList.add(imageReader.getSurface());
        CaptureRequest.Builder photoRequestBuilder = null;
        try {
            photoRequestBuilder = this.mCameraDevice.createCaptureRequest(2);
        }
        catch (CameraAccessException e) {
            Log.e(TAG, "mCameraDevice.createCaptureRequest() error", new Object[0]);
            return false;
        }
        if (photoRequestBuilder == null) {
            Log.e(TAG, "photoRequestBuilder error", new Object[0]);
            return false;
        }
        photoRequestBuilder.addTarget(imageReader.getSurface());
        photoRequestBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)this.getCameraRotation());
        CaptureRequest photoRequest = photoRequestBuilder.build();
        CrPhotoSessionListener sessionListener = new CrPhotoSessionListener(photoRequest, callbackId);
        try {
            this.mCameraDevice.createCaptureSession(surfaceList, (CameraCaptureSession.StateCallback)sessionListener, backgroundHandler);
        }
        catch (CameraAccessException | IllegalArgumentException | SecurityException ex) {
            Log.e(TAG, "createCaptureSession: " + ex, new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public void deallocate() {
        Log.d(TAG, "deallocate");
    }

    private static enum CameraState {
        OPENING,
        CONFIGURING,
        STARTED,
        STOPPED;

    }

    private class CrPhotoReaderListener
    implements ImageReader.OnImageAvailableListener {
        private final long mCallbackId;

        CrPhotoReaderListener(long callbackId) {
            this.mCallbackId = callbackId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] readCapturedData(Image image) {
            byte[] capturedData = null;
            try {
                capturedData = image.getPlanes()[0].getBuffer().array();
                return capturedData;
            }
            catch (UnsupportedOperationException ex) {
                ByteBuffer buffer = image.getPlanes()[0].getBuffer();
                capturedData = new byte[buffer.remaining()];
                buffer.get(capturedData);
            }
            finally {
                return capturedData;
            }
        }

        public void onImageAvailable(ImageReader reader) {
            Log.d(VideoCaptureCamera2.TAG, "CrPhotoReaderListener.mCallbackId " + this.mCallbackId);
            try (Image image = reader.acquireLatestImage();){
                if (image == null) {
                    throw new IllegalStateException();
                }
                if (image.getFormat() != 256) {
                    Log.e(VideoCaptureCamera2.TAG, "Unexpected image format: %d", image.getFormat());
                    throw new IllegalStateException();
                }
                byte[] capturedData = this.readCapturedData(image);
                VideoCaptureCamera2.this.nativeOnPhotoTaken(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, this.mCallbackId, capturedData);
            }
            catch (IllegalStateException ex) {
                VideoCaptureCamera2.this.notifyTakePhotoError(this.mCallbackId);
                return;
            }
            if (VideoCaptureCamera2.this.createPreviewObjects()) {
                return;
            }
            VideoCaptureCamera2.this.nativeOnError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "Error restarting preview");
        }
    }

    private class CrPhotoSessionListener
    extends CameraCaptureSession.StateCallback {
        private final CaptureRequest mPhotoRequest;
        private final long mCallbackId;

        CrPhotoSessionListener(CaptureRequest photoRequest, long callbackId) {
            this.mPhotoRequest = photoRequest;
            this.mCallbackId = callbackId;
        }

        public void onConfigured(CameraCaptureSession session) {
            Log.d(VideoCaptureCamera2.TAG, "onConfigured");
            try {
                session.capture(this.mPhotoRequest, null, null);
            }
            catch (CameraAccessException e) {
                Log.e(VideoCaptureCamera2.TAG, "capture() error", new Object[0]);
                VideoCaptureCamera2.this.notifyTakePhotoError(this.mCallbackId);
                return;
            }
        }

        public void onConfigureFailed(CameraCaptureSession session) {
            Log.e(VideoCaptureCamera2.TAG, "failed configuring capture session", new Object[0]);
            VideoCaptureCamera2.this.notifyTakePhotoError(this.mCallbackId);
        }
    }

    private class CrImageReaderListener
    implements ImageReader.OnImageAvailableListener {
        private CrImageReaderListener() {
        }

        public void onImageAvailable(ImageReader reader) {
            try (Image image = reader.acquireLatestImage();){
                if (image == null) {
                    return;
                }
                if (image.getFormat() != 35 || image.getPlanes().length != 3) {
                    VideoCaptureCamera2.this.nativeOnError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "Unexpected image format: " + image.getFormat() + " or #planes: " + image.getPlanes().length);
                    throw new IllegalStateException();
                }
                if (reader.getWidth() != image.getWidth() || reader.getHeight() != image.getHeight()) {
                    VideoCaptureCamera2.this.nativeOnError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "ImageReader size (" + reader.getWidth() + "x" + reader.getHeight() + ") did not match Image size (" + image.getWidth() + "x" + image.getHeight() + ")");
                    throw new IllegalStateException();
                }
                VideoCaptureCamera2.readImageIntoBuffer(image, VideoCaptureCamera2.this.mCapturedData);
                VideoCaptureCamera2.this.nativeOnFrameAvailable(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, VideoCaptureCamera2.this.mCapturedData, VideoCaptureCamera2.this.mCapturedData.length, VideoCaptureCamera2.this.getCameraRotation());
            }
            catch (IllegalStateException ex) {
                Log.e(VideoCaptureCamera2.TAG, "acquireLatestImage():", ex);
            }
        }
    }

    private class CrPreviewSessionListener
    extends CameraCaptureSession.StateCallback {
        private final CaptureRequest mPreviewRequest;

        CrPreviewSessionListener(CaptureRequest previewRequest) {
            this.mPreviewRequest = previewRequest;
        }

        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            Log.d(VideoCaptureCamera2.TAG, "onConfigured");
            VideoCaptureCamera2.this.mPreviewSession = cameraCaptureSession;
            try {
                VideoCaptureCamera2.this.mPreviewSession.setRepeatingRequest(this.mPreviewRequest, null, null);
            }
            catch (CameraAccessException | IllegalArgumentException | SecurityException ex) {
                Log.e(VideoCaptureCamera2.TAG, "setRepeatingRequest: ", ex);
                return;
            }
            VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STARTED);
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
            VideoCaptureCamera2.this.nativeOnError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "Camera session configuration error");
        }
    }

    private class CrStateListener
    extends CameraDevice.StateCallback {
        private CrStateListener() {
        }

        public void onOpened(CameraDevice cameraDevice) {
            VideoCaptureCamera2.this.mCameraDevice = cameraDevice;
            VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.CONFIGURING);
            if (!VideoCaptureCamera2.this.createPreviewObjects()) {
                VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
                VideoCaptureCamera2.this.nativeOnError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "Error configuring camera");
            }
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            cameraDevice.close();
            VideoCaptureCamera2.this.mCameraDevice = null;
            VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
        }

        public void onError(CameraDevice cameraDevice, int error) {
            cameraDevice.close();
            VideoCaptureCamera2.this.mCameraDevice = null;
            VideoCaptureCamera2.this.changeCameraStateAndNotify(CameraState.STOPPED);
            VideoCaptureCamera2.this.nativeOnError(VideoCaptureCamera2.this.mNativeVideoCaptureDeviceAndroid, "Camera device error " + Integer.toString(error));
        }
    }
}

