/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media.midi;

import android.annotation.TargetApi;
import android.media.midi.MidiDevice;
import android.media.midi.MidiOutputPort;
import android.media.midi.MidiReceiver;
import java.io.IOException;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="media::midi")
@TargetApi(value=23)
class MidiInputPortAndroid {
    private MidiOutputPort mPort;
    private long mNativeReceiverPointer;
    private final MidiDevice mDevice;
    private final int mIndex;

    MidiInputPortAndroid(MidiDevice device, int index) {
        this.mDevice = device;
        this.mIndex = index;
    }

    @CalledByNative
    boolean open(long nativeReceiverPointer) {
        if (this.mPort != null) {
            return true;
        }
        this.mPort = this.mDevice.openOutputPort(this.mIndex);
        if (this.mPort == null) {
            return false;
        }
        this.mNativeReceiverPointer = nativeReceiverPointer;
        this.mPort.connect(new MidiReceiver(){

            public void onSend(byte[] bs, int offset, int count, long timestamp) {
                MidiInputPortAndroid.nativeOnData(MidiInputPortAndroid.this.mNativeReceiverPointer, bs, offset, count, timestamp);
            }
        });
        return true;
    }

    @CalledByNative
    void close() {
        if (this.mPort == null) {
            return;
        }
        try {
            this.mPort.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mNativeReceiverPointer = 0L;
        this.mPort = null;
    }

    private static native void nativeOnData(long var0, byte[] var2, int var3, int var4, long var5);
}

