/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media.midi;

import android.annotation.TargetApi;
import android.media.midi.MidiDevice;
import android.media.midi.MidiInputPort;
import java.io.IOException;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="media::midi")
@TargetApi(value=23)
class MidiOutputPortAndroid {
    private MidiInputPort mPort;
    private final MidiDevice mDevice;
    private final int mIndex;
    private static final String TAG = "media_midi";

    MidiOutputPortAndroid(MidiDevice device, int index) {
        this.mDevice = device;
        this.mIndex = index;
    }

    @CalledByNative
    boolean open() {
        if (this.mPort != null) {
            return true;
        }
        this.mPort = this.mDevice.openInputPort(this.mIndex);
        return this.mPort != null;
    }

    @CalledByNative
    void send(byte[] bs) {
        if (this.mPort == null) {
            return;
        }
        try {
            this.mPort.send(bs, 0, bs.length);
        }
        catch (IOException e) {
            Log.e(TAG, "MidiOutputPortAndroid.send: " + e, new Object[0]);
        }
    }

    @CalledByNative
    void close() {
        if (this.mPort == null) {
            return;
        }
        try {
            this.mPort.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mPort = null;
    }
}

