/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media.midi;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.media.midi.UsbMidiDeviceAndroid;

@JNINamespace(value="media::midi")
class UsbMidiDeviceFactoryAndroid {
    private UsbManager mUsbManager;
    private BroadcastReceiver mReceiver;
    private final List<UsbMidiDeviceAndroid> mDevices = new ArrayList<UsbMidiDeviceAndroid>();
    private Set<UsbDevice> mRequestedDevices;
    private boolean mIsEnumeratingDevices;
    private long mNativePointer;
    private static final String ACTION_USB_PERMISSION = "org.chromium.media.USB_PERMISSION";

    UsbMidiDeviceFactoryAndroid(Context context, long nativePointer) {
        this.mUsbManager = (UsbManager)context.getSystemService("usb");
        this.mNativePointer = nativePointer;
        this.mReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                Parcelable extra = intent.getParcelableExtra("device");
                if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(intent.getAction())) {
                    UsbMidiDeviceFactoryAndroid.this.requestDevicePermissionIfNecessary(context, (UsbDevice)extra);
                }
                if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(intent.getAction())) {
                    UsbMidiDeviceFactoryAndroid.this.onUsbDeviceDetached((UsbDevice)extra);
                }
                if (UsbMidiDeviceFactoryAndroid.ACTION_USB_PERMISSION.equals(intent.getAction())) {
                    UsbMidiDeviceFactoryAndroid.this.onUsbDevicePermissionRequestDone(context, intent);
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        filter.addAction(ACTION_USB_PERMISSION);
        context.registerReceiver(this.mReceiver, filter);
        this.mRequestedDevices = new HashSet<UsbDevice>();
    }

    @CalledByNative
    static UsbMidiDeviceFactoryAndroid create(Context context, long nativePointer) {
        return new UsbMidiDeviceFactoryAndroid(context, nativePointer);
    }

    @CalledByNative
    boolean enumerateDevices(Context context) {
        assert (!this.mIsEnumeratingDevices);
        this.mIsEnumeratingDevices = true;
        HashMap devices = this.mUsbManager.getDeviceList();
        if (devices.isEmpty()) {
            this.mIsEnumeratingDevices = false;
            return false;
        }
        for (UsbDevice device : devices.values()) {
            this.requestDevicePermissionIfNecessary(context, device);
        }
        return !this.mRequestedDevices.isEmpty();
    }

    private void requestDevicePermissionIfNecessary(Context context, UsbDevice device) {
        for (UsbDevice d : this.mRequestedDevices) {
            if (d.getDeviceId() != device.getDeviceId()) continue;
            return;
        }
        for (int i = 0; i < device.getInterfaceCount(); ++i) {
            UsbInterface iface = device.getInterface(i);
            if (iface.getInterfaceClass() != 1 || iface.getInterfaceSubclass() != 3) continue;
            this.mUsbManager.requestPermission(device, PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0));
            this.mRequestedDevices.add(device);
            break;
        }
    }

    private void onUsbDeviceDetached(UsbDevice device) {
        for (UsbDevice usbDevice : this.mRequestedDevices) {
            if (usbDevice.getDeviceId() != device.getDeviceId()) continue;
            this.mRequestedDevices.remove(usbDevice);
            break;
        }
        for (int i = 0; i < this.mDevices.size(); ++i) {
            UsbMidiDeviceAndroid midiDevice = this.mDevices.get(i);
            if (midiDevice.isClosed() || midiDevice.getUsbDevice().getDeviceId() != device.getDeviceId()) continue;
            midiDevice.close();
            if (this.mIsEnumeratingDevices) {
                this.mDevices.remove(i);
                return;
            }
            if (this.mNativePointer != 0L) {
                UsbMidiDeviceFactoryAndroid.nativeOnUsbMidiDeviceDetached(this.mNativePointer, i);
            }
            return;
        }
    }

    private void onUsbDevicePermissionRequestDone(Context context, Intent intent) {
        UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
        UsbMidiDeviceAndroid midiDevice = null;
        if (this.mRequestedDevices.contains(device)) {
            this.mRequestedDevices.remove(device);
            if (!intent.getBooleanExtra("permission", false)) {
                device = null;
            }
        } else {
            device = null;
        }
        if (device != null) {
            for (UsbMidiDeviceAndroid registered : this.mDevices) {
                if (registered.isClosed() || registered.getUsbDevice().getDeviceId() != device.getDeviceId()) continue;
                device = null;
                break;
            }
        }
        if (device != null) {
            midiDevice = new UsbMidiDeviceAndroid(this.mUsbManager, device);
            this.mDevices.add(midiDevice);
        }
        if (!this.mRequestedDevices.isEmpty()) {
            return;
        }
        if (this.mNativePointer == 0L) {
            return;
        }
        if (this.mIsEnumeratingDevices) {
            UsbMidiDeviceFactoryAndroid.nativeOnUsbMidiDeviceRequestDone(this.mNativePointer, this.mDevices.toArray());
            this.mIsEnumeratingDevices = false;
        } else if (midiDevice != null) {
            UsbMidiDeviceFactoryAndroid.nativeOnUsbMidiDeviceAttached(this.mNativePointer, midiDevice);
        }
    }

    @CalledByNative
    void close(Context context) {
        this.mNativePointer = 0L;
        context.unregisterReceiver(this.mReceiver);
    }

    private static native void nativeOnUsbMidiDeviceRequestDone(long var0, Object[] var2);

    private static native void nativeOnUsbMidiDeviceAttached(long var0, Object var2);

    private static native void nativeOnUsbMidiDeviceDetached(long var0, int var2);
}

