/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.bindings;

import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.system.AsyncWaiter;
import org.chromium.mojo.system.Handle;

public class BindingsHelper {
    public static final int ALIGNMENT = 8;
    public static final int SERIALIZED_HANDLE_SIZE = 4;
    public static final int SERIALIZED_INTERFACE_SIZE = 8;
    public static final int POINTER_SIZE = 8;
    public static final int UNION_SIZE = 16;
    public static final DataHeader MAP_STRUCT_HEADER = new DataHeader(24, 0);
    public static final int UNSPECIFIED_ARRAY_LENGTH = -1;
    public static final int NOTHING_NULLABLE = 0;
    public static final int ARRAY_NULLABLE = 1;
    public static final int ELEMENT_NULLABLE = 2;

    public static boolean isArrayNullable(int arrayNullability) {
        return (arrayNullability & 1) > 0;
    }

    public static boolean isElementNullable(int arrayNullability) {
        return (arrayNullability & 2) > 0;
    }

    public static int align(int size) {
        return size + 8 - 1 & 0xFFFFFFF8;
    }

    public static long align(long size) {
        return size + 8L - 1L & 0xFFFFFFFFFFFFFFF8L;
    }

    public static int utf8StringSizeInBytes(String s) {
        int res = 0;
        for (int i = 0; i < s.length(); ++i) {
            int c;
            int codepoint = c = s.charAt(i);
            if (BindingsHelper.isSurrogate((char)c)) {
                char c2 = s.charAt(++i);
                codepoint = Character.toCodePoint((char)c, c2);
            }
            ++res;
            if (codepoint <= 127) continue;
            ++res;
            if (codepoint <= 2047) continue;
            ++res;
            if (codepoint <= 65535) continue;
            ++res;
            if (codepoint <= 0x1FFFFF) continue;
            ++res;
            if (codepoint <= 0x3FFFFFF) continue;
            ++res;
        }
        return res;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static int hashCode(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public static int hashCode(boolean o) {
        return o ? 1231 : 1237;
    }

    public static int hashCode(long o) {
        return (int)(o ^ o >>> 32);
    }

    public static int hashCode(float o) {
        return Float.floatToIntBits(o);
    }

    public static int hashCode(double o) {
        return BindingsHelper.hashCode(Double.doubleToLongBits(o));
    }

    public static int hashCode(int o) {
        return o;
    }

    private static boolean isSurrogate(char c) {
        return c >= '\ud800' && c < '\ue000';
    }

    static AsyncWaiter getDefaultAsyncWaiterForHandle(Handle handle) {
        if (handle.getCore() != null) {
            return handle.getCore().getDefaultAsyncWaiter();
        }
        return null;
    }
}

