/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.bindings;

import java.io.Closeable;
import org.chromium.mojo.bindings.AutoCloseableRouter;
import org.chromium.mojo.bindings.Callbacks;
import org.chromium.mojo.bindings.ConnectionErrorHandler;
import org.chromium.mojo.bindings.DelegatingConnectionErrorHandler;
import org.chromium.mojo.bindings.HandleOwner;
import org.chromium.mojo.bindings.InterfaceControlMessagesHelper;
import org.chromium.mojo.bindings.InterfaceRequest;
import org.chromium.mojo.bindings.MessageReceiverWithResponder;
import org.chromium.mojo.bindings.QueryVersion;
import org.chromium.mojo.bindings.RequireVersion;
import org.chromium.mojo.bindings.Router;
import org.chromium.mojo.bindings.RouterImpl;
import org.chromium.mojo.bindings.RunMessageParams;
import org.chromium.mojo.bindings.RunOrClosePipeMessageParams;
import org.chromium.mojo.bindings.RunResponseMessageParams;
import org.chromium.mojo.system.Core;
import org.chromium.mojo.system.MessagePipeHandle;
import org.chromium.mojo.system.MojoException;
import org.chromium.mojo.system.Pair;

public interface Interface
extends ConnectionErrorHandler,
Closeable {
    @Override
    public void close();

    public static abstract class Manager<I extends Interface, P extends Proxy> {
        public abstract String getName();

        public abstract int getVersion();

        public void bind(I impl, MessagePipeHandle handle) {
            RouterImpl router = new RouterImpl(handle);
            this.bind(handle.getCore(), impl, router);
            router.start();
        }

        public final void bind(I impl, InterfaceRequest<I> request) {
            this.bind(impl, request.passHandle());
        }

        public final P attachProxy(MessagePipeHandle handle, int version) {
            RouterImpl router = new RouterImpl(handle);
            P proxy = this.attachProxy(handle.getCore(), router);
            DelegatingConnectionErrorHandler handlers = new DelegatingConnectionErrorHandler();
            handlers.addConnectionErrorHandler((ConnectionErrorHandler)proxy);
            router.setErrorHandler(handlers);
            router.start();
            ((AbstractProxy.HandlerImpl)proxy.getProxyHandler()).setVersion(version);
            return proxy;
        }

        public final Pair<P, InterfaceRequest<I>> getInterfaceRequest(Core core) {
            Pair<MessagePipeHandle, MessagePipeHandle> handles = core.createMessagePipe(null);
            P proxy = this.attachProxy((MessagePipeHandle)handles.first, 0);
            return Pair.create(proxy, new InterfaceRequest((MessagePipeHandle)handles.second));
        }

        public final InterfaceRequest<I> asInterfaceRequest(MessagePipeHandle handle) {
            return new InterfaceRequest(handle);
        }

        final void bind(Core core, I impl, Router router) {
            router.setErrorHandler((ConnectionErrorHandler)impl);
            router.setIncomingMessageReceiver(this.buildStub(core, impl));
        }

        final P attachProxy(Core core, Router router) {
            return this.buildProxy(core, new AutoCloseableRouter(core, router));
        }

        protected abstract I[] buildArray(int var1);

        protected abstract Stub<I> buildStub(Core var1, I var2);

        protected abstract P buildProxy(Core var1, MessageReceiverWithResponder var2);
    }

    public static abstract class Stub<I extends Interface>
    implements MessageReceiverWithResponder {
        private final Core mCore;
        private final I mImpl;

        public Stub(Core core, I impl) {
            this.mCore = core;
            this.mImpl = impl;
        }

        protected Core getCore() {
            return this.mCore;
        }

        protected I getImpl() {
            return this.mImpl;
        }

        @Override
        public void close() {
            this.mImpl.close();
        }
    }

    public static abstract class AbstractProxy
    implements Proxy {
        private final HandlerImpl mHandler;

        protected AbstractProxy(Core core, MessageReceiverWithResponder messageReceiver) {
            this.mHandler = new HandlerImpl(core, messageReceiver);
        }

        @Override
        public void close() {
            this.mHandler.close();
        }

        @Override
        public HandlerImpl getProxyHandler() {
            return this.mHandler;
        }

        @Override
        public void onConnectionError(MojoException e) {
            this.mHandler.onConnectionError(e);
        }

        protected static class HandlerImpl
        implements Proxy.Handler,
        ConnectionErrorHandler {
            private final Core mCore;
            private final MessageReceiverWithResponder mMessageReceiver;
            private ConnectionErrorHandler mErrorHandler = null;
            private int mVersion = 0;

            protected HandlerImpl(Core core, MessageReceiverWithResponder messageReceiver) {
                this.mCore = core;
                this.mMessageReceiver = messageReceiver;
            }

            void setVersion(int version) {
                this.mVersion = version;
            }

            public MessageReceiverWithResponder getMessageReceiver() {
                return this.mMessageReceiver;
            }

            public Core getCore() {
                return this.mCore;
            }

            @Override
            public void setErrorHandler(ConnectionErrorHandler errorHandler) {
                this.mErrorHandler = errorHandler;
            }

            @Override
            public void onConnectionError(MojoException e) {
                if (this.mErrorHandler != null) {
                    this.mErrorHandler.onConnectionError(e);
                }
            }

            @Override
            public void close() {
                this.mMessageReceiver.close();
            }

            @Override
            public MessagePipeHandle passHandle() {
                HandleOwner handleOwner = (HandleOwner)((Object)this.mMessageReceiver);
                return (MessagePipeHandle)handleOwner.passHandle();
            }

            @Override
            public int getVersion() {
                return this.mVersion;
            }

            @Override
            public void queryVersion(final Callbacks.Callback1<Integer> callback) {
                RunMessageParams message = new RunMessageParams();
                message.reserved0 = 16;
                message.reserved1 = 0;
                message.queryVersion = new QueryVersion();
                InterfaceControlMessagesHelper.sendRunMessage(this.getCore(), this.mMessageReceiver, message, new Callbacks.Callback1<RunResponseMessageParams>(){

                    @Override
                    public void call(RunResponseMessageParams response) {
                        HandlerImpl.this.mVersion = response.queryVersionResult.version;
                        callback.call(HandlerImpl.this.mVersion);
                    }
                });
            }

            @Override
            public void requireVersion(int version) {
                if (this.mVersion >= version) {
                    return;
                }
                this.mVersion = version;
                RunOrClosePipeMessageParams message = new RunOrClosePipeMessageParams();
                message.reserved0 = 16;
                message.reserved1 = 0;
                message.requireVersion = new RequireVersion();
                message.requireVersion.version = version;
                InterfaceControlMessagesHelper.sendRunOrClosePipeMessage(this.getCore(), this.mMessageReceiver, message);
            }
        }
    }

    public static interface Proxy
    extends Interface {
        public Handler getProxyHandler();

        public static interface Handler
        extends Closeable {
            public void setErrorHandler(ConnectionErrorHandler var1);

            public MessagePipeHandle passHandle();

            public int getVersion();

            public void queryVersion(Callbacks.Callback1<Integer> var1);

            public void requireVersion(int var1);
        }
    }
}

