/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.bindings;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;

public class ServiceMessage
extends Message {
    private final MessageHeader mHeader;
    private Message mPayload;

    public ServiceMessage(Message baseMessage, MessageHeader header) {
        super(baseMessage.getData(), baseMessage.getHandles());
        assert (header.equals(new MessageHeader(baseMessage)));
        this.mHeader = header;
    }

    ServiceMessage(Message baseMessage) {
        this(baseMessage, new MessageHeader(baseMessage));
    }

    @Override
    public ServiceMessage asServiceMessage() {
        return this;
    }

    public MessageHeader getHeader() {
        return this.mHeader;
    }

    public Message getPayload() {
        if (this.mPayload == null) {
            ByteBuffer truncatedBuffer = ((ByteBuffer)this.getData().position(this.getHeader().getSize())).slice();
            truncatedBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.mPayload = new Message(truncatedBuffer, this.getHandles());
        }
        return this.mPayload;
    }

    void setRequestId(long requestId) {
        this.mHeader.setRequestId(this.getData(), requestId);
    }
}

