/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.bindings;

import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.MessageHeader;
import org.chromium.mojo.bindings.ServiceMessage;
import org.chromium.mojo.system.Core;

public abstract class Struct {
    private final int mEncodedBaseSize;
    private final int mVersion;

    protected Struct(int encodedBaseSize, int version) {
        this.mEncodedBaseSize = encodedBaseSize;
        this.mVersion = version;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public Message serialize(Core core) {
        Encoder encoder = new Encoder(core, this.mEncodedBaseSize);
        this.encode(encoder);
        return encoder.getMessage();
    }

    public ServiceMessage serializeWithHeader(Core core, MessageHeader header) {
        Encoder encoder = new Encoder(core, this.mEncodedBaseSize + header.getSize());
        header.encode(encoder);
        this.encode(encoder);
        return new ServiceMessage(encoder.getMessage(), header);
    }

    protected abstract void encode(Encoder var1);
}

