/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.security.KeyChain;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLConnection;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.CalledByNativeUnchecked;
import org.chromium.net.AndroidCertVerifyResult;
import org.chromium.net.X509Util;

class AndroidNetworkLibrary {
    private static final String TAG = "AndroidNetworkLibrary";

    AndroidNetworkLibrary() {
    }

    @CalledByNative
    public static boolean storeKeyPair(Context context, byte[] publicKey, byte[] privateKey) {
        try {
            Intent intent = KeyChain.createInstallIntent();
            intent.putExtra("PKEY", privateKey);
            intent.putExtra("KEY", publicKey);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return true;
        }
        catch (ActivityNotFoundException e) {
            Log.w((String)TAG, (String)("could not store key pair: " + (Object)((Object)e)));
            return false;
        }
    }

    @CalledByNative
    public static boolean storeCertificate(Context context, int certType, byte[] data) {
        try {
            Intent intent = KeyChain.createInstallIntent();
            intent.addFlags(0x10000000);
            switch (certType) {
                case 1: 
                case 2: {
                    intent.putExtra("CERT", data);
                    break;
                }
                case 3: {
                    intent.putExtra("PKCS12", data);
                    break;
                }
                default: {
                    Log.w((String)TAG, (String)("invalid certificate type: " + certType));
                    return false;
                }
            }
            context.startActivity(intent);
            return true;
        }
        catch (ActivityNotFoundException e) {
            Log.w((String)TAG, (String)("could not store crypto file: " + (Object)((Object)e)));
            return false;
        }
    }

    @CalledByNative
    public static String getMimeTypeFromExtension(String extension) {
        return URLConnection.guessContentTypeFromName("foo." + extension);
    }

    @CalledByNative
    public static boolean haveOnlyLoopbackAddresses() {
        Enumeration<NetworkInterface> list = null;
        try {
            list = NetworkInterface.getNetworkInterfaces();
            if (list == null) {
                return false;
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("could not get network interfaces: " + e));
            return false;
        }
        while (list.hasMoreElements()) {
            NetworkInterface netIf = list.nextElement();
            try {
                if (!netIf.isUp() || netIf.isLoopback()) continue;
                return false;
            }
            catch (SocketException e) {
            }
        }
        return true;
    }

    @CalledByNative
    public static AndroidCertVerifyResult verifyServerCertificates(byte[][] certChain, String authType, String host) {
        try {
            return X509Util.verifyServerCertificates(certChain, authType, host);
        }
        catch (KeyStoreException e) {
            return new AndroidCertVerifyResult(-1);
        }
        catch (NoSuchAlgorithmException e) {
            return new AndroidCertVerifyResult(-1);
        }
        catch (IllegalArgumentException e) {
            return new AndroidCertVerifyResult(-1);
        }
    }

    @CalledByNativeUnchecked
    public static void addTestRootCertificate(byte[] rootCert) throws CertificateException, KeyStoreException, NoSuchAlgorithmException {
        X509Util.addTestRootCertificate(rootCert);
    }

    @CalledByNativeUnchecked
    public static void clearTestRootCertificates() throws NoSuchAlgorithmException, CertificateException, KeyStoreException {
        X509Util.clearTestRootCertificates();
    }

    @CalledByNative
    private static String getNetworkCountryIso(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager == null) {
            return "";
        }
        return telephonyManager.getNetworkCountryIso();
    }

    @CalledByNative
    private static String getNetworkOperator(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager == null) {
            return "";
        }
        return telephonyManager.getNetworkOperator();
    }

    @CalledByNative
    private static String getSimOperator(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager == null) {
            return "";
        }
        return telephonyManager.getSimOperator();
    }

    @CalledByNative
    private static boolean getIsRoaming(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return false;
        }
        return networkInfo.isRoaming();
    }
}

