/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.util.Log;
import java.io.IOException;
import java.util.Arrays;
import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.metrics.RecordHistogram;
import org.chromium.net.NetworkChangeNotifier;

public class NetworkChangeNotifierAutoDetect
extends BroadcastReceiver {
    private static final String TAG = "NetworkChangeNotifierAutoDetect";
    private static final int UNKNOWN_LINK_SPEED = -1;
    private final NetworkConnectivityIntentFilter mIntentFilter;
    private final Observer mObserver;
    private final Context mContext;
    private final RegistrationPolicy mRegistrationPolicy;
    private ConnectivityManagerDelegate mConnectivityManagerDelegate;
    private WifiManagerDelegate mWifiManagerDelegate;
    private final MyNetworkCallback mNetworkCallback;
    private final NetworkRequest mNetworkRequest;
    private boolean mRegistered;
    private int mConnectionType;
    private String mWifiSSID;
    private double mMaxBandwidthMbps;
    private int mMaxBandwidthConnectionType;

    @TargetApi(value=21)
    public NetworkChangeNotifierAutoDetect(Observer observer, Context context, RegistrationPolicy policy) {
        ThreadUtils.assertOnUiThread();
        this.mObserver = observer;
        this.mContext = context.getApplicationContext();
        this.mConnectivityManagerDelegate = new ConnectivityManagerDelegate(context);
        this.mWifiManagerDelegate = new WifiManagerDelegate(context);
        if (Build.VERSION.SDK_INT >= 21) {
            this.mNetworkCallback = new MyNetworkCallback();
            this.mNetworkRequest = new NetworkRequest.Builder().addCapability(12).removeCapability(15).build();
        } else {
            this.mNetworkCallback = null;
            this.mNetworkRequest = null;
        }
        NetworkState networkState = this.mConnectivityManagerDelegate.getNetworkState();
        this.mConnectionType = this.getCurrentConnectionType(networkState);
        this.mWifiSSID = this.getCurrentWifiSSID(networkState);
        this.mMaxBandwidthMbps = this.getCurrentMaxBandwidthInMbps(networkState);
        this.mMaxBandwidthConnectionType = this.mConnectionType;
        this.mIntentFilter = new NetworkConnectivityIntentFilter(this.mWifiManagerDelegate.getHasWifiPermission());
        this.mRegistrationPolicy = policy;
        this.mRegistrationPolicy.init(this);
    }

    void setConnectivityManagerDelegateForTests(ConnectivityManagerDelegate delegate) {
        this.mConnectivityManagerDelegate = delegate;
    }

    void setWifiManagerDelegateForTests(WifiManagerDelegate delegate) {
        this.mWifiManagerDelegate = delegate;
    }

    @VisibleForTesting
    RegistrationPolicy getRegistrationPolicy() {
        return this.mRegistrationPolicy;
    }

    @VisibleForTesting
    boolean isReceiverRegisteredForTesting() {
        return this.mRegistered;
    }

    public void destroy() {
        this.mRegistrationPolicy.destroy();
        this.unregister();
    }

    public void register() {
        if (this.mRegistered) {
            return;
        }
        NetworkState networkState = this.getCurrentNetworkState();
        this.connectionTypeChanged(networkState);
        this.maxBandwidthChanged(networkState);
        this.mContext.registerReceiver((BroadcastReceiver)this, (IntentFilter)this.mIntentFilter);
        this.mRegistered = true;
        if (this.mNetworkCallback != null) {
            this.mNetworkCallback.initializeVpnInPlace();
            this.mConnectivityManagerDelegate.registerNetworkCallback(this.mNetworkRequest, this.mNetworkCallback);
            Network[] networks = NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(this.mConnectivityManagerDelegate, null);
            int[] netIds = new int[networks.length];
            for (int i = 0; i < networks.length; ++i) {
                netIds[i] = NetworkChangeNotifierAutoDetect.networkToNetId(networks[i]);
            }
            this.mObserver.purgeActiveNetworkList(netIds);
        }
    }

    public void unregister() {
        if (!this.mRegistered) {
            return;
        }
        this.mContext.unregisterReceiver((BroadcastReceiver)this);
        this.mRegistered = false;
        if (this.mNetworkCallback != null) {
            this.mConnectivityManagerDelegate.unregisterNetworkCallback(this.mNetworkCallback);
        }
    }

    public NetworkState getCurrentNetworkState() {
        return this.mConnectivityManagerDelegate.getNetworkState();
    }

    @TargetApi(value=21)
    private static Network[] getAllNetworksFiltered(ConnectivityManagerDelegate connectivityManagerDelegate, Network ignoreNetwork) {
        Network[] networks = connectivityManagerDelegate.getAllNetworksUnfiltered();
        int filteredIndex = 0;
        for (Network network : networks) {
            NetworkCapabilities capabilities;
            if (network.equals((Object)ignoreNetwork) || (capabilities = connectivityManagerDelegate.getNetworkCapabilities(network)) == null || !capabilities.hasCapability(12)) continue;
            if (capabilities.hasTransport(4)) {
                if (!connectivityManagerDelegate.vpnAccessible(network)) continue;
                return new Network[]{network};
            }
            networks[filteredIndex++] = network;
        }
        return Arrays.copyOf(networks, filteredIndex);
    }

    public int[] getNetworksAndTypes() {
        if (Build.VERSION.SDK_INT < 21) {
            return new int[0];
        }
        Network[] networks = NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(this.mConnectivityManagerDelegate, null);
        int[] networksAndTypes = new int[networks.length * 2];
        int index = 0;
        for (Network network : networks) {
            networksAndTypes[index++] = NetworkChangeNotifierAutoDetect.networkToNetId(network);
            networksAndTypes[index++] = this.getCurrentConnectionType(this.mConnectivityManagerDelegate.getNetworkState(network));
        }
        return networksAndTypes;
    }

    public int getDefaultNetId() {
        if (Build.VERSION.SDK_INT < 21) {
            return -1;
        }
        return this.mConnectivityManagerDelegate.getDefaultNetId();
    }

    public int getCurrentConnectionType(NetworkState networkState) {
        if (!networkState.isConnected()) {
            return 6;
        }
        switch (networkState.getNetworkType()) {
            case 9: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 7;
            }
            case 0: {
                switch (networkState.getNetworkSubType()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return 3;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return 4;
                    }
                    case 13: {
                        return 5;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    public int getCurrentConnectionSubtype(NetworkState networkState) {
        if (!networkState.isConnected()) {
            return 1;
        }
        switch (networkState.getNetworkType()) {
            case 1: 
            case 6: 
            case 7: 
            case 9: {
                return 0;
            }
            case 0: {
                switch (networkState.getNetworkSubType()) {
                    case 1: {
                        return 7;
                    }
                    case 2: {
                        return 8;
                    }
                    case 4: {
                        return 5;
                    }
                    case 7: {
                        return 6;
                    }
                    case 11: {
                        return 4;
                    }
                    case 3: {
                        return 9;
                    }
                    case 5: {
                        return 10;
                    }
                    case 6: {
                        return 11;
                    }
                    case 8: {
                        return 14;
                    }
                    case 9: {
                        return 15;
                    }
                    case 10: {
                        return 12;
                    }
                    case 12: {
                        return 13;
                    }
                    case 14: {
                        return 16;
                    }
                    case 15: {
                        return 17;
                    }
                    case 13: {
                        return 18;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    public double getCurrentMaxBandwidthInMbps(NetworkState networkState) {
        int link_speed;
        if (this.getCurrentConnectionType(networkState) == 2 && (link_speed = this.mWifiManagerDelegate.getLinkSpeedInMbps()) != -1) {
            return link_speed;
        }
        return NetworkChangeNotifier.getMaxBandwidthForConnectionSubtype(this.getCurrentConnectionSubtype(networkState));
    }

    private String getCurrentWifiSSID(NetworkState networkState) {
        if (this.getCurrentConnectionType(networkState) != 2) {
            return "";
        }
        return this.mWifiManagerDelegate.getWifiSSID();
    }

    public void onReceive(Context context, Intent intent) {
        NetworkState networkState = this.getCurrentNetworkState();
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            this.connectionTypeChanged(networkState);
            this.maxBandwidthChanged(networkState);
        } else if ("android.net.wifi.RSSI_CHANGED".equals(intent.getAction())) {
            this.maxBandwidthChanged(networkState);
        }
    }

    private void connectionTypeChanged(NetworkState networkState) {
        int newConnectionType = this.getCurrentConnectionType(networkState);
        String newWifiSSID = this.getCurrentWifiSSID(networkState);
        if (newConnectionType == this.mConnectionType && newWifiSSID.equals(this.mWifiSSID)) {
            return;
        }
        this.mConnectionType = newConnectionType;
        this.mWifiSSID = newWifiSSID;
        Log.d((String)TAG, (String)("Network connectivity changed, type is: " + this.mConnectionType));
        this.mObserver.onConnectionTypeChanged(newConnectionType);
    }

    private void maxBandwidthChanged(NetworkState networkState) {
        double newMaxBandwidthMbps = this.getCurrentMaxBandwidthInMbps(networkState);
        if (newMaxBandwidthMbps == this.mMaxBandwidthMbps && this.mConnectionType == this.mMaxBandwidthConnectionType) {
            return;
        }
        this.mMaxBandwidthMbps = newMaxBandwidthMbps;
        this.mMaxBandwidthConnectionType = this.mConnectionType;
        this.mObserver.onMaxBandwidthChanged(newMaxBandwidthMbps);
    }

    @TargetApi(value=21)
    @VisibleForTesting
    static int networkToNetId(Network network) {
        return Integer.parseInt(network.toString());
    }

    private static class NetworkConnectivityIntentFilter
    extends IntentFilter {
        NetworkConnectivityIntentFilter(boolean monitorRSSI) {
            this.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            if (monitorRSSI) {
                this.addAction("android.net.wifi.RSSI_CHANGED");
            }
        }
    }

    public static interface Observer {
        public void onConnectionTypeChanged(int var1);

        public void onMaxBandwidthChanged(double var1);

        public void onNetworkConnect(int var1, int var2);

        public void onNetworkSoonToDisconnect(int var1);

        public void onNetworkDisconnect(int var1);

        public void purgeActiveNetworkList(int[] var1);
    }

    public static abstract class RegistrationPolicy {
        private NetworkChangeNotifierAutoDetect mNotifier;

        protected final void register() {
            assert (this.mNotifier != null);
            this.mNotifier.register();
        }

        protected final void unregister() {
            assert (this.mNotifier != null);
            this.mNotifier.unregister();
        }

        protected void init(NetworkChangeNotifierAutoDetect notifier) {
            this.mNotifier = notifier;
        }

        protected abstract void destroy();
    }

    @TargetApi(value=21)
    private class MyNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private Network mVpnInPlace = null;

        private MyNetworkCallback() {
        }

        void initializeVpnInPlace() {
            NetworkCapabilities capabilities;
            Network[] networks = NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate, null);
            this.mVpnInPlace = null;
            if (networks.length == 1 && (capabilities = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getNetworkCapabilities(networks[0])) != null && capabilities.hasTransport(4)) {
                this.mVpnInPlace = networks[0];
            }
        }

        private boolean ignoreNetworkDueToVpn(Network network) {
            return this.mVpnInPlace != null && !this.mVpnInPlace.equals((Object)network);
        }

        private boolean ignoreConnectedInaccessibleVpn(Network network, NetworkCapabilities capabilities) {
            if (capabilities == null) {
                capabilities = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getNetworkCapabilities(network);
            }
            return capabilities == null || capabilities.hasTransport(4) && !NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.vpnAccessible(network);
        }

        private boolean ignoreConnectedNetwork(Network network, NetworkCapabilities capabilities) {
            return this.ignoreNetworkDueToVpn(network) || this.ignoreConnectedInaccessibleVpn(network, capabilities);
        }

        public void onAvailable(Network network) {
            NetworkCapabilities capabilities = NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getNetworkCapabilities(network);
            if (this.ignoreConnectedNetwork(network, capabilities)) {
                return;
            }
            final boolean makeVpnDefault = capabilities.hasTransport(4);
            if (makeVpnDefault) {
                this.mVpnInPlace = network;
            }
            final int netId = NetworkChangeNotifierAutoDetect.networkToNetId(network);
            final int connectionType = NetworkChangeNotifierAutoDetect.this.getCurrentConnectionType(NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getNetworkState(network));
            ThreadUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    NetworkChangeNotifierAutoDetect.this.mObserver.onNetworkConnect(netId, connectionType);
                    if (makeVpnDefault) {
                        NetworkChangeNotifierAutoDetect.this.mObserver.onConnectionTypeChanged(connectionType);
                        NetworkChangeNotifierAutoDetect.this.mObserver.purgeActiveNetworkList(new int[]{netId});
                    }
                }
            });
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            if (this.ignoreConnectedNetwork(network, networkCapabilities)) {
                return;
            }
            final int netId = NetworkChangeNotifierAutoDetect.networkToNetId(network);
            final int connectionType = NetworkChangeNotifierAutoDetect.this.getCurrentConnectionType(NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getNetworkState(network));
            ThreadUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    NetworkChangeNotifierAutoDetect.this.mObserver.onNetworkConnect(netId, connectionType);
                }
            });
        }

        public void onLosing(Network network, int maxMsToLive) {
            if (this.ignoreConnectedNetwork(network, null)) {
                return;
            }
            final int netId = NetworkChangeNotifierAutoDetect.networkToNetId(network);
            ThreadUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    NetworkChangeNotifierAutoDetect.this.mObserver.onNetworkSoonToDisconnect(netId);
                }
            });
        }

        public void onLost(final Network network) {
            if (this.ignoreNetworkDueToVpn(network)) {
                return;
            }
            ThreadUtils.postOnUiThread(new Runnable(){

                @Override
                public void run() {
                    NetworkChangeNotifierAutoDetect.this.mObserver.onNetworkDisconnect(NetworkChangeNotifierAutoDetect.networkToNetId(network));
                }
            });
            if (this.mVpnInPlace != null) {
                assert (network.equals((Object)this.mVpnInPlace));
                this.mVpnInPlace = null;
                for (Network newNetwork : NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate, network)) {
                    this.onAvailable(newNetwork);
                }
                final int newConnectionType = NetworkChangeNotifierAutoDetect.this.getCurrentConnectionType(NetworkChangeNotifierAutoDetect.this.mConnectivityManagerDelegate.getNetworkState());
                ThreadUtils.postOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        NetworkChangeNotifierAutoDetect.this.mObserver.onConnectionTypeChanged(newConnectionType);
                    }
                });
            }
        }
    }

    static class WifiManagerDelegate {
        private final Context mContext;
        private final WifiManager mWifiManager;
        private final boolean mHasWifiPermission;

        WifiManagerDelegate(Context context) {
            this.mContext = context;
            this.mHasWifiPermission = this.mContext.getPackageManager().checkPermission("android.permission.ACCESS_WIFI_STATE", this.mContext.getPackageName()) == 0;
            this.mWifiManager = this.mHasWifiPermission ? (WifiManager)this.mContext.getSystemService("wifi") : null;
        }

        WifiManagerDelegate() {
            this.mContext = null;
            this.mWifiManager = null;
            this.mHasWifiPermission = false;
        }

        String getWifiSSID() {
            String ssid;
            WifiInfo wifiInfo;
            Intent intent = this.mContext.registerReceiver(null, new IntentFilter("android.net.wifi.STATE_CHANGE"));
            if (intent != null && (wifiInfo = (WifiInfo)intent.getParcelableExtra("wifiInfo")) != null && (ssid = wifiInfo.getSSID()) != null) {
                return ssid;
            }
            return "";
        }

        private WifiInfo getWifiInfo() {
            try {
                WifiInfo wifiInfo = this.mWifiManager.getConnectionInfo();
                RecordHistogram.recordBooleanHistogram("NCN.getWifiInfo1stSuccess", true);
                return wifiInfo;
            }
            catch (NullPointerException firstException) {
                RecordHistogram.recordBooleanHistogram("NCN.getWifiInfo1stSuccess", false);
                try {
                    WifiInfo wifiInfo = this.mWifiManager.getConnectionInfo();
                    RecordHistogram.recordBooleanHistogram("NCN.getWifiInfo2ndSuccess", true);
                    return wifiInfo;
                }
                catch (NullPointerException secondException) {
                    RecordHistogram.recordBooleanHistogram("NCN.getWifiInfo2ndSuccess", false);
                    throw secondException;
                }
            }
        }

        int getLinkSpeedInMbps() {
            if (!this.mHasWifiPermission || this.mWifiManager == null) {
                return -1;
            }
            WifiInfo wifiInfo = this.getWifiInfo();
            if (wifiInfo == null) {
                return -1;
            }
            return wifiInfo.getLinkSpeed();
        }

        boolean getHasWifiPermission() {
            return this.mHasWifiPermission;
        }
    }

    static class ConnectivityManagerDelegate {
        private final ConnectivityManager mConnectivityManager;

        ConnectivityManagerDelegate(Context context) {
            this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        }

        ConnectivityManagerDelegate() {
            this.mConnectivityManager = null;
        }

        NetworkState getNetworkState() {
            return this.getNetworkState(this.mConnectivityManager.getActiveNetworkInfo());
        }

        private NetworkInfo getNetworkInfo(Network network) {
            try {
                NetworkInfo networkInfo = this.mConnectivityManager.getNetworkInfo(network);
                RecordHistogram.recordBooleanHistogram("NCN.getNetInfo1stSuccess", true);
                return networkInfo;
            }
            catch (NullPointerException firstException) {
                RecordHistogram.recordBooleanHistogram("NCN.getNetInfo1stSuccess", false);
                try {
                    NetworkInfo networkInfo = this.mConnectivityManager.getNetworkInfo(network);
                    RecordHistogram.recordBooleanHistogram("NCN.getNetInfo2ndSuccess", true);
                    return networkInfo;
                }
                catch (NullPointerException secondException) {
                    RecordHistogram.recordBooleanHistogram("NCN.getNetInfo2ndSuccess", false);
                    throw secondException;
                }
            }
        }

        @TargetApi(value=21)
        NetworkState getNetworkState(Network network) {
            NetworkInfo networkInfo = this.getNetworkInfo(network);
            if (networkInfo != null && networkInfo.getType() == 17) {
                return this.getNetworkState();
            }
            return this.getNetworkState(networkInfo);
        }

        NetworkState getNetworkState(NetworkInfo networkInfo) {
            if (networkInfo == null || !networkInfo.isConnected()) {
                return new NetworkState(false, -1, -1);
            }
            return new NetworkState(true, networkInfo.getType(), networkInfo.getSubtype());
        }

        @TargetApi(value=21)
        @VisibleForTesting
        protected Network[] getAllNetworksUnfiltered() {
            return this.mConnectivityManager.getAllNetworks();
        }

        @TargetApi(value=21)
        @VisibleForTesting
        protected boolean vpnAccessible(Network network) {
            try {
                network.getSocketFactory().createSocket().close();
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }

        @TargetApi(value=21)
        @VisibleForTesting
        protected NetworkCapabilities getNetworkCapabilities(Network network) {
            return this.mConnectivityManager.getNetworkCapabilities(network);
        }

        @TargetApi(value=21)
        void registerNetworkCallback(NetworkRequest networkRequest, ConnectivityManager.NetworkCallback networkCallback) {
            this.mConnectivityManager.registerNetworkCallback(networkRequest, networkCallback);
        }

        @TargetApi(value=21)
        void unregisterNetworkCallback(ConnectivityManager.NetworkCallback networkCallback) {
            this.mConnectivityManager.unregisterNetworkCallback(networkCallback);
        }

        @TargetApi(value=21)
        int getDefaultNetId() {
            NetworkInfo defaultNetworkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            if (defaultNetworkInfo == null) {
                return -1;
            }
            Network[] networks = NetworkChangeNotifierAutoDetect.getAllNetworksFiltered(this, null);
            int defaultNetId = -1;
            for (Network network : networks) {
                NetworkInfo networkInfo = this.getNetworkInfo(network);
                if (networkInfo == null || networkInfo.getType() != defaultNetworkInfo.getType() && networkInfo.getType() != 17) continue;
                assert (defaultNetId == -1);
                defaultNetId = NetworkChangeNotifierAutoDetect.networkToNetId(network);
            }
            return defaultNetId;
        }
    }

    static class NetworkState {
        private final boolean mConnected;
        private final int mType;
        private final int mSubtype;

        public NetworkState(boolean connected, int type2, int subtype) {
            this.mConnected = connected;
            this.mType = type2;
            this.mSubtype = subtype;
        }

        public boolean isConnected() {
            return this.mConnected;
        }

        public int getNetworkType() {
            return this.mType;
        }

        public int getNetworkSubType() {
            return this.mSubtype;
        }
    }
}

