/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import org.chromium.base.ApplicationStatus;
import org.chromium.base.VisibleForTesting;
import org.chromium.net.NetworkChangeNotifierAutoDetect;

public class RegistrationPolicyApplicationStatus
extends NetworkChangeNotifierAutoDetect.RegistrationPolicy
implements ApplicationStatus.ApplicationStateListener {
    private boolean mDestroyed = false;

    @Override
    protected void init(NetworkChangeNotifierAutoDetect notifier) {
        super.init(notifier);
        ApplicationStatus.registerApplicationStateListener(this);
        this.onApplicationStateChange(this.getApplicationState());
    }

    @Override
    protected void destroy() {
        if (this.mDestroyed) {
            return;
        }
        ApplicationStatus.unregisterApplicationStateListener(this);
        this.mDestroyed = true;
    }

    @Override
    public void onApplicationStateChange(int newState) {
        if (newState == 1) {
            this.register();
        } else if (newState == 2) {
            this.unregister();
        }
    }

    @VisibleForTesting
    int getApplicationState() {
        return ApplicationStatus.getStateForApplication();
    }
}

