/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.SuppressFBWarnings;
import org.chromium.ui.R;
import org.chromium.ui.widget.Toast;

@JNINamespace(value="ui")
public class Clipboard {
    private final Context mContext;
    private final ClipboardManager mClipboardManager;

    public Clipboard(Context context) {
        this.mContext = context;
        this.mClipboardManager = (ClipboardManager)context.getSystemService("clipboard");
    }

    @CalledByNative
    private static Clipboard create(Context context) {
        return new Clipboard(context);
    }

    @CalledByNative
    private String getCoercedText() {
        CharSequence sequence;
        ClipData clip = this.mClipboardManager.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0 && (sequence = clip.getItemAt(0).coerceToText(this.mContext)) != null) {
            return sequence.toString();
        }
        return null;
    }

    @CalledByNative
    private String getHTMLText() {
        ClipData clip = this.mClipboardManager.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            return clip.getItemAt(0).getHtmlText();
        }
        return null;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
    @CalledByNative
    public void setText(String text) {
        this.setPrimaryClipNoException(ClipData.newPlainText((CharSequence)"text", (CharSequence)text));
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
    @CalledByNative
    private void setHTMLText(String html, String text) {
        this.setPrimaryClipNoException(ClipData.newHtmlText((CharSequence)"html", (CharSequence)text, (String)html));
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
    @CalledByNative
    private void clear() {
        this.setPrimaryClipNoException(ClipData.newPlainText(null, null));
    }

    private void setPrimaryClipNoException(ClipData clip) {
        try {
            this.mClipboardManager.setPrimaryClip(clip);
        }
        catch (Exception ex) {
            String text = this.mContext.getString(R.string.copy_to_clipboard_failure_message);
            Toast.makeText(this.mContext, text, 0).show();
        }
    }
}

