/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import android.content.res.Configuration;
import java.util.Locale;
import org.chromium.base.ApiCompatibilityUtils;
import org.chromium.base.ContextUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="l10n_util")
public class LocalizationUtils {
    public static final int UNKNOWN_DIRECTION = 0;
    public static final int RIGHT_TO_LEFT = 1;
    public static final int LEFT_TO_RIGHT = 2;
    private static Boolean sIsLayoutRtl;

    private LocalizationUtils() {
    }

    @CalledByNative
    private static Locale getJavaLocale(String language, String country, String variant) {
        return new Locale(language, country, variant);
    }

    @CalledByNative
    private static String getDisplayNameForLocale(Locale locale, Locale displayLocale) {
        return locale.getDisplayName(displayLocale);
    }

    @CalledByNative
    public static boolean isLayoutRtl() {
        if (sIsLayoutRtl == null) {
            Configuration configuration = ContextUtils.getApplicationContext().getResources().getConfiguration();
            sIsLayoutRtl = ApiCompatibilityUtils.getLayoutDirection(configuration) == 1;
        }
        return sIsLayoutRtl;
    }

    @VisibleForTesting
    public static void setRtlForTesting(boolean shouldBeRtl) {
        sIsLayoutRtl = shouldBeRtl;
    }

    public static int getFirstStrongCharacterDirection(String string2) {
        assert (string2 != null);
        return LocalizationUtils.nativeGetFirstStrongCharacterDirection(string2);
    }

    private static native int nativeGetFirstStrongCharacterDirection(String var0);
}

