/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import android.content.Context;
import android.view.InputDevice;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="ui")
public class TouchDevice {
    private TouchDevice() {
    }

    @CalledByNative
    private static int maxTouchPoints(Context context) {
        if (context.getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch.jazzhand")) {
            return 5;
        }
        if (context.getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch.distinct")) {
            return 2;
        }
        if (context.getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch")) {
            return 2;
        }
        if (context.getPackageManager().hasSystemFeature("android.hardware.touchscreen")) {
            return 1;
        }
        return 0;
    }

    @CalledByNative
    private static int availablePointerTypes(Context context) {
        int pointerTypesVal = 0;
        for (int deviceId : InputDevice.getDeviceIds()) {
            InputDevice inputDevice = InputDevice.getDevice((int)deviceId);
            if (inputDevice == null) continue;
            int sources = inputDevice.getSources();
            if (TouchDevice.hasSource(sources, 8194) || TouchDevice.hasSource(sources, 16386) || TouchDevice.hasSource(sources, 0x100008) || TouchDevice.hasSource(sources, 65540)) {
                pointerTypesVal |= 4;
                continue;
            }
            if (!TouchDevice.hasSource(sources, 4098)) continue;
            pointerTypesVal |= 2;
        }
        if (pointerTypesVal == 0) {
            pointerTypesVal = 1;
        }
        return pointerTypesVal;
    }

    @CalledByNative
    private static int availableHoverTypes(Context context) {
        int hoverTypesVal = 0;
        for (int deviceId : InputDevice.getDeviceIds()) {
            InputDevice inputDevice = InputDevice.getDevice((int)deviceId);
            if (inputDevice == null) continue;
            int sources = inputDevice.getSources();
            if (TouchDevice.hasSource(sources, 8194) || TouchDevice.hasSource(sources, 0x100008) || TouchDevice.hasSource(sources, 65540)) {
                hoverTypesVal |= 4;
                continue;
            }
            if (!TouchDevice.hasSource(sources, 16386) && !TouchDevice.hasSource(sources, 4098)) continue;
            hoverTypesVal |= 2;
        }
        if (hoverTypesVal == 0) {
            hoverTypesVal = 1;
        }
        return hoverTypesVal;
    }

    private static boolean hasSource(int sources, int inputDeviceSource) {
        return (sources & inputDeviceSource) == inputDeviceSource;
    }
}

