/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.picker;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.DatePicker;
import android.widget.TimePicker;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.chromium.base.VisibleForTesting;
import org.chromium.ui.R;
import org.chromium.ui.picker.DateDialogNormalizer;

public class DateTimePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
DatePicker.OnDateChangedListener,
TimePicker.OnTimeChangedListener {
    private final DatePicker mDatePicker;
    private final TimePicker mTimePicker;
    private final OnDateTimeSetListener mCallBack;
    private final long mMinTimeMillis;
    private final long mMaxTimeMillis;

    public DateTimePickerDialog(Context context, OnDateTimeSetListener callBack, int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minute, boolean is24HourView, double min, double max) {
        super(context, 0);
        this.mMinTimeMillis = (long)min;
        this.mMaxTimeMillis = (long)max;
        this.mCallBack = callBack;
        this.setButton(-1, context.getText(R.string.date_picker_dialog_set), this);
        this.setButton(-2, context.getText(0x1040000), null);
        this.setIcon(0);
        this.setTitle(context.getText(R.string.date_time_picker_dialog_title));
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.date_time_picker_dialog, null);
        this.setView(view);
        this.mDatePicker = (DatePicker)view.findViewById(R.id.date_picker);
        DateDialogNormalizer.normalize(this.mDatePicker, this, year, monthOfYear, dayOfMonth, this.mMinTimeMillis, this.mMaxTimeMillis);
        this.mTimePicker = (TimePicker)view.findViewById(R.id.time_picker);
        this.mTimePicker.setIs24HourView(Boolean.valueOf(is24HourView));
        DateTimePickerDialog.setHour(this.mTimePicker, hourOfDay);
        DateTimePickerDialog.setMinute(this.mTimePicker, minute);
        this.mTimePicker.setOnTimeChangedListener((TimePicker.OnTimeChangedListener)this);
        this.onTimeChanged(this.mTimePicker, DateTimePickerDialog.getHour(this.mTimePicker), DateTimePickerDialog.getMinute(this.mTimePicker));
    }

    public void onClick(DialogInterface dialog, int which) {
        this.tryNotifyDateTimeSet();
    }

    private void tryNotifyDateTimeSet() {
        if (this.mCallBack != null) {
            this.mDatePicker.clearFocus();
            this.mTimePicker.clearFocus();
            this.mCallBack.onDateTimeSet(this.mDatePicker, this.mTimePicker, this.mDatePicker.getYear(), this.mDatePicker.getMonth(), this.mDatePicker.getDayOfMonth(), DateTimePickerDialog.getHour(this.mTimePicker), DateTimePickerDialog.getMinute(this.mTimePicker));
        }
    }

    public void onDateChanged(DatePicker view, int year, int month, int day) {
        if (this.mTimePicker != null) {
            this.onTimeChanged(this.mTimePicker, DateTimePickerDialog.getHour(this.mTimePicker), DateTimePickerDialog.getMinute(this.mTimePicker));
        }
    }

    public void onTimeChanged(TimePicker view, int hourOfDay, int minute) {
        DateTimePickerDialog.onTimeChangedInternal(this.mDatePicker.getYear(), this.mDatePicker.getMonth(), this.mDatePicker.getDayOfMonth(), this.mTimePicker, this.mMinTimeMillis, this.mMaxTimeMillis);
    }

    @VisibleForTesting
    public static void onTimeChangedInternal(int year, int month, int day, TimePicker picker, long minTimeMillis, long maxTimeMillis) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        calendar.set(year, month, day, DateTimePickerDialog.getHour(picker), DateTimePickerDialog.getMinute(picker), 0);
        if (calendar.getTimeInMillis() < minTimeMillis) {
            calendar.setTimeInMillis(minTimeMillis);
        } else if (calendar.getTimeInMillis() > maxTimeMillis) {
            calendar.setTimeInMillis(maxTimeMillis);
        }
        DateTimePickerDialog.setHour(picker, calendar.get(11));
        DateTimePickerDialog.setMinute(picker, calendar.get(12));
    }

    public void updateDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minutOfHour) {
        this.mDatePicker.updateDate(year, monthOfYear, dayOfMonth);
        DateTimePickerDialog.setHour(this.mTimePicker, hourOfDay);
        DateTimePickerDialog.setMinute(this.mTimePicker, minutOfHour);
    }

    private static void setHour(TimePicker picker, int hour) {
        picker.setCurrentHour(Integer.valueOf(hour));
    }

    private static void setMinute(TimePicker picker, int minute) {
        picker.setCurrentMinute(Integer.valueOf(minute));
    }

    private static int getHour(TimePicker picker) {
        return picker.getCurrentHour();
    }

    private static int getMinute(TimePicker picker) {
        return picker.getCurrentMinute();
    }

    public static interface OnDateTimeSetListener {
        public void onDateTimeSet(DatePicker var1, TimePicker var2, int var3, int var4, int var5, int var6, int var7);
    }
}

