/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.picker;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.NumberPicker;
import java.util.ArrayList;
import org.chromium.ui.R;

public class MultiFieldTimePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener {
    private final NumberPicker mHourSpinner;
    private final NumberPicker mMinuteSpinner;
    private final NumberPicker mSecSpinner;
    private final NumberPicker mMilliSpinner;
    private final NumberPicker mAmPmSpinner;
    private final OnMultiFieldTimeSetListener mListener;
    private final int mStep;
    private final int mBaseMilli;
    private final boolean mIs24hourFormat;
    private static final int SECOND_IN_MILLIS = 1000;
    private static final int MINUTE_IN_MILLIS = 60000;
    private static final int HOUR_IN_MILLIS = 3600000;

    public MultiFieldTimePickerDialog(Context context, int theme, int hour, int minute, int second, int milli, int min, int max, int step, boolean is24hourFormat, OnMultiFieldTimeSetListener listener) {
        super(context, theme);
        this.mListener = listener;
        this.mStep = step;
        this.mIs24hourFormat = is24hourFormat;
        if (min >= max) {
            min = 0;
            max = 86399999;
        }
        if (step < 0 || step >= 86400000) {
            step = 60000;
        }
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.multi_field_time_picker_dialog, null);
        this.setView(view);
        this.mHourSpinner = (NumberPicker)view.findViewById(R.id.hour);
        this.mMinuteSpinner = (NumberPicker)view.findViewById(R.id.minute);
        this.mSecSpinner = (NumberPicker)view.findViewById(R.id.second);
        this.mMilliSpinner = (NumberPicker)view.findViewById(R.id.milli);
        this.mAmPmSpinner = (NumberPicker)view.findViewById(R.id.ampm);
        int minHour = min / 3600000;
        int maxHour = max / 3600000;
        min -= minHour * 3600000;
        max -= maxHour * 3600000;
        if (minHour == maxHour) {
            this.mHourSpinner.setEnabled(false);
            hour = minHour;
        }
        if (is24hourFormat) {
            this.mAmPmSpinner.setVisibility(8);
        } else {
            int minAmPm = minHour / 12;
            int maxAmPm = maxHour / 12;
            int amPm = hour / 12;
            this.mAmPmSpinner.setMinValue(minAmPm);
            this.mAmPmSpinner.setMaxValue(maxAmPm);
            this.mAmPmSpinner.setDisplayedValues(new String[]{context.getString(R.string.time_picker_dialog_am), context.getString(R.string.time_picker_dialog_pm)});
            if ((hour %= 12) == 0) {
                hour = 12;
            }
            if (minAmPm == maxAmPm) {
                this.mAmPmSpinner.setEnabled(false);
                amPm = minAmPm;
                if ((minHour %= 12) == 0 && (maxHour %= 12) == 0) {
                    minHour = 12;
                    maxHour = 12;
                } else if (minHour == 0) {
                    minHour = maxHour;
                    maxHour = 12;
                } else if (maxHour == 0) {
                    maxHour = 12;
                }
            } else {
                minHour = 1;
                maxHour = 12;
            }
            this.mAmPmSpinner.setValue(amPm);
        }
        if (minHour == maxHour) {
            this.mHourSpinner.setEnabled(false);
        }
        this.mHourSpinner.setMinValue(minHour);
        this.mHourSpinner.setMaxValue(maxHour);
        this.mHourSpinner.setValue(hour);
        NumberFormatter twoDigitPaddingFormatter = new NumberFormatter("%02d");
        int minMinute = min / 60000;
        int maxMinute = max / 60000;
        min -= minMinute * 60000;
        max -= maxMinute * 60000;
        if (minHour == maxHour) {
            this.mMinuteSpinner.setMinValue(minMinute);
            this.mMinuteSpinner.setMaxValue(maxMinute);
            if (minMinute == maxMinute) {
                this.mMinuteSpinner.setDisplayedValues(new String[]{twoDigitPaddingFormatter.format(minMinute)});
                this.mMinuteSpinner.setEnabled(false);
                minute = minMinute;
            }
        } else {
            this.mMinuteSpinner.setMinValue(0);
            this.mMinuteSpinner.setMaxValue(59);
        }
        this.mMinuteSpinner.setValue(minute);
        if (step % 3600000 == 0) {
            this.mMinuteSpinner.setEnabled(false);
            this.mMinuteSpinner.setValue(minMinute);
        }
        this.mMinuteSpinner.setFormatter((NumberPicker.Formatter)twoDigitPaddingFormatter);
        if (step >= 60000) {
            view.findViewById(R.id.second_colon).setVisibility(8);
            this.mSecSpinner.setVisibility(8);
        }
        int minSecond = min / 1000;
        int maxSecond = max / 1000;
        min -= minSecond * 1000;
        max -= maxSecond * 1000;
        if (minHour == maxHour && minMinute == maxMinute) {
            this.mSecSpinner.setMinValue(minSecond);
            this.mSecSpinner.setMaxValue(maxSecond);
            if (minSecond == maxSecond) {
                this.mSecSpinner.setDisplayedValues(new String[]{twoDigitPaddingFormatter.format(minSecond)});
                this.mSecSpinner.setEnabled(false);
                second = minSecond;
            }
        } else {
            this.mSecSpinner.setMinValue(0);
            this.mSecSpinner.setMaxValue(59);
        }
        this.mSecSpinner.setValue(second);
        this.mSecSpinner.setFormatter((NumberPicker.Formatter)twoDigitPaddingFormatter);
        if (step >= 1000) {
            view.findViewById(R.id.second_dot).setVisibility(8);
            this.mMilliSpinner.setVisibility(8);
        }
        milli = (milli + step / 2) / step * step;
        if (step == 1 || step == 10 || step == 100) {
            if (minHour == maxHour && minMinute == maxMinute && minSecond == maxSecond) {
                this.mMilliSpinner.setMinValue(min / step);
                this.mMilliSpinner.setMaxValue(max / step);
                if (min == max) {
                    this.mMilliSpinner.setEnabled(false);
                    milli = min;
                }
            } else {
                this.mMilliSpinner.setMinValue(0);
                this.mMilliSpinner.setMaxValue(999 / step);
            }
            if (step == 1) {
                this.mMilliSpinner.setFormatter((NumberPicker.Formatter)new NumberFormatter("%03d"));
            } else if (step == 10) {
                this.mMilliSpinner.setFormatter((NumberPicker.Formatter)new NumberFormatter("%02d"));
            } else if (step == 100) {
                this.mMilliSpinner.setFormatter((NumberPicker.Formatter)new NumberFormatter("%d"));
            }
            this.mMilliSpinner.setValue(milli / step);
            this.mBaseMilli = 0;
        } else if (step < 1000) {
            ArrayList<String> strValue = new ArrayList<String>();
            for (int i = min; i < max; i += step) {
                strValue.add(String.format("%03d", i));
            }
            this.mMilliSpinner.setMinValue(0);
            this.mMilliSpinner.setMaxValue(strValue.size() - 1);
            this.mMilliSpinner.setValue((milli - min) / step);
            this.mMilliSpinner.setDisplayedValues(strValue.toArray(new String[strValue.size()]));
            this.mBaseMilli = min;
        } else {
            this.mBaseMilli = 0;
        }
    }

    public void onClick(DialogInterface dialog, int which) {
        this.notifyDateSet();
    }

    private void notifyDateSet() {
        int hour = this.getPickerValue(this.mHourSpinner);
        int minute = this.getPickerValue(this.mMinuteSpinner);
        int sec = this.getPickerValue(this.mSecSpinner);
        int milli = this.getPickerValue(this.mMilliSpinner) * this.mStep + this.mBaseMilli;
        if (!this.mIs24hourFormat) {
            int ampm = this.getPickerValue(this.mAmPmSpinner);
            if (hour == 12) {
                hour = 0;
            }
            hour += ampm * 12;
        }
        this.mListener.onTimeSet(hour, minute, sec, milli);
    }

    private int getPickerValue(NumberPicker picker) {
        picker.clearFocus();
        return picker.getValue();
    }

    private static class NumberFormatter
    implements NumberPicker.Formatter {
        private final String mFormat;

        NumberFormatter(String format) {
            this.mFormat = format;
        }

        public String format(int value) {
            return String.format(this.mFormat, value);
        }
    }

    public static interface OnMultiFieldTimeSetListener {
        public void onTimeSet(int var1, int var2, int var3, int var4);
    }
}

